#include <math.h>
#include "clip.h"
#include "screen.h"

#define lerp(a, b, t) ( a + t * (b - a) )

int outsideBoundaries(const float x, const float y)
{
    register int bits=0;
    if(y < TopClip) bits|=TopBit;
    else if(y > BotClip) bits|=BotBit;
    if(x < LeftClip) bits|=LeftBit;
    else if(x > RightClip) bits|=RightBit;
    return bits;
}

void otherClips(vertex *s, vertex *u, vertex *v, const float delta)
{
 s->_u=lerp(u->_u, v->_u, delta);
 s->_v=lerp(u->_v, v->_v, delta);
 s->p.z=lerp(u->p.z, v->p.z, delta);
 // idem gouro
}

// il ya deux intersections celle du bot dans s celle tu top dans t
void clipEdgeY2(vertex *t, vertex *s, vertex *v1, vertex *v2)
{
 register float dx=v2->p.x-v1->p.x; 
 register float dy=v2->p.y-v1->p.y;
 register float p;

    p = (TopClip - v1->p.y) / dy;
    t->p.y = TopClip;
    t->p.x = v1->p.x + p * dx;
    otherClips(t,v1,v2,p);

  t->clip=0;
 if (t->p.x > RightClip)
  t->clip=RightBit;
 else if (t->p.x < LeftClip)
  t->clip=LeftBit;

    p = (BotClip - v1->p.y) / dy;
    s->p.y = BotClip;
    s->p.x = v1->p.x + p * dx;
    otherClips(s,v1,v2,p);

  s->clip=0;
 if (s->p.x > RightClip)
  s->clip=RightBit;
 else if (s->p.x < LeftClip)
  s->clip=LeftBit;
}

// on a une vertice a l'interieur de l'ecran (la premiere)
// la deuxieme vertice est d'office a l'exterieur
void clipEdgeY(vertex *s, vertex *v1, vertex *v2)
{
 register float dx=v2->p.x-v1->p.x; 
 register float dy=v2->p.y-v1->p.y;

 if(v2->clip&TopBit)
 {
    register float t = (TopClip - v1->p.y) / dy;
    s->p.y = TopClip;
    s->p.x = v1->p.x + t * dx;
    otherClips(s,v1,v2,t);
 }
 else
 {
    register float t = (BotClip - v1->p.y) / dy;
    s->p.y = BotClip;
    s->p.x = v1->p.x + t * dx;
    otherClips(s,v1,v2,t);
 }

  s->clip=0;
 if (s->p.x > RightClip)
  s->clip=RightBit;
 else if (s->p.x < LeftClip)
  s->clip=LeftBit;
}

// il ya deux intersections celle du Left dans s celle du Right dans t
void clipEdgeX2(vertex *t, vertex *s, vertex *v1, vertex *v2)
{
 register float dx=v2->p.x-v1->p.x; 
 register float dy=v2->p.y-v1->p.y;
 register float p;

    p = (RightClip - v1->p.x) / dx;
    t->p.x = RightClip;
    t->p.y = v1->p.y + p * dy;
    otherClips(t,v1,v2,p);

  t->clip=0;

 if (t->p.y > BotClip)
  t->clip=BotBit;
 else if (t->p.y < TopClip)
  t->clip=TopBit;


    p = (LeftClip - v1->p.x) / dx;
    s->p.x = LeftClip;
    s->p.y = v1->p.y + p * dy;
    otherClips(s,v1,v2,p);

  s->clip=0;

 if (s->p.y > BotClip)
  s->clip=BotBit;
 else if (s->p.y < TopClip)
  s->clip=TopBit;

}

void clipEdgeX(vertex *s, vertex *v1, vertex *v2)
{
 register float dx=v2->p.x-v1->p.x; 
 register float dy=v2->p.y-v1->p.y;

 if(v2->clip&LeftBit)
 {
    register float t = (LeftClip - v1->p.x) / dx;
    s->p.x = LeftClip;
    s->p.y = v1->p.y + t * dy;
    otherClips(s,v1,v2,t);
 }
 else
 {
    register float t = (RightClip - v1->p.x) / dx;
    s->p.x = RightClip;
    s->p.y = v1->p.y + t * dy;
    otherClips(s,v1,v2,t);
 }

  s->clip=0;

 if (s->p.y > BotClip)
  s->clip=BotBit;
 else if (s->p.y < TopClip)
  s->clip=TopBit;
}


// renvoie un pointeur vers le polygone cree
// -> tester que le poly sera partielement visible avant d'appeler
M3D_polygon * clip2d(object *objet, M3D_polygon *opoly)
{
   vertex *v=objet->vertices; 
   register int *op=opoly->p;
   register int *np;
   register int i, npnt;

   int more_verts=objet->num_more_verts;
   M3D_polygon *xpoly=objet->polygons+objet->num_more_polys;
   M3D_polygon *ypoly=xpoly+1;
   *ypoly=*opoly; // recopier les zinfos
   np=ypoly->p;

   // on clippe sur y seulement
   for (npnt=i=0; i<opoly->n; ++i)
   {
      register int clip1, clip2;

      clip1=v[op[i]].clip&3;
      clip2=v[op[i+1]].clip&3; 

      if(clip1 & clip2) continue; // un bit en commun -> pas d'intersection

      // ne sort pas des bornes Top et Bot
      if (!clip1 && !clip2)
      {
       // cet edge n'est pas clippe -> le recopier
       np[npnt]=op[i]; ++npnt;
       continue;
      }

      if(clip2 && !clip1)
      {
       np[npnt]=op[i]; ++npnt; // recopier la premiere vertice
       np[npnt]=more_verts; // creation d'une nouvelle vertice
       clipEdgeY(v+more_verts, v+op[i], v+op[i+1]);
       ++more_verts; ++npnt;
      }
      else if(clip1 && !clip2)
      {
       np[npnt]=more_verts; // creation d'une nouvelle vertice
       clipEdgeY(v+more_verts, v+op[i+1], v+op[i]);
       ++more_verts; ++npnt;
      }
      else
      {
       // une vertice en dessous, une vertice au dessu -> deux intersections
       np[npnt]=more_verts; // creation d'une nouvelle vertice
       np[npnt+1]=more_verts+1; // creation d'une nouvelle vertice

       // determiner quel est le premier bord en intersection
       if(clip1&TopBit)
        clipEdgeY2(v+more_verts, v+more_verts+1, v+op[i], v+op[i+1]);
       else
        clipEdgeY2(v+more_verts+1, v+more_verts, v+op[i], v+op[i+1]);

       more_verts+=2; npnt+=2;
      }
   } // fin du for

   np[npnt]=np[0]; // faire cycler
   ypoly->n=npnt;
   *xpoly=*ypoly; // recopier les zinfos
   op=np;
   np=xpoly->p;

   // on clippe sur x seulement
   for (npnt=i=0; i<ypoly->n; ++i)
   {
      register int clip1, clip2;

      clip1=v[op[i]].clip&12;
      clip2=v[op[i+1]].clip&12; 

      if(clip1 & clip2) continue; // un bit en commun -> pas d'intersection

      // ne sort pas des bornes Right et Left
      if (!clip1 && !clip2)
      {
       // cet edge n'est pas clippe -> le recopier
       np[npnt]=op[i]; ++npnt;
       continue;
      }

      if(clip2 && !clip1)
      {
       np[npnt]=op[i]; ++npnt; // recopier la premiere vertice
       np[npnt]=more_verts; // creation d'une nouvelle vertice
       clipEdgeX(v+more_verts, v+op[i], v+op[i+1]);
       ++more_verts; ++npnt;
      }
      else if(clip1 && !clip2)
      {
       np[npnt]=more_verts; // creation d'une nouvelle vertice
       clipEdgeX(v+more_verts, v+op[i+1], v+op[i]);
       ++more_verts; ++npnt;
      }
      else
      {
        // une vertice en dessous, une vertice au dessu -> deux intersections
        np[npnt]=more_verts; // creation d'une nouvelle vertice
        np[npnt+1]=more_verts+1; // creation d'une nouvelle vertice

        // determiner quel est le premier bord en intersection
        if(clip1&RightBit)
         clipEdgeX2(v+more_verts, v+more_verts+1, v+op[i], v+op[i+1]);
        else
         clipEdgeX2(v+more_verts+1, v+more_verts, v+op[i], v+op[i+1]);

        more_verts+=2; npnt+=2;
      }
   } // fin du for

   if (npnt<3) return 0;

   // calculer les ceils des nouvelles vertices
   // une vertice est nouvelle si p[i] est > nbrvertices
   for(i=0; i<npnt; ++i)
    if(np[i]>=objet->num_vertices) v[np[i]].y=(int)ceil(v[np[i]].p.y);

   objet->num_more_verts=more_verts;
   ++objet->num_more_polys;
   
  
  if(objet->num_more_polys-objet->num_polygons>MORE_POLYS) printf("polys overflow\n");
  if(objet->num_more_verts-objet->num_vertices>MORE_VERTS) printf("verts overflow\n");

   
   np[npnt]=np[0]; // faire cycler
   xpoly->n=npnt;
   return xpoly;
}

// le clipping 3d (contre le plan z=1.0)
// v1 est devant le plan v2 est deriere le plan
void clipEdge3d(scene *scene3d, vertex *o, vertex *v1, vertex *v2)
{
 register float delta=(1.0-v1->t.z)/(v2->t.z-v1->t.z);

 o->_u=lerp(v1->um,v2->um,delta);
 o->_v=lerp(v1->vm,v2->vm,delta);
 // idem rgb
 o->p.z=1.0;
 o->p.x=SXDIV2+lerp(v1->t.x,v2->t.x,delta)*scene3d->DIST_PLANEX;
 o->p.y=SYDIV2-lerp(v1->t.y,v2->t.y,delta)*scene3d->DIST_PLANEY;
 o->y=(int)ceil(o->p.y);

 // recalculer le clipcode
 o->clip=outsideBoundaries(o->p.x, o->p.y);
}

// le polygone dois etre en intersection !!
// on est sur que le polygone n'est pas deriere le plan !!
M3D_polygon * clip3d(scene *scene3d, object *objet, M3D_polygon *opoly)
{
 register int i,j,k;
 register vertex *v=objet->vertices;
 register int *op=opoly->p;
 register int *np;
 M3D_polygon *npoly=objet->polygons+objet->num_more_polys;
 int more_verts=objet->num_more_verts;
 
 *npoly=*opoly; // recopier les zinfos
 np=npoly->p;

 // passer les vertices devant le plan
 for(i=0; v[op[i]].t.z>=1.0; ++i); // np[i]=op[i];
 // calculer l'intersection du segment [i-1] [i]
 np[i]=more_verts; ++more_verts;
 if(!i) // remonter en arriere pour trouver un segment d'intersection
 {
  for(j=opoly->n-1; j && (v[op[j]].t.z<1.0); --j);
  if(!j) return 0; // entierement deriere le plan
  k=j+1;
 }
 else {j=i-1; k=i;}
 clipEdge3d(scene3d, v+np[i], v+op[j] , v+op[k]);
 // passer les vertices deriere le plan
 /*j=i+1;*/ for(j=++i; v[op[i]].t.z<1.0; ++i);
 // calculer l'intersection du segment [i] [i-1]
 np[j]=more_verts; ++more_verts;
 clipEdge3d(scene3d, v+np[j], v+op[i] , v+op[i-1]);
 //copier les vertices devant le plan
 for(++j; (i<opoly->n) && (v[op[i]].t.z>=1.0); ++i,++j) np[j]=op[i];

 ++objet->num_more_polys;
 objet->num_more_verts=more_verts;


  if(objet->num_more_polys-objet->num_polygons>MORE_POLYS) printf("polys overflow\n");
  if(objet->num_more_verts-objet->num_vertices>MORE_VERTS) printf("verts overflow\n");

 np[j]=np[0]; // faire cycler
 npoly->n=j;
 return npoly;
}
