#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "aet.h"
#include "tinymath.h"
#include "screen.h"
#include "maxima.h"

// le code de la scan conversion

typedef struct spanptr
{
 int xg; // element accede le plus souvent    
 float _z;        // le 1/z de debut du span
 float _u,_v;     // les coordonees de map du debut du span
 vector i;        // intensite lumineuse pour le gouro rgb
 struct spanptr *next; // listage des spans pour chaque surface
 int xd; // xd pourais etre remplace par une longueur
 int y;
}span;

typedef struct
{
 int state; // alterne debut/fin  init a 0
 span *spanlist; // la liste de spans
 char type;       // flat, dot , wireframe, transparence...
 float d_zdx,d_udx,d_vdx,drdx,dgdx,dbdx; // les 6 valeurs a interpoler
}surface;

typedef struct
{
 surface *surfbegin, *surfend; // un tablo de surfaces ?
 int incxg;
 // une sentinelle marque qu'il n'y a pas de debut ou de fin
 // les increments le long de l'edge pour les valeurs dans s
 float inc_z,inc_u,inc_v,incr,incg,incb;
 span s; // les donnees pour la span qui commence eventuelement
 int yfin; // pas utile si on construit un tableau de suppression
}edge;

// les donnees

span *SPAN_POOL, *real_SPAN_POOL;
surface *SURF_POOL, *real_SURF_POOL;
edge *EDGE_POOL, *real_EDGE_POOL;

// les pointeurs

edge **ET, **GAET, **APL;

// vars de travail

edge **AET; // le AET courant

// compteurs

// le nombre d'elements dans les tables de pointeurs
int NAET;     // le nombre d'edges dans l'AET
int NET[480]; // le nombre d'edges dans l'ET

// le nombre d'elements dans les tables statiques
int EP_INDEX; // le nombre d'edges dans le EdgePool
int SP_INDEX; // le nombre de spans dans le SpanPool
int APL_INDEX;
int SURF_INDEX[MAX_TEXTURES];

// aloue les tableaux et les aligne

int initRasterisation()
{
 // les donnees
 real_SPAN_POOL=(span*)malloc(MAX_SPANS_ON_SCREEN*sizeof(span));
 real_SURF_POOL=(surface*)malloc(MAX_TEXTURES*2048*sizeof(surface));
 real_EDGE_POOL=(edge*)malloc(MAX_ACTIVE_EDGES*sizeof(edge));

 // les pointeurs
 ET=(edge**)malloc(480*256*sizeof(edge*));
 GAET=(edge**)malloc(2*MAX_ACTIVE_EDGES*sizeof(edge*));
 APL=(edge**)malloc(MAX_ACTIVE_EDGES*sizeof(edge*));

 if(!(ET&&GAET&&APL&&real_SPAN_POOL&&real_SURF_POOL&&real_EDGE_POOL))
 {
  if(real_SPAN_POOL) free(real_SPAN_POOL);
  if(real_SURF_POOL) free(real_SURF_POOL);
  if(real_EDGE_POOL) free(real_EDGE_POOL);

  if(ET) free(ET);
  if(GAET) free(GAET);
  if(APL) free(APL);
  return -1;
 }
 
 // alignements sur 32 (1f)

/*
 SPAN_POOL=(span*)(((int)(real_SPAN_POOL+0x1f)) & ~0x1f);
 SURF_POOL=(surface*)(((int)(real_SURF_POOL+0x1f)) & ~0x1f);
 EDGE_POOL=(edge*)(((int)(real_EDGE_POOL+0x1f)) & ~0x1f);
*/

 SPAN_POOL=real_SPAN_POOL;
 SURF_POOL=real_SURF_POOL;
 EDGE_POOL=real_EDGE_POOL;
  
 return 0;
}

void uninitRasterisation()
{
  free(real_SPAN_POOL);
  free(real_SURF_POOL);
  free(real_EDGE_POOL);

  free(ET);
  free(GAET);
  free(APL);
}

// specifie le mode de remplissage pour le background
void initbackground(int type, float r, float g, float b)
{
 // on pourais initialiser les gradients et les coords de map
 // pour faire un rotozoom en fond par exemple ...
 
 EDGE_POOL[0].yfin=(int)BotClip; // -1 ?
 EDGE_POOL[1].yfin=(int)BotClip;
 EDGE_POOL[0].incxg=0;
 EDGE_POOL[1].incxg=0;
 EDGE_POOL[0].inc_z=0;
 EDGE_POOL[1].inc_z=0;
 EDGE_POOL[0].surfbegin=SURF_POOL; // premiere surface
 EDGE_POOL[1].surfend=SURF_POOL;
 EDGE_POOL[1].surfbegin=0;
 EDGE_POOL[0].surfend=0;

 EDGE_POOL[0].s.xg = -65535; 
 EDGE_POOL[1].s.xg = (SX)*65536; 

 EDGE_POOL[0].s._z=0; // tres profond
 EDGE_POOL[1].s._z=0;

 EDGE_POOL[0].s.i.x=r;
 EDGE_POOL[0].s.i.y=g;
 EDGE_POOL[0].s.i.z=b;
 
 SURF_POOL[0].type=type; // le type remplissage flat ou copie bitmap c'est selon
 // les gradients ?
}

#define SENTINEL (-1)
#define ceil_int(x) ((x+0xffff)>>16)

void drawSpanListBackground(surface *surf, int *screen, int largeurScreen)
{
   register span *s=surf->spanlist;

   // parcourir la liste de spans
   while(s) // s=NULL= fin de la liste
   {   
    // obtenir les zinfos -> les ceils devraient etre calcules avant (une seule fois
    // en cas de edge sharing) (des qu'on insere une span?)
    register int j;    

    int longeur=ceil_int(s->xd)-ceil_int(s->xg);
    int begin=ceil_int(s->xg)+s->y*largeurScreen;

    for (j=0;j<longeur;++j)   
     screen[begin+j]=255; // l'info de couleur=r+g=b

    s=s->next; // la span suivante
   } // fin du while d'affichage des spans
}

void drawSpanListTexture(surface *surf, int *map, int *screen, int largeurScreen)
{
   register span *s=surf->spanlist;

   // parcourir la liste de spans
   while(s) // s=NULL= fin de la liste
   {   
    // obtenir les zinfos -> les ceils devraient etre calcules avant (une seule fois
    // en cas de edge sharing) (des qu'on insere une span?)
    register int j;    
    
    int longeur=ceil_int(s->xd)-ceil_int(s->xg);
    int begin=ceil_int(s->xg)+s->y*largeurScreen;

    float u,v,w;
    register int fui,fvi; 

    u=s->_u;
    v=s->_v;
    w=s->_z;
   
    // calculer les valeurs entieres
    fui=(int)(u*65536.0/w);
    fvi=(int)(v*65536.0/w);

    for (j=0; j<longeur-8;)
    {
      register int i;
      register float _w;
      register int du,dv,ui,vi;

      u+=8*surf->d_udx;
      v+=8*surf->d_vdx;
      w+=8*surf->d_zdx;
      _w=65536.0/w;
      
      ui=fui; vi=fvi;
      fui=(int)(u*_w);
      fvi=(int)(v*_w);

      du=(fui-ui)>>3;
      dv=(fvi-vi)>>3;

      for (i=8; i; --i,++j)
      {
       register int offu=(ui>>16)&0xff;
       register int offv=(vi>>8)&0xff00;
       screen[begin+j]=map[offu|offv];
       ui+=du; vi+=dv;
      }
    } // fin du for de la rasterisation
 
    // le bout de span restant 
    if(j<longeur)
    {
      register int i,l;
      register float _w;
      register int du,dv,ui,vi;

      _w=65536/(s->_z+longeur*surf->d_zdx);      
      ui=fui; vi=fvi;
      fui=(int)((s->_u+longeur*surf->d_udx)*_w);
      fvi=(int)((s->_v+longeur*surf->d_vdx)*_w);

      l=longeur-j;
      du=(fui-ui)/l;
      dv=(fvi-vi)/l;

      for (i=l; i; --i, ++j)
      {
       register int offu=(ui>>16)&0xff;
       register int offv=(vi>>8)&0xff00;
       screen[begin+j]=map[offu|offv];
       ui+=du; vi+=dv;      
      }     
    }  

/*
    for (j=0;j<longeur;++j)
    {
      float _z=1.0/w;
      int offset,offset2;
      fist(&offset, v*_z); offset&=0xFF; offset<<=8;
      fist(&offset2, u*_z); offset2&=0xFF; offset+=offset2;

      screen[begin+j]=map[offset];

      u+=surf->d_udx;
      v+=surf->d_vdx;
      w+=surf->d_zdx;
    } // fin du for de la rasterisation
*/
    s=s->next; // la span suivante
   } // fin du while d'affichage des spans
}


// affiche toute les spans de SURFACE_POOL
void drawSpanBuffer(scene *scene3d, int *screen, int largeurScreen)
{
 register int i,t;

 for (t=0; t<MAX_TEXTURES; ++t) // pour toute les maps loadee
 {
  register int *map=(int*)scene3d->textures[t];
  // par convention la texture 0 = texture de background !!

  // on devrais tester si il ya effectivement un span visible ...
  if(!SURF_INDEX[t]) continue; // pas de polys utilisant cette map

  // si pas dans la cache -> decompresser en ecrasant la plus vielle map
  // la texture de background sera toujour dans la cache
  // les rendus n'utilisant pas de map (flat, gouro) utilisent 0 comme num de map

  for (i=0; i<SURF_INDEX[t]; ++i) // pour tous les polys qui usent cette map
  {
   // ici on fait appel a une fonction specifique pour chaque type de remplissage
   //switch(surf->type)
   
   // case TEXTURE: 
   drawSpanListTexture(SURF_POOL+(t<<11)+i, map, screen, largeurScreen); // fonction en asm
   //tiny_inkey();

  } // fin de l'affichage de tous les polys qui usent la meme map
 } // fin du parcours des maps
}

// calcule les gradients entre autres
int InitSurface(scene *scene3d, M3D_polygon *poly, surface *surf)
{
 float dy0,dy1,denom;
 vertex *v0,*v1,*v2;

 v0=poly->vertices+poly->p[0];
 v1=poly->vertices+poly->p[1];
 v2=poly->vertices+poly->p[2];

 // calcul des gradients

 dy0=(v1->p.y - v2->p.y);
 dy1=(v0->p.y - v2->p.y);
 
 denom = (v0->p.x - v2->p.x) * dy0 - (v1->p.x - v2->p.x) * dy1;
 if(!denom) return 1;
 denom=1.0/denom;

 surf->spanlist=0; // liste de span vide a priori
 surf->type=poly->type;
 surf->state=0; // edge begin pas encore trouve

 surf->d_udx=((v0->_u - v2->_u) * dy0 - (v1->_u - v2->_u) * dy1)*denom;
 surf->d_vdx=((v0->_v - v2->_v) * dy0 - (v1->_v - v2->_v) * dy1)*denom;
 surf->d_zdx=((v0->p.z - v2->p.z) * dy0 - (v1->p.z - v2->p.z) * dy1)*denom;
 
 // idem pour le gouro ...

 return 0;
}


// insertion triee si un edge identique existe deja on marque end/begin
int insereET(edge **ET, int *NET, edge *EDGE)
{
 register int xg=EDGE->s.xg;
 
 // parcours jusqu'au premier xg >=
 register int i=0,j=*NET-1;

 if(j==-1)
 {
  // premiere insertion
  ET[0]=EDGE; *NET=1;
  return 1;
 }
 
 while(i<=j)
 {
  register int a=(i+j)>>1;
  if (ET[a]->s.xg < xg) i=a+1; else j=a-1;
 }
 // i contient l'indice

 //if(i>=*NET) printf("i depasse la borne supp\n");

 // cas special insertion en fin
 if(i==*NET)
 {
  ET[i]=EDGE; ++*NET;
  return 1;
 }

 if(ET[i]->s.xg!=xg)
 {
  // decalage
  for(j=*NET; j>i; --j) ET[j]=ET[j-1]; // ce sont des pointeurs
  // insertion
  ET[i]=EDGE; ++*NET;

 //if(*NET>250) tiny_inkey();

  return 1; // insertion effective
 }

 for(; (i<*NET) && (ET[i]->s.xg==xg); ++i)
 if(EDGE->surfbegin)
 {
  if(!ET[i]->surfbegin &&
     ET[i]->yfin==EDGE->yfin &&
     ET[i]->incxg==EDGE->incxg &&
     ET[i]->inc_z==EDGE->inc_z &&
     ET[i]->s._z==EDGE->s._z) // +- epsilon ? -> incxg&FFFFFFF0
   {
    // on a un edge identique
    EDGE->surfend=ET[i]->surfend; // seule info interessante
    *ET[i]=*EDGE; // copie des zinfos (pas des pointeurs)
    return 0;
   }
 }
 else
 {
  if(!ET[i]->surfend &&
     ET[i]->yfin==EDGE->yfin &&
     ET[i]->incxg==EDGE->incxg &&
     ET[i]->inc_z==EDGE->inc_z &&
     ET[i]->s._z==EDGE->s._z) // +- epsilon ? -> incxg&FFFFFFF0 
   {
    // on a un edge identique
    ET[i]->surfend=EDGE->surfend;
    return 0;
   }
 }

 // on n'a pas trouve d'edge qui peut convenir 
 // decalage
 for(j=*NET; (j!=i); --j) ET[j]=ET[j-1]; // ce sont des pointeurs
 // insertion
 ET[i]=EDGE; ++*NET;

//if(*NET>250) tiny_inkey();
 
 return 1; // insertion effective
}




// considere tous les edges de tous les polys et les insere
void createET(scene *scene3d, M3D_polygon **PIPELINE, const int num_polys)
{
 register int i;

 // utiliser un memset
 for (i=0; i<480; ++i) NET[i]=0;
 for (i=0; i<MAX_TEXTURES; ++i) SURF_INDEX[i]=0;

 // les informations de background sont par convention au
 // debut des tables

 ET[((int)TopClip)<<8]=EDGE_POOL; // debut
 ET[(((int)TopClip)<<8)+1]=EDGE_POOL+1; // fin
 EP_INDEX=2; // le nombre d' edges dans le EdgePool
 NET[((int)TopClip)]=2;
 SURF_INDEX[0]=1;

 SURF_POOL[0].spanlist=0;
 SURF_POOL[0].state=0;

 for (i=0; i<num_polys; ++i)
 {
  register int j;
  M3D_polygon *p=PIPELINE[i];
  vertex *v=p->vertices;

  // on aloue une surface pour chaque polygone
  surface *surf=SURF_POOL+(p->map<<11)+SURF_INDEX[p->map];

  // premiere chose : calculer les gradients et les y ecran
  if(InitSurface(scene3d, p, surf)) continue;

  ++SURF_INDEX[p->map];
  //if(SURF_INDEX[p->map]>1000) tiny_inkey();

  // cree un edge entre chaque couple de vertice
  for (j=0; j<p->n; ++j)
  {
   edge *e=EDGE_POOL+EP_INDEX; // incrementer plutot
   span *s=&e->s;

   register int dyi;
   register float dy;
   register vertex *vj,*vj1;

   vj=v+p->p[j];
   vj1=v+p->p[j+1];

   dyi=vj1->y-vj->y;
   if(!dyi) continue; // on skippe les edges horizontaux

   dy=vj1->p.y-vj->p.y; // version float plus de precision ?

   if(dyi<0) //edge de fin
   {
    dy=1.0/dy;

    e->surfbegin=0;    
    e->surfend=surf;
    e->yfin=vj->y-1;    //fin
    s->y=vj1->y;        // debut // on s'en masse car on connais le y de debut
                        // par l'entree dans la ET (sauf si l'et est lineaire

    // infos utile pour le cas fin

    //fist(&s->xg, vj1->p.x*65536.0);
    //fist(&e->incxg, (vj1->p.x-vj->p.x)*dy*65536.0);
    s->xg=(int)(vj1->p.x*65536.0);
    e->incxg=(int)((vj1->p.x-vj->p.x)*dy*65536.0);
    
    s->_z=vj1->p.z;
    e->inc_z=(vj1->p.z-vj->p.z)*dy;
   }
   else
   {
    dy=1.0/dy; 

    e->surfbegin=surf; // pointeur vers la surface de ce edge -> e->leading=1;
    e->surfend=0;
    e->yfin=vj1->y-1;  //fin
    s->y=vj->y;      //debut  -> inutile

    // infos utile pour le cas debut

    //fist(&s->xg, vj->p.x*65536.0);
    s->xg=(int)(vj->p.x*65536.0);
    
    //s->xg=vj->p.x;
    s->_u=vj->_u;
    s->_v=vj->_v;
    s->_z=vj->p.z;

    //fist(&e->incxg, (vj1->p.x-vj->p.x)*dy*65536.0);
    e->incxg= (int)((vj1->p.x-vj->p.x)*dy*65536.0);
   
    //e->incxg=(vj1->p.x-vj->p.x)*dy;
    e->inc_u=(vj1->_u-vj->_u)*dy;
    e->inc_v=(vj1->_v-vj->_v)*dy;
    e->inc_z=(vj1->p.z-vj->p.z)*dy;
   }

   // on aloue un edge

   // insertion triee
   if (insereET(ET+(e->s.y<<8), NET+e->s.y, EDGE_POOL+EP_INDEX))
    ++EP_INDEX;
   //if(EP_INDEX>4000) tiny_inkey();

  }
 }
}



// la fonction vas alterner les tableaux AET1 et 2 car le tri n'est pas en place :-(
void ajoutET_AET(int *NAET, edge **ET, const int NET)
{
 register int i,j,l;
 edge **AETC;
 
 AETC=AET;
 if(AET==GAET) AET=GAET+MAX_ACTIVE_EDGES; else AET=GAET;

 // on insere le minimum entre AETC[j] et ET[i]
 for (j=i=l=0; (i<NET) && (j<*NAET); ++l)
  if(AETC[j]->s.xg < ET[i]->s.xg) 
  {
   AET[l]=AETC[j]; ++j;
  }
  else  
  {
   AET[l]=ET[i]; ++i;
  }

 // un des tableaux ET ou AET est fini -> recopier la fin de l'autre
 if(i==NET) 
  for (; j<*NAET; ++j, ++l) AET[l]=AETC[j]; // copier la fin de l'AET 
 else       
  for (; i<NET; ++i, ++l) AET[l]=ET[i];     // copier la fin de l'ET

 *NAET=l;
 //if (l>4000) tiny_inkey();
}

// insertions suppression des edges dans l'APL

// retourne 1 si insertion en top
int insereSurfaceAPL(edge *EDGE)
{
 float apl_z,surf_z;
 register int i=0,j=APL_INDEX-1;
 int x;

 x=EDGE->s.xg;

 //if(!APL_INDEX) printf("APL vide !!!! pas normal\n");

  
 // comparer avec le top

 surf_z=EDGE->s._z+ceil_int(x-EDGE->s.xg)*EDGE->surfbegin->d_zdx;
 apl_z=APL[j]->s._z+ceil_int(x-APL[j]->s.xg)*APL[j]->surfbegin->d_zdx;

 if(surf_z > apl_z) // insertion en top >=
 {
  APL[APL_INDEX]=EDGE; //surf;
  ++APL_INDEX;
  //if(APL_INDEX>4000) tiny_inkey();

  return 1;
 }
  
 // recherche dichotomique les edges de fin doivent avoir un z :-(
 while(i<=j)
 {
  register int a=(i+j)>>1;   
  // calculer le z pour un x donne
  apl_z=APL[a]->s._z+ceil_int(x-APL[a]->s.xg)*APL[a]->surfbegin->d_zdx;
  if(apl_z < surf_z) i=a+1; else j=a-1;
 }

 // decalage
 for(j=APL_INDEX; (j>i); --j) APL[j]=APL[j-1]; // ce sont des pointeurs

 // insertion
 APL[i]=EDGE;
 ++APL_INDEX;
  //if(APL_INDEX>4000) tiny_inkey();

 return 0;
}


// retourne 1 si suppression en top
// l'APL dois etre non vide et l'element present dans l'apl
int supprimeSurfaceAPL(surface *surf)
{
 register int i=0,j=APL_INDEX-1;

 // il ya toujours un edge dans l'APL (span de background)

//if(!j) printf("on esaye de supprimer la derniere surface !!!\n");

 if(APL[j]->surfbegin==surf) // le top ?
 {
  --APL_INDEX;
//if(!APL_INDEX) tiny_inkey();

  return 1;
 }

 // comme l'APL est triee par _z, faire une recherche dichot sur _z
 for (i=0; APL[i]->surfbegin!=surf; ++i); // la surface se trouve toujours dans l'apl

 // decalage
 for (++i; i<APL_INDEX; ++i) APL[i-1]=APL[i];
 --APL_INDEX;

//if(!APL_INDEX) tiny_inkey();

 return 0;
}


// recuperer les calculs ceil() et enregistrer des coordonees entieres
// pour les spans xg,y,longeur=ints !!
// les spans devraient partager les points de liaison commun (end=next begin)

void createSpanBuffer(scene *scene3d, M3D_polygon **PIPELINE, const int num_polys)
{
 register int i,j,l;

 createET(scene3d, PIPELINE, num_polys);
 SP_INDEX=0; // le nombre de spans dans le SpanPool
 NAET=0; // initialiser l'aet
 AET=GAET; // pas utile car on comence par ajouter ...
 
//printf("ET cree\n");

 // pour chaque ligne, convertir en spans
 for (i=(int)TopClip; i<(int)BotClip; ++i)
 {
  edge e; //l'edge actif courant

  // on ajoute en triant -> une seule passe
  ajoutET_AET(&NAET, ET+(i<<8), NET[i]);

  // toujours deux entrees pour le background
  //if(!NAET) continue;
  //if(NAET<2) printf("- de 2 elem dans l'AET\n");
  
  // on calcule les spans

// on dessine le background que entre les polygones (pas les bords)
// donc inserer la surface dans l'apl mais aussi la deuxiemme

  e=*AET[0]; // pointeur vers l'edge de debut courant (span de background)
  APL[0]=AET[0];  // premiere surface -> le background
  APL_INDEX=1;

//if(!e.surfbegin) printf("not e.surfbegin\n");


  for(j=1; j<NAET-1; ++j) // dernier = d'office un edge de fin...
  {
   register span *s=SPAN_POOL+SP_INDEX; // incrementer plutot

// pour toute les *surfaces* utilisee par l'edge AET[j], inserer ou supprimer
// la surface de l'APL (selon la valeur state de la surface)


// on debute une surface ?
if(AET[j]->surfbegin)
{
 if (++AET[j]->surfbegin->state==1) // fin pas encore rencontree (si croisement)
 {
  // inserer l'edge dans l'apl  (on insere doffice surfbegin)
  if(insereSurfaceAPL(AET[j])) // retourne true si insertion en top
  {
   // generer une span
   *s=e.s;
   s->xd=AET[j]->s.xg;
   s->y=i;

   // on aloue un span
   // on ajoute la span a la surface auquelle appartient cet edge

    s->next=e.surfbegin->spanlist;
    e.surfbegin->spanlist=s;
    ++SP_INDEX;

    //if(SP_INDEX>10000) printf("trop de spans inserees\n");
   
   // nouveau debut
   e=*AET[j];
  } 
 }
}

// on termine une surface ?
if(AET[j]->surfend)
{
 if (--AET[j]->surfend->state==0)  // debut pas rencontre
 {
  // supprimer l'edge dans l'apl (on supprime l'edge dont surfbegin=cette surfend)
  if(supprimeSurfaceAPL(AET[j]->surfend)) // retourne true si suppression en top
  {
   register float f;
   // generer une span
   *s=e.s;
   s->xd=AET[j]->s.xg;
   s->y=i;

   // on aloue un span
   // on ajoute la span a la surface auquelle appartient cet edge

    s->next=e.surfbegin->spanlist;
    e.surfbegin->spanlist=s;
    ++SP_INDEX;
    
    //if(SP_INDEX>10000) printf("trop de span ins a la supr\n");

   // nouveau debut = sommet de l'apl, a partir du x courant

   e=*APL[APL_INDEX-1];
   f=s->xd-e.s.xg;
   f*=(1.0/65536.0);   // pas de sub texel ?
   e.s.xg=s->xd;
   e.s._u+=f*e.surfbegin->d_udx;
   e.s._v+=f*e.surfbegin->d_vdx;
   e.s._z+=f*e.surfbegin->d_zdx;
  }
 }
}


  } // fin du parcours de l'AET


  // on retire les entrees de la aet, l'aet reste triee

  for (l=j=0; j<NAET; ++j)
   if (AET[j]->yfin!=i) {AET[l]=AET[j]; ++l;}
  NAET=l; // nouvelle longeur

  // on avance dans les edge de l'aet

  for (j=0; j<NAET; ++j)
  {   
   register edge *ec=AET[j];
   register span *sc=&ec->s;
   
   sc->xg+=ec->incxg;

   if(ec->surfbegin)
   {
    sc->_z+=ec->inc_z;
    sc->_u+=ec->inc_u;
    sc->_v+=ec->inc_v;
   }


   if(j && (AET[j-1]->s.xg>sc->xg))
   {
    // on trie vers l'arriere (rarement plus de 1 swap :-)
    register int c;
 
    for(c=j; c && (AET[c-1]->s.xg > sc->xg); --c) AET[c]=AET[c-1];
    AET[c]=ec; // insertion
   } // fin du tri

  } // fin du traitement de chaque edge

 } // balayage horizontal (i)
}
