
#include <iostream>
#include "Tunnel.h"

//
//	G E N E R A T O R S 
//

// Standard tunnel

Std_Tunnel::Std_Tunnel( float radius )
{
	rad = radius;
}

void Std_Tunnel::operator () ( float x, float y, int32 &u, int32 &v ) const 
{
	float arc = atan(y/x);
	u = int32(fabs(cos(arc)*rad/x));
	v = int32(arc*256.0/M_PI);
}

// Flat tunnel

Flat_Tunnel::Flat_Tunnel( float div )
{
	k = 1.0/div;
}

void Flat_Tunnel::operator () ( float x, float y, int32 &u, int32 &v ) const
{
	float arc = atan(y/x);
	u = int32((x*x+y*y)*k);
	v = int32(arc*256.0/M_PI);
}

// Weird tunnel

Weird_Tunnel::Weird_Tunnel( float scale )
{
	k = scale;
}

void Weird_Tunnel::operator () ( float x, float y, int32 &u, int32 &v ) const
{ 
	float tmp = 1.0/(x*x+y*y);
	u = int32(k*(x*tmp));
	v = int32(k*(-y*tmp));
}

//
//	S T A N D A R D   3 2 0 x 2 0 0   T U N N E L
//

Tunnel::Tunnel()
{
	uv_offset = 0;
}

Tunnel::Tunnel( const Tunnel_Calc &calc )
{
	uv_offset = 0;
	ushort *p = table;
	for ( float y = -100.0; y < 100.0; y++ )
		for ( float x = -160.0; x < 160.0; x++ ) {
			uint u, v;
			calc( x ? x : 0.001f, y ? y : 0.001f, u, v );
			u &= 0xff;
			v &= 0xff;
			*p++ = v*256+u; 
		}
}


void Tunnel::mix( Tunnel &t1, Tunnel &t2 )
{
	ushort *p = table;
	ushort *p1 = t1.table;
	ushort *p2 = t2.table;
	for ( int i = 0; i < 320*200; i++ )
		*p++ = (*p1++)+(*p2++);
}

void Tunnel::mix2( Tunnel &t1, Tunnel &t2 )
{
	ushort *p = table;
	ushort *p1 = t1.table;
	ushort *p2 = t2.table;
	for ( int i = 0; i < 320*200; i++ )
		*p++ = (((*p1++)+t1.uv_offset)&0xffff)+(((*p2++)+t2.uv_offset)&0xffff);
}

void Tunnel::draw( uint *surface, uint *texture )
{
	ushort *p = table;
	for ( int i = 0; i < 320*200; i++ )
		*surface++ = texture[(ushort)(uv_offset+*p++)];
}

void Tunnel::draw_avg( uint *surface, uint *texture )
{
	ushort *p = table;
	for ( int i = 0; i < 320*200; i++ )
		*surface++ = avg_rgb32( *surface, texture[(ushort)(uv_offset+*p++)] );
}

//
//	B I G   6 4 0 x 4 0 0   T U N N E L  
//

Big_Tunnel::Big_Tunnel()
{
	uv_offset = 0;
	start_offset = 0;
}

Big_Tunnel::Big_Tunnel( const Tunnel_Calc &calc )
{
	uv_offset = 0;
	start_offset = 0;
	ushort *p = table;
	for ( float y = -200.0; y < 200.0; y++ )
		for ( float x = -320.0; x < 320.0; x++ ) {
			uint u, v;
			calc( x ? x : 0.00001f, y ? y : 0.00001f, u, v );
			u &= 0xff;
			v &= 0xff;
			*p++ = v*256+u; 
		}
}

void Big_Tunnel::draw( uint *surface, uint *texture )
{
	ushort *p = table+start_offset;
	for ( int y = 0; y < 200; y++ ) {
		for ( int x = 0; x < 320; x++ )
			*surface++ = texture[(ushort)(uv_offset+*p++)];
		p += 320;
	}
}

void Big_Tunnel::draw_avg( uint *surface, uint *texture )
{
	ushort *p = table+start_offset;
	for ( int y = 0; y < 200; y++ ) { 
		for ( int x = 0; x < 320; x++ )
			*surface++ = avg_rgb32( *surface, texture[(ushort)(uv_offset+*p++)] );
		p += 320;
	}
}

