
// Sprite class - brioche/aspirine - copyleft 199999

#ifndef _SPRITE_H_INCLUDED
#define _SPRITE_H_INCLUDED

#include <ptc.h>
#include "rgb32.h"

class Sprite {

	int x, y, w, h;
	int32 transp, *pixmap;

	inline bool calc_clipping( int &offset, int &nx, int &ny, int &clipw, int &cliph, int &skip );

public:

	static struct clipping_area { int minx, miny, maxx, maxy; } clip;

        Sprite( int32 *pixmap, int w, int h, int32 transp = 0 );

	int get_x() const { return x; };
	int get_y() const { return y; };
	void set_x( int a ) { x = a; };
	void set_y( int a ) { y = a; };	
	int width() const { return w; };
	int height() const { return w; };
	void move_to( int i, int j ) { x = i; y = j; };

	void draw( int32 *surface );
	void draw_avg( int32 *surface );
	void draw_or( int32 *surface );
	void draw_add( int32 *surface );

	void replace( int32 this_color, int32 by_this_one );
	
};

#endif // _SPRITE_H_INCLUDED
