
// Slimy rotating bars - brioche/aspirine <xdefrang@csi.com>
// WARNING - pixelmaps MUST be rotated (90 degrees) and horizontally flipped
// for the sake of cache hit-ratio optimization... and to use less instructions
// to stretch that texture... coders are getting lazier nowadays :)

#ifndef _SLIMY_H_INCLUDED
#define _SLIMY_H_INCLUDED

#include <cmath>
#include <ptc.h>
#include "rgb32.h"


class Slimy_Bar {
protected:
	int cos_up[128], cos_dn[128];
	int width, height, start, length, a1, a2, offset;
	int fx_height;
	int32 *texture;

public:
	Slimy_Bar( int32 *texture, int width, int height, int start = 0, int length = 320 );
	Slimy_Bar( const Slimy_Bar &b ); 
	~Slimy_Bar();

	const Slimy_Bar &operator = ( const Slimy_Bar &b );

	void set_start( int x ) { start = x; };
	void set_length( int x ) { length = x; };

	void update( float t );
	void update( int a, int b, int o = 0 ) { a1 = a; a2 = b; offset = o; }
	void draw( int32 *surface );
	void draw_avg( int32 *surface );
};

class Slimy_Sinus_Bar : public Slimy_Bar {
	float phase, freq;
public:
	Slimy_Sinus_Bar( int32 *texture, int width, int height, int start = 0, int length = 320, float phase = 0, float freq = 1 )
		: Slimy_Bar( texture, width, height, start, length ) { this->phase = phase; this->freq = freq; };

	Slimy_Sinus_Bar( const Slimy_Sinus_Bar &b ) : Slimy_Bar( b ) { phase = b.phase; freq = b.freq; }; 

	void update( float t );
	void update( int a, int b, int o = 0, float p = 0.0, float f = 1.0 ) { a1 = a; a2 = b; offset = o; phase = p; freq = f; };
	void draw( int32 *surface );
	void draw_avg( int32 *surface );
};

#endif // _SLIMY_H_INCLUDED
