
#include "Slimy.h"

//
//	Fixed point division
//

inline int fx_div( int i, int j ) 
{
	return ((long)(i)<<8)/(long)(j);
}

//
//	Slimy_Bar
//

Slimy_Bar::Slimy_Bar( int32 *texture, int width, int height, int start = 0, int length = 320 )
{
	this->start = start;
	this->length = length;
	this->width = width;
	this->height = height;
	this->texture = texture;
	a1 = a2 = offset = 0;
	fx_height = height<<8;
	for ( int k = 0; k < 128; k++ ) {
		cos_up[k] = (int)(fx_height*cos(k*2.0*M_PI/512.0));
		cos_dn[k] = (int)(fx_height*cos((128-k)*2.0*M_PI/512.0));
	}
}

Slimy_Bar::Slimy_Bar( const Slimy_Bar &b )
{
	start = b.start;
	length = b.length;
	width = b.width;
	height = b.height;
	texture = b.texture;
	a1 = b.a1;
	a2 = b.a2;
	offset = b.offset;
	fx_height = height<<8;
	for ( int k = 0; k < 128; k++ ) {
		cos_up[k] = (int)(fx_height*cos(k*2.0*M_PI/512.0));
		cos_dn[k] = (int)(fx_height*cos((128-k)*2.0*M_PI/512.0));
	}
}

const Slimy_Bar &Slimy_Bar::operator = ( const Slimy_Bar &b )
{
	if ( this != &b ) {
		start = b.start;
		length = b.length;
		width = b.width;
		height = b.height;
		texture = b.texture;
		a1 = b.a1;
		a2 = b.a2;
		offset = b.offset;
		fx_height = height<<8;
		for ( int k = 0; k < 128; k++ ) {
			cos_up[k] = (int)(fx_height*cos(k*2.0*M_PI/512.0));
			cos_dn[k] = (int)(fx_height*cos((128-k)*2.0*M_PI/512.0));
		}
	}
	return *this;
}

void Slimy_Bar::update( float t )
{
	a1 = int(200*cos(t*M_PI*0.25));
	a2 = int(100*sin(t*M_PI*0.75));
	offset = int(t*100);
}


void Slimy_Bar::draw( uint *surface )
{
	int a = a1<<8;
	int inc_a = ((a2-a1)<<8)/320;

	int32 *tex_ptr = texture+offset*height; 
	int32 *surf_ptr = surface+start;

	for ( int x = 0; x < length; x++, a += inc_a, tex_ptr += height, surf_ptr++ ) {
		int ang = a>>8;
		while ( ang > 127) ang -= 128;
		while ( ang < 0 ) ang += 128;
		if ( ang == 0 ) {
			int32 *tp = tex_ptr;
			int32 *sp = surf_ptr+(height>>1)*320;
			for ( int y = 0; y < height; y++ ) {
				*sp = *tp;
				sp += 320;
				tp++;
			}
		} else {
			int len_up = cos_up[ang];
			int len_dn = cos_dn[ang];
			int inc_up = fx_div( fx_height, len_up );
			int inc_dn = fx_div( fx_height, len_dn );
			int y = height-((len_up+len_dn)>>9); 
			int32 *sp = surf_ptr+y*320;
			// upper section
			for ( int v = 0; v < fx_height; v += inc_up ) {
				*sp = tex_ptr[v>>8];
				sp += 320;
			}
			// lower section
			for ( int v = 0; v < fx_height; v += inc_dn ) {
				*sp = tex_ptr[v>>8];
				sp += 320;
			}
		}
	}
}

void Slimy_Bar::draw_avg( uint *surface )
{
	int a = a1<<8;
	int inc_a = ((a2-a1)<<8)/320;

	int32 *tex_ptr = texture+offset*height; 
	int32 *surf_ptr = surface+start;

	for ( int x = 0; x < length; x++, a += inc_a, tex_ptr += height, surf_ptr++ ) {
		int ang = a>>8;
		while ( ang > 127) ang -= 128;
		while ( ang < 0 ) ang += 128;
		if ( ang == 0 ) {
			int32 *tp = tex_ptr;
			int32 *sp = surf_ptr+(height>>1)*320;
			for ( int y = 0; y < height; y++ ) {
				*sp = avg_rgb32( *tp, *sp );
				sp += 320;
				tp++;
			}
		} else {
			int len_up = cos_up[ang];
			int len_dn = cos_dn[ang];
			int inc_up = fx_div( fx_height, len_up );
			int inc_dn = fx_div( fx_height, len_dn );
			int y = height-((len_up+len_dn)>>9); 
			int32 *sp = surf_ptr+y*320;
			// upper section
			for ( int v = 0; v < fx_height; v += inc_up ) {
				*sp = avg_rgb32( tex_ptr[v>>8], *sp );
				sp += 320;
			}
			// lower section
			for ( int v = 0; v < fx_height; v += inc_dn ) {
				*sp = avg_rgb32( tex_ptr[v>>8], *sp );
				sp += 320;
			}
		}
	}
}

//
//	Slimy_Sinus_Bar
//

void Slimy_Sinus_Bar::update( float t )
{
}

void Slimy_Sinus_Bar::draw( uint *surface )
{
	int a = a1<<8;
	int inc_a = ((a2-a1)<<8)/320;

	int32 *tex_ptr = texture+offset*height; 
	int32 *surf_ptr = surface+start;

	float rho = phase;

	for ( int x = 0; x < length; x++, a += inc_a, tex_ptr += height, surf_ptr++, rho += freq ) {
		int top = int(20+10*sin(rho*M_PI/64.0));
		int ang = a>>8;
		while ( ang > 127) ang -= 128;
		while ( ang < 0 ) ang += 128;
		if ( ang == 0 ) {
			int32 *tp = tex_ptr;
			int32 *sp = surf_ptr+(top+(height>>1))*320;
			for ( int y = 0; y < height; y++ ) {
				*sp = *tp;
				sp += 320;
				tp++;
			}
		} else {
			int len_up = cos_up[ang];
			int len_dn = cos_dn[ang];
			int inc_up = fx_div( fx_height, len_up );
			int inc_dn = fx_div( fx_height, len_dn );
			int y = top+height-((len_up+len_dn)>>9); 
			int32 *sp = surf_ptr+y*320;
			// upper section
			for ( int v = 0; v < fx_height; v += inc_up ) {
				*sp = tex_ptr[v>>8];
				sp += 320;
			}
			// lower section
			for ( int v = 0; v < fx_height; v += inc_dn ) {
				*sp = tex_ptr[v>>8];
				sp += 320;
			}
		}
	}
}

void Slimy_Sinus_Bar::draw_avg( uint *surface )
{
	int a = a1<<8;
	int inc_a = ((a2-a1)<<8)/320;

	int32 *tex_ptr = texture+offset*height; 
	int32 *surf_ptr = surface+start;

	float rho = phase;

	for ( int x = 0; x < length; x++, a += inc_a, tex_ptr += height, surf_ptr++, rho += freq ) {
		int top = int(20+10*sin(rho*M_PI/64.0));
		int ang = a>>8;
		while ( ang > 127) ang -= 128;
		while ( ang < 0 ) ang += 128;
		if ( ang == 0 ) {
			int32 *tp = tex_ptr;
			int32 *sp = surf_ptr+(top+(height>>1))*320;
			for ( int y = 0; y < height; y++ ) {
				*sp = avg_rgb32( *tp, *sp );
				sp += 320;
				tp++;
			}
		} else {
			int len_up = cos_up[ang];
			int len_dn = cos_dn[ang];
			int inc_up = fx_div( fx_height, len_up );
			int inc_dn = fx_div( fx_height, len_dn );
			int y = top+height-((len_up+len_dn)>>9); 
			int32 *sp = surf_ptr+y*320;
			// upper section
			for ( int v = 0; v < fx_height; v += inc_up ) {
				*sp = avg_rgb32( tex_ptr[v>>8], *sp );
				sp += 320;
			}
			// lower section
			for ( int v = 0; v < fx_height; v += inc_dn ) {
				*sp = avg_rgb32( tex_ptr[v>>8], *sp );
				sp += 320;
			}
		}
	}
}

