
#include "Rect.h"

void rect( int x, int y, int w, int h, int32 color, int32 *surface )
{	
	int32 *p = surface+y*320+x;
	int32 *p2 = p+w-1;
	memset32( p, color, w );
	memset32( p+(h-1)*320, color, w );
	for ( int y = 1; y < h-1; y++ ) {
		*p = *p2 = color;
		p += 320;
		p2 += 320;
	}
}

void rect_avg( int x, int y, int w, int h, int32 color, int32 *surface )
{
	int32 *p = surface+y*320+x;
	int32 *p2 = p+(h-1)*320;
	int i = w;
	memavg32( p, color, w );
	memavg32( p2, color, w );
	p = surface+(y+1)*320+x;
	p2 = p+w-1;
	for ( int y = 1; y < h-1; y++ ) {
		*p = avg_rgb32( *p, color );
		*p2 = avg_rgb32( *p2, color );
		p += 320;
		p2 += 320;
	}
}

void fillrect( int x, int y, int w, int h, int32 color, int32 *surface )
{
	int32 *p = surface+y*320+x;
	while ( h-- ) {
		memset32( p, color, w );		
		p += 320;
	}
}

void fillrect_avg( int x, int y, int w, int h, int32 color, int32 *surface )
{
	int32 *p = surface+y*320+x;
	while ( h-- ) {
		memavg32( p, color, w );
		p += 320;
	}
}

void copyrect( int x, int y, int w, int h, int32 *pixmap, int32 *surface )
{
	int32 *p = surface+y*320+x;
	int32 *p2 = pixmap+y*320+x;
	while ( h-- ) {
		memcpy32( p, p2, w );		
		p += 320;
		p2 += 320;
	}
}

void copyrect_avg( int x, int y, int w, int h, int32 *pixmap, int32 *surface )
{
	int32 *p = surface+y*320+x;
	int32 *p2 = surface+y*320+x;
	while ( h-- ) {
		memavg32( p, p2, w );
		p += 320;
		p2 += 320;
	}
}

