
#ifndef _GRID_H_INCLUDED
#define _GRID_H_INCLUDED

#include <ptc.h>
#include "ShadeTable.h"

//
// !! check out typedef's at the end of this file !!
//

struct Grid_Item {
	int32 r, g, b, u, v, i;
};

// 4x4 pixels linear interpolation grid
template <unsigned width, unsigned height> class Lerp_Grid_4x4 {
public:
	Grid_Item grid[width][height];

        void lerp_rgb( int32 *surface );
        void lerp_uv( int32 *surface, int32 *texture );
        void lerp_uvi( int32 *surface, char8 *texture, const Shade_Table &shade );

        void lerp_rgb_avg( int32 *surface );
        void lerp_uv_avg( int32 *surface, int32 *texture );
        void lerp_uvi_avg( int32 *surface, char8 *texture, const Shade_Table &shade );

};

// 8x8 pixels linear interpolation grid
template <unsigned width, unsigned height> class Lerp_Grid_8x8 {
public:
	Grid_Item grid[width][height];

        void lerp_rgb( int32 *surface );
        void lerp_uv( int32 *surface, int32 *texture );
        void lerp_uvi( int32 *surface, char8 *texture, const Shade_Table &shade );

        void lerp_rgb_avg( int32 *surface );
        void lerp_uv_avg( int32 *surface, int32 *texture );
        void lerp_uvi_avg( int32 *surface, char8 *texture, const Shade_Table &shade );

};

typedef Lerp_Grid_4x4<81,51> Grid_4x4_320x200;
typedef Lerp_Grid_8x8<41,26> Grid_8x8_320x200;

// that piss me off... I can't have precompilation of templates to work... anyone??? ;)
#include "Grid.cc"

#endif // _GRID_H_INCLUDED
