
#include "FDFloor.h"

// Constructor
Free_Direction_Floor::Free_Direction_Floor() : Texture_Warper( true )
{
	angle_x = angle_y = angle_z = 0.0;	
	focus_x = focus_y = 400.0;
	wave_index = 0.0;
	u_offset = v_offset = 0;
}

// rotation matrix precalc
void Free_Direction_Floor::init_calc()
{
	mtx.rotate_xyz( angle_x, angle_y, angle_z );
}

//
void Free_Direction_Floor::calc( int x, int y, Grid_Item &item )
{
	Vector ray( 160.0-x, 100.0-y, 128.0 );
	Vector inter = mtx*ray;
	if ( wave_ampl )
		inter.z += wave_ampl*sin((x)*M_PI/128)+wave_ampl*sin((y)*M_PI/128);

	item.i = int(64.0+(inter.z*0.6));
	if ( item.i < 0 )
		item.i = 0;

	inter.z += 180.0;

	item.u = int(128+(inter.x*focus_x/inter.z)+u_offset);
	item.v = int(128+(inter.y*focus_y/inter.z)+v_offset);
	
}
