
#include "Cube.h"

//
//	BASE
//

Cube_Base::Cube_Base( int n, int32 color, float centx, float centy, float centz ) : rot()
{
	col = color;
	cx = centx;
	cy = centy;
	cz = centz;
	fx = fy = 256.0f;
	nvert = n;
	vert = new Vector [nvert];
	pts = new Poly_Point [nvert];
	
}

Cube_Base::~ Cube_Base()
{
	delete [] vert;
	delete [] pts;
}

// rotate and project
void Cube_Base::transform()
{
	for ( int i = 0; i < nvert; i++ ) {
		Vector tmp = rot*vert[i];
		tmp.z += cz;
		pts[i].x = int(cx+(tmp.x*fx/tmp.z));	
		pts[i].y = int(cy+(tmp.y*fy/tmp.z));	
	}
}

//
//	WIREFRAME CUBE
//

Cube::Cube( float size, int32 color, float centx, float centy, float centz ) : Cube_Base(8,color,centx,centy,centz)
{
	float sz = size*0.5f;
	vert[0].x = -sz; vert[0].y = -sz; vert[0].z = sz;
	vert[1].x = +sz; vert[1].y = -sz; vert[1].z = sz;
	vert[2].x = +sz; vert[2].y = +sz; vert[2].z = sz;
	vert[3].x = -sz; vert[3].y = +sz; vert[3].z = sz;
	vert[4].x = -sz; vert[4].y = -sz; vert[4].z = -sz;
	vert[5].x = +sz; vert[5].y = -sz; vert[5].z = -sz;
	vert[6].x = +sz; vert[6].y = +sz; vert[6].z = -sz;
	vert[7].x = -sz; vert[7].y = +sz; vert[7].z = -sz;
}

void Cube::draw( int32 *surface )
{
	Cube_Base::transform();
	sc_polygon( pts, 4, col, surface );
	sc_polygon( pts+4, 4, col, surface );
	for ( int i = 0; i < 4; i++ ) 
		sc_line( pts[i], pts[i+4], col, surface );

}

//
//	WIREFRAME CUBE WITH LINES ALMOST EVERYWHERE
//

Cube2::Cube2( float size, int32 color, float centx, float centy, float centz ) : Cube_Base(5*5*3*2,color,centx,centy,centz)
{
	Vector *vp = vert;
	for ( float i = -2.0f; i <= 2.0f; i++ ) {
		for ( float j = -2.0f; j <= 2.0f; j++ ) {

			vp->x = 2.0f*size;
			vp->y = i*size;
			vp->z = j*size;
			vp[1].x = -vp->x;
			vp[1].y = i*size;
			vp[1].z = j*size;
			vp += 2;
			
			vp->x = i*size;
			vp->y = 2.0f*size;
			vp->z = j*size;
			vp[1].x = i*size;
			vp[1].y = -vp->y;
			vp[1].z = j*size;
			vp += 2;

			vp->x = i*size;
			vp->y = j*size;
			vp->z = 2.0f*size;
			vp[1].x = i*size;
			vp[1].y = j*size;
			vp[1].z = -vp->z;
			vp += 2;


		}
	}
}

void Cube2::draw( int32 *surface )
{
	Cube_Base::transform();
	for ( int i = 0; i < nvert; i += 2 ) 
		sc_line( pts[i], pts[i+1], col, surface );
}

