#include "main.h"
#include "padconst.h"
#include "engine.h"
#include "loadlwo.h"
#include "util.h"

static void SetSchwarzeBalken(int schwarz);
static void SetWeisseLinie(int level, int fak=4096);
static void SetSchrift(int level);

static int SchriftOPos, SchriftOVel, SchriftUPos, SchriftUVel;
static int SchriftLPos;


TIM_IMAGE TIMPart1Back;
extern "C" char M_01bck1[], M_01bsh1[], M_01bsh2[];

static int startframe;

int Part1Init(int frame)
{
  LoadTIM(M_01bck1, &TIMPart1Back);
  LoadTIM(M_01bsh1);
  LoadTIM(M_01bsh2);
  startframe=frame;
  SchriftLPos=0;
  return 0;
}

int Part1Frame(int frame)
{
  frame-=startframe;
  int fak, add;

  if (frame<64)
  {
    fak=4096;
    add=(64-frame)*4;
  } else if (frame<(8*50))
  {
    fak=4096;
    add=0;
  } else
  {
    fak=4096-(frame-8*50)*50;
    if (fak<0)  // end of part
      return 1;
    add=0;
  }
  

   // set brightness
  u_short clut[256];
  for (int i=0; i<256; i++)
  {
    int clute=((u_short*)TIMPart1Back.caddr)[i];
    int tr=(clute&0x1F)<<3;
    int tg=((clute>>5)&0x1F)<<3;
    int tb=((clute>>10)&0x1F)<<3;
    tr*=fak;
    tr/=4096;
    tr+=add;
    if (tr>255)
      tr=255;
    tg*=fak;
    tg/=4096;
    tg+=add;
    if (tg>255)
      tg=255;
    tb*=fak;
    tb/=4096;
    tb+=add;
    if (tb>255)
      tb=255;

    clut[i]=(tr>>3)|((tg>>3)<<5)|((tb>>3)<<10);
  }

  RECT rect;
  rect.x=0;
  rect.y=482;
  rect.w=256;
  rect.h=1;

  LoadImage(&rect, (unsigned long*)clut);
  DrawSync(0);  // wait until it's loaded.. :)
  if (frame<(8*50))
  {
    SchriftOPos=24;
    SchriftOVel=0;
    SchriftUPos=198;
    SchriftUVel=0;
    if (frame>100)
    {
      int schwarz=frame-100;
      if (schwarz>32)
        schwarz=32;
      SetSchwarzeBalken(schwarz);
    }
  
    if (frame>132)
    {
      int diff=(200*4096)-SchriftLPos;
      if (diff<(4096*10))
        diff=0;
      SchriftLPos+=diff/30;

      int linie=(frame-132)*4;
      if (linie>320)
        linie=320;
      SetWeisseLinie(linie);

      SetSchrift(SchriftLPos/4096);
    }
  } else
  {
    SchriftOVel++;
    if (frame>420)
      SchriftUVel++;
    SetSchwarzeBalken(32);
    SetWeisseLinie(320, fak);
    SetSchrift(SchriftLPos/4096);
  }

    // show picture
  introShowPicture(640, 0, getClut(0, 482), 1, 0x7F7F7F);
  return 0;
}

int Part1Close()
{
#ifdef DEBUG
  printf("closing scene 2 ... SHOULD delete objects here.\n");
#endif
  return 0;
}

static void SetSchwarzeBalken(int schwarz)
{
  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_F4 *pf4=(POLY_F4*)startp;
  u_long *ot=_curdisplayp->ot;

  setPolyF4(pf4);

  pf4->r0=pf4->g0=pf4->b0=0;
  pf4->x0=0;
  pf4->y0=0;
  pf4->x1=320;
  pf4->y1=0;

  pf4->x2=0;
  pf4->y2=schwarz;

  pf4->x3=320;
  pf4->y3=schwarz;
  addPrim(ot+1, pf4);
  pf4++;

  setPolyF4(pf4);

  pf4->r0=pf4->g0=pf4->b0=0;
  pf4->x0=0;
  pf4->y0=240-schwarz;
  pf4->x1=320;
  pf4->y1=240-schwarz;

  pf4->x2=0;
  pf4->y2=240;

  pf4->x3=320;
  pf4->y3=240;
  addPrim(ot+1, pf4);
  pf4++;

  _curdisplayp->wspacepos += (char *)pf4 - startp;
}

static void SetWeisseLinie(int level, int fak)
{
  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  LINE_F2 *plf2=(LINE_F2*)startp;
  u_long *ot=_curdisplayp->ot;

  plf2->r0=plf2->g0=plf2->b0=255*fak/4096;
  plf2->x0=0;
  plf2->y0=32;
  plf2->x1=level;
  plf2->y1=32;
  setLineF2(plf2);

  addPrim(ot+2, plf2);
  plf2++;

  plf2->r0=plf2->g0=plf2->b0=255*fak/4096;
  plf2->x0=320-level;
  plf2->y0=240-32;
  plf2->x1=320;
  plf2->y1=240-32;
  setLineF2(plf2);

  addPrim(ot+2, plf2);
  plf2++;

  _curdisplayp->wspacepos += (char *)plf2 - startp;
}

static void SetSchrift(int level)
{

  int clut=getClut(0, 481);
  int tpage=getTPage(0, 0, 832, 0);

  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  setPolyFT4(pft4);

  pft4->r0=128;
  pft4->g0=128;
  pft4->b0=128;

  pft4->clut=clut;

  pft4->tpage=tpage;

  pft4->x0=320-level;
  pft4->y0=SchriftOPos;

  pft4->x1=320-level+167;
  pft4->y1=SchriftOPos;

  pft4->x2=320-level;
  pft4->y2=SchriftOPos+17;

  pft4->x3=320-level+167;
  pft4->y3=SchriftOPos+17;

  SchriftOPos+=SchriftOVel/8;
  if (SchriftOPos>300)
    SchriftOPos=300;

  pft4->u0=0;
  pft4->v0=0;

  pft4->u1=167;
  pft4->v1=0;

  pft4->u2=0;
  pft4->v2=0+17;

  pft4->u3=167;
  pft4->v3=0+17;
  addPrim(ot+3, pft4);
  pft4++;

  setPolyFT4(pft4);

  pft4->r0=128;
  pft4->g0=128;
  pft4->b0=128;

  pft4->clut=clut;

  pft4->tpage=tpage;

  pft4->x0=level-167;
  pft4->y0=SchriftUPos;

  pft4->x1=level;
  pft4->y1=SchriftUPos;

  pft4->x2=level-167;
  pft4->y2=SchriftUPos+17;

  pft4->x3=level;
  pft4->y3=SchriftUPos+17;

  SchriftUPos+=SchriftUVel/8;
  if (SchriftUPos>300)
    SchriftUPos=300;

  pft4->u0=0;
  pft4->v0=17;

  pft4->u1=167;
  pft4->v1=17;

  pft4->u2=0;
  pft4->v2=17+17;

  pft4->u3=167;
  pft4->v3=17+17;
  addPrim(ot+3, pft4);
  pft4++;

  _curdisplayp->wspacepos += (char *)pft4 - startp;
}
