#include "main.h"
#include "padconst.h"
#include "engine.h"
#include "util.h"
#include "loadlwo.h"

int logoFrame(int i);

static TIM_IMAGE TIMWTCLogo;

static int initialized=0, startf, lastdamage=0;

extern "C" char WTCLogo[];
extern "C" char M_01bck1[], M_01bsh1[], M_01bsh2[];

int logoInit(int frame)
{
#ifdef DEBUG
  printf("loadtim.\n");
#endif
//  LoadTIM(M_01bck1, &TIMWTCLogo);
  LoadTIM(WTCLogo, &TIMWTCLogo);
#ifdef DEBUG
  printf("oke.\n");
#endif
  startf=frame;
  lastdamage=0;

  u_short clut[256];
  for (int i=0; i<256; i++)
  {
    int clute=((u_short*)TIMWTCLogo.caddr)[i];
    int tr=clute&0x1F;
    int tg=(clute>>5)&0x1F;
    int tb=(clute>>10)&0x1F;
    tr=tg=tb=(tr+tg+tb+tr)<<1;

    clut[i]=(tr>>3)|((tg>>3)<<5)|((tb>>3)<<10);
  }
  
  RECT rect;
  rect.x=0;
  rect.y=481;
  rect.w=256;
  rect.h=1;

  LoadImage(&rect, (unsigned long*)clut);
  return 0;
}

short pos[256][2];

#define WATERLIKE

int logoFrame(int frame)
{
  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  int clut=getClut(0, 480);
  int bwclut=getClut(0, 481);
  int tpage=getTPage(1, 0, 640, 0);
  int fade;

  frame-=startf;

  if (frame<256)
    fade=frame*frame/256;
  else if (frame<500)
    fade=255;
  else
    fade=255-((frame-500)*2);

  if (fade<0)
  {
    initialized--;
    return 1; // part is over.
  }

  if ((rnd(frame)%76==75) && ((lastdamage-frame)<16))
    lastdamage=frame;

  int damaged=lastdamage+16-frame;
  if (damaged<0)
    damaged=0;
  fade-=damaged;
  if (fade<0)
    fade=0;
  if (damaged)
    clut=bwclut;
  damaged<<=1;


// #ifdef WATERLIKE
  if (!damaged)
  {
  for (int y=0; y<16; y++)
    for (int x=0; x<16; x++)
    {
      int u=x*20, v=y*15;
      pos[y*16+x][0]=u+(rsin(x*310+frame*256)>>10);
      pos[y*16+x][1]=v+(rsin(y*200+frame*110+768)>>10);
    }
  } else
// #else
  {

  for (int y=0; y<16; y++)
    for (int x=0; x<16; x++)
    {
      int u=x*20, v=y*15;
      if (damaged)
      {
        int ou=u;
        u^=damaged+(v*damaged)&63;
        u^=v;
        u=u + ((ou-u)*damaged)/16;
      }
      pos[y*16+x][0]=u;
      pos[y*16+x][1]=v;
    }
  }
// #endif
  for (int y=0; y<16; y++)
    for (int x=0; x<16; x++)
    {
      setPolyFT4(pft4);

      pft4->r0=pft4->g0=pft4->b0=fade;

      pft4->x0=pos[y*16+x][0];
      pft4->y0=pos[y*16+x][1];
    
      pft4->x1=pos[y*16+x+1][0];
      pft4->y1=pos[y*16+x+1][1];
    
      pft4->x2=pos[y*16+x+16][0];
      pft4->y2=pos[y*16+x+16][1];
    
      pft4->x3=pos[y*16+x+17][0];
      pft4->y3=pos[y*16+x+17][1];
    
      pft4->clut=clut;
      pft4->tpage=tpage;
    
      pft4->u0=x<<4;
      pft4->v0=y<<4;
    
      pft4->u1=(x<<4)+15;
      pft4->v1=y<<4;
    
      pft4->u2=x<<4;
      pft4->v2=(y<<4)+15;
    
      pft4->u3=(x<<4)+15;
      pft4->v3=(y<<4)+15;
      addPrim(ot, pft4);
      pft4++;
    }

  _curdisplayp->wspacepos += (char *)pft4 - startp;

  return 0;
}


int logoClose()
{
  return 0;
}
