#ifndef __ENGINE_H
#define __ENGINE_H

#include <sys/types.h>
#include <stdio.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libcd.h>
#include <kernel.h>


struct pos_s
{
  VECTOR v;
  SVECTOR r;
};

struct goraud_s
{
  CVECTOR point[3];
};

struct object_s;

#define FF_VISIBLE 1

struct scene_s;

struct face_s
{
  int type;             // :1   - flat
                        // :2   - texture  (exclusive?!)
                        // :4   - wireframe
                        // :8   - 2sided (do not cull)
  SVECTOR pos[3];
  SVECTOR normal;
  CVECTOR col[4];    // code of first DOES matter. ... 4th is for wireframe (code must be set)
	u_char	u0, v0;	u_short	clut;
	u_char	u1, v1;	u_short	tpage;
	u_char	u2, v2;	u_short	pad1;
};

struct particle_s
{
  SVECTOR pos;
  u_char u0, v0; u_short clut;
  u_char u1, v1; u_short tpage;
  u_char u2, v2; u_short pad1;
  u_char u3, v3; u_short pad2;
  int sizex, sizey;
};

struct object_s
{
  scene_s *scene;
  object_s *parent;             // 0 for root
  object_s **child;             // 0 is last child, all coords are relative
                                // to parent;
  MATRIX matrix, omatrix;

  pos_s pos;
  int matval;

  VECTOR scale; // don't use...

  int faces;

  SVECTOR *ovnormal, *vnormal;

    //   -----------------------------------
  SVECTOR *point;   // points
  int *face_point;  // 3*faces
  int *face_surfaceid;
    //   -----------------------------------

  int points;

  face_s *face;

  particle_s *particle;
  int particles;

  void tfBegin();                   // (erstellt die einheitsmatrix)
//  void tfMatrixA(const MATRIX mat);      // (kombiniert eine matrix dazu, after)
  void tfMatrixB(const MATRIX mat);      // (kombiniert eine matrix dazu, before)
  void tfEnd();                     // (ruft dann Clip, Transform, Project auf)

  void MakeMatrix(MATRIX &matrix);
  void Clip();
  void TransProj();
  void TransNormals();

  void Lighting();

  void CalcNormals();

  void TransferPoints();

  void Initialize();
  void Free();
};

struct camera_s
{
  pos_s pos;
  MATRIX matrix;
  int matval;
  int fov;
  void MakeMatrix();
};

struct scene_s
{
  MATRIX l_dir;
  MATRIX l_color;
  object_s *root;
  camera_s camera;
};

void DrawObject(object_s *ob);
int  engineOpen();
void engineClose();
void engineRender(scene_s *scene);

void engineSetOption(int flags);

extern MATRIX  _identity;


#endif
