/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.NotImplementedException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SEVariableAssignment;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.InvalidUnlockedSideEffectValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;

public abstract class ReferenceValue
extends SymbolScopeValue {
    protected Value value;

    protected ReferenceValue() {
    }

    public ReferenceValue(Value value) {
        this.value = value == null ? null : value.deReference();
    }

    @Override
    public Value deReference() {
        return this.value;
    }

    @Override
    public boolean keepInNextPass() {
        return false;
    }

    @Override
    public void initBeforeParse() {
    }

    @Override
    public void setValue(Value value, EvaluationState evaluationState, DebugInfo debugInfo) {
        this.value = value.deReference();
        if (value.isInvalidOrInvalidContent()) {
            evaluationState.setInvalidSideEffectsDuringFunctionEvaluation();
        }
        Value value2 = value.isLocked() ? value : new InvalidUnlockedSideEffectValue(debugInfo);
        SEVariableAssignment sEVariableAssignment = new SEVariableAssignment(value2, this);
        evaluationState.addSideEffect(sEVariableAssignment);
    }

    @Override
    public void setWithoutSideEffect(Value value) {
        this.value = value;
    }

    @Override
    public String getType() {
        return this.value.getType();
    }

    @Override
    public Object getRepresentation(int n) {
        return this.value.getRepresentation(n);
    }

    @Override
    public boolean hasRepresentation(int n) {
        return this.value.hasRepresentation(n);
    }

    @Override
    public void lock(DebugInfo debugInfo) {
        this.value.lock(debugInfo);
    }

    @Override
    public boolean isLocked() {
        return this.value.isLocked();
    }

    @Override
    public boolean isInvalid() {
        return this.value.isInvalid();
    }

    @Override
    public boolean hasInvalidContent() {
        return this.value.hasInvalidContent();
    }

    @Override
    protected Value localGetVariable(String string, DebugInfo debugInfo) {
        return this.value.localGetVariable(string, debugInfo);
    }

    @Override
    public FunctionTable getFunctions() {
        return new ReferenceFunctionTable();
    }

    private class ReferenceFunctionTable
    extends FunctionTable {
        private ReferenceFunctionTable() {
        }

        @Override
        public Function get(String string, Value[] valueArray, DebugInfo debugInfo) {
            if (string.equals("=")) {
                return new Function("=", 2, null, true){

                    @Override
                    public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                        Value value = valueArray[1];
                        if (ReferenceValue.this.isInvalid()) {
                            return value;
                        }
                        ReferenceValue.this.setValue(value, evaluationState, debugInfo);
                        return value;
                    }
                };
            }
            if (string.equals("--")) {
                return new Function("--", 1, NumberValue.invalid){

                    @Override
                    public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                        Value value = ReferenceValue.this.value;
                        Value[] valueArray2 = new Value[]{value, NumberValue.one};
                        Function function = value.getFunctions().get("-", valueArray2, debugInfo);
                        ReferenceValue.this.setValue(function.execute(valueArray2, evaluationState, debugInfo), evaluationState, debugInfo);
                        return value;
                    }
                };
            }
            if (string.equals("++")) {
                return new Function("++", 1, NumberValue.invalid){

                    @Override
                    public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                        Value value = ReferenceValue.this.value;
                        Value[] valueArray2 = new Value[]{value, NumberValue.one};
                        Function function = value.getFunctions().get("+", valueArray2, debugInfo);
                        ReferenceValue.this.setValue(function.execute(valueArray2, evaluationState, debugInfo), evaluationState, debugInfo);
                        return value;
                    }
                };
            }
            return ReferenceValue.this.value.getFunctions().get(string, valueArray, debugInfo);
        }

        @Override
        public boolean exist(String string, Value[] valueArray) {
            throw NotImplementedException.intance;
        }
    }
}

