/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;
import java.util.ArrayList;

public class DataBlockDirective
extends AsmDirective {
    private int datasize;
    private ArrayList<ExprNode> datalist;

    public DataBlockDirective(int n, ArrayList<ExprNode> arrayList, DebugInfo debugInfo) {
        super(debugInfo);
        this.datasize = n;
        this.datalist = arrayList;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        evaluationState.increaseMemoryPosition(this.datasize * this.datalist.size());
        byte[] byArray = new byte[this.datasize * this.datalist.size()];
        int n = 0;
        boolean bl = false;
        for (ExprNode exprNode : this.datalist) {
            Value value = exprNode.evaluate(evaluationState);
            if (value.isInvalid()) {
                n += this.datasize;
                bl = true;
                continue;
            }
            int n2 = value.getInt(this.debug);
            for (int i = 0; i < this.datasize; ++i) {
                byArray[n++] = (byte)(n2 & 0xFF);
                n2 >>= 8;
            }
        }
        if (bl || evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(byArray, evaluationState.getFunctionSideOutput());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        String string = this.datasize == 1 ? "Byte" : (this.datasize == 2 ? "Word" : (this.datasize == 4 ? "DWord" : "DataBlock" + this.datasize));
        nodeTreeBuilder.addNode(string, this.debug, this.datalist);
        return nodeTreeBuilder;
    }
}

