/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.DebugTokenValue;
import cml.kickass.misc.ArgTypes;
import cml.kickass.misc.Argument;
import cml.kickass.misc.MnemonicTable;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class AsmCommand
extends AsmDirective {
    private String mnemonic;
    private ExprNode argumentExpr;
    private CmdClass cmdClass;
    private String extension;
    private int resolvedType;

    public AsmCommand(String string, ExprNode exprNode, CmdClass cmdClass, DebugInfo debugInfo) {
        this(string, exprNode, cmdClass, -1, debugInfo);
    }

    public AsmCommand(String string, DebugTokenValue debugTokenValue, ExprNode exprNode, CmdClass cmdClass, DebugInfo debugInfo) {
        this(string, exprNode, cmdClass, AsmCommand.resolveExtension(debugTokenValue.getString(), debugTokenValue.getDebugInfo()), debugInfo);
    }

    private static int resolveExtension(String string, DebugInfo debugInfo) {
        if (string.equals("imm") || string.equals("im")) {
            return 1;
        }
        if (string.equals("zp") || string.equals("z")) {
            return 2;
        }
        if (string.equals("zpx") || string.equals("zx")) {
            return 3;
        }
        if (string.equals("zpy") || string.equals("zy")) {
            return 4;
        }
        if (string.equals("izpx") || string.equals("izx")) {
            return 5;
        }
        if (string.equals("izpy") || string.equals("izy")) {
            return 6;
        }
        if (string.equals("abs") || string.equals("a")) {
            return 7;
        }
        if (string.equals("absx") || string.equals("ax")) {
            return 8;
        }
        if (string.equals("absy") || string.equals("ay")) {
            return 9;
        }
        if (string.equals("ind") || string.equals("i")) {
            return 10;
        }
        if (string.equals("rel") || string.equals("r")) {
            return 11;
        }
        throw new AsmError("Unknown mnemonic extension '" + string + "'", debugInfo);
    }

    public AsmCommand(String string, ExprNode exprNode, CmdClass cmdClass, int n, DebugInfo debugInfo) {
        super(debugInfo);
        this.argumentExpr = exprNode;
        this.mnemonic = string;
        this.cmdClass = cmdClass;
        this.resolvedType = n;
    }

    @Override
    public AsmNode copy() {
        return new AsmCommand(this.mnemonic, this.argumentExpr, this.cmdClass, this.resolvedType, this.debug);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        Object object;
        evaluationState.clearFunctionSideOutput();
        if (this.cmdClass == CmdClass.DTV && !evaluationState.getDtvMode()) {
            throw new AsmError("You are using a dtv command without being in dtv mode. Use -dtv to turn on dtv mode", this.debug);
        }
        Value value = this.argumentExpr.evaluate(evaluationState);
        Argument argument = value.getCmdArgument(this.debug);
        Value value2 = argument.getValue();
        Integer n = value2.isInvalid() || argument.getType() == 0 ? null : Integer.valueOf(value2.getInt(this.debug));
        int[] nArray = MnemonicTable.getPossibleModes(this.mnemonic);
        int n2 = this.resolvedType;
        if (n2 < 0) {
            n2 = this.resolveArgType(argument.getType(), n, nArray);
        }
        int n3 = 1 + ArgTypes.getSize(n2);
        evaluationState.increaseMemoryPosition(n3);
        int n4 = nArray[n2];
        if (n4 == -1) {
            String string = ArgTypes.typeToString(n2);
            throw new AsmError("invalid adressingmode. '" + this.mnemonic + "' doesn't support " + string + " mode", this.debug);
        }
        if (value2.isInvalid()) {
            return this.cmdWithResolvedType(n2);
        }
        if (n2 == 11) {
            object = evaluationState.getMemoryPosition();
            if (object == null) {
                return this.cmdWithResolvedType(n2);
            }
            if ((n = Integer.valueOf(n - (Integer)object)) < -128 || 127 < n) {
                throw new AsmError("relative address is illegal (jump distance is too far).", this.debug);
            }
        }
        object = new byte[n3];
        object[0] = (byte)n4;
        for (int i = 1; i < n3; ++i) {
            object[i] = (byte)(n & 0xFF);
            n = n >> 8;
        }
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput((byte[])object, evaluationState.getFunctionSideOutput());
    }

    private int resolveArgType(int n, Integer n2, int[] nArray) {
        boolean bl;
        int n3 = this.getZeropageMode(n, nArray);
        if (n3 >= 0 && n2 != null && n2 <= 255) {
            return n3;
        }
        boolean bl2 = nArray[11] >= 0;
        boolean bl3 = bl = n == 7 || n == 2;
        if (bl2 && bl) {
            return 11;
        }
        return n;
    }

    private int getZeropageMode(int n, int[] nArray) {
        if (n == 7 && nArray[2] >= 0) {
            return 2;
        }
        if (n == 8 && nArray[3] >= 0) {
            return 3;
        }
        if (n == 9 && nArray[4] >= 0) {
            return 4;
        }
        return -1;
    }

    private AsmNode cmdWithResolvedType(int n) {
        if (this.resolvedType >= 0) {
            return this;
        }
        return new AsmCommand(this.mnemonic, this.argumentExpr, this.cmdClass, n, this.debug);
    }

    @Override
    public String toString() {
        return this.mnemonic;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("AsmCmd", this.debug, this.mnemonic, this.argumentExpr);
        return nodeTreeBuilder;
    }

    public static enum CmdClass {
        NORMAL,
        DTV;

    }
}

