/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.ByteOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class AlignDirective
extends AsmDirective {
    private ExprNode argExpr;

    public AlignDirective(ExprNode exprNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.argExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        evaluationState.clearFunctionSideOutput();
        Value value = this.argExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n = value.getInt(this.debug);
        if (n <= 0) {
            throw new AsmError("Alignment size must be positive.", this.debug);
        }
        Integer n2 = evaluationState.getMemoryPosition();
        if (n2 == null) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        int n3 = n - n2 % n;
        if (n3 == n) {
            n3 = 0;
        }
        evaluationState.increaseMemoryPosition(n3);
        if (evaluationState.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(new byte[n3], evaluationState.getFunctionSideOutput());
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Align", this.debug, this.argExpr);
        return nodeTreeBuilder;
    }
}

