/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmandfunctionmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.directives.Directive;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.Value;

public class ErrorDirective
extends Directive {
    private ExprNode msgExpr;

    public ErrorDirective(ExprNode exprNode, DebugInfo debugInfo) {
        super(debugInfo);
        this.msgExpr = exprNode;
        this.debug = debugInfo;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        Value value = this.msgExpr.evaluate(evaluationState);
        String string = !value.isInvalid() ? value.getString(this.debug) : "Invalid error message value! (You might use a yet inresolved label)";
        throw new AsmError(string, this.debug);
    }

    @Override
    public void functionParse(EvaluationState evaluationState) {
        this.parse(evaluationState);
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Error", this.debug, this.msgExpr);
        return nodeTreeBuilder;
    }
}

