/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.VectorDoubleFunction;
import cml.kickass.function.VectorFunction;
import cml.kickass.function.VectorX2Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class VectorValue
extends ImmutableValue {
    public static VectorValue invalid = new VectorValue();
    private double[] values = new double[3];
    static FunctionTable functions = new StdFunctionTable(VectorValue.getStandardFunctions());

    private VectorValue() {
        this.setInvalid();
    }

    public VectorValue(double[] dArray) {
        for (int i = 0; i < 3; ++i) {
            this.values[i] = dArray[i];
        }
    }

    public VectorValue(double d, double d2, double d3) {
        this.values[0] = d;
        this.values[1] = d2;
        this.values[2] = d3;
    }

    @Override
    public String getType() {
        return "Vector";
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid Vector>>";
            }
            return "(" + this.values[0] + "," + this.values[1] + "," + this.values[2] + ")";
        }
        if (n == RP_VECTORVALUE) {
            return this.values.clone();
        }
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public String toString() {
        return "Vector(" + this.values[0] + "," + this.values[1] + "," + this.values[2] + ")";
    }

    static {
        functions.add(new Function("get", 2, NumberValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                VectorValue vectorValue = (VectorValue)valueArray[0];
                int n = valueArray[1].getInt(debugInfo);
                if (n < 0 || 3 <= n) {
                    throw new AsmError("Invalid index : " + n, debugInfo);
                }
                return new NumberValue(vectorValue.values[n]);
            }
        });
        functions.add(new Function("*", 2, InvalidValue.instance){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                double[] dArray = ((VectorValue)valueArray[0]).values;
                if (valueArray[1].hasRepresentation(Value.RP_VECTORVALUE)) {
                    double[] dArray2 = valueArray[1].getVector(debugInfo);
                    return new NumberValue(dArray[0] * dArray2[0] + dArray[1] * dArray2[1] + dArray[2] * dArray2[2]);
                }
                if (valueArray[1].hasRepresentation(Value.RP_DOUBLEVALUE)) {
                    double d = valueArray[1].getDouble(debugInfo);
                    return new VectorValue(dArray[0] * d, dArray[1] * d, dArray[2] * d);
                }
                throw new AsmError("Invalid argument. Can't get vector or number representation.", debugInfo);
            }
        });
        functions.add(new VectorFunction("getX", NumberValue.invalid){

            @Override
            protected Value f(double[] dArray) {
                return new NumberValue(dArray[0]);
            }
        });
        functions.add(new VectorFunction("getY", NumberValue.invalid){

            @Override
            protected Value f(double[] dArray) {
                return new NumberValue(dArray[1]);
            }
        });
        functions.add(new VectorFunction("getZ", NumberValue.invalid){

            @Override
            protected Value f(double[] dArray) {
                return new NumberValue(dArray[2]);
            }
        });
        functions.add(new VectorX2Function("+", invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return new VectorValue(dArray[0] + dArray2[0], dArray[1] + dArray2[1], dArray[2] + dArray2[2]);
            }
        });
        functions.add(new VectorX2Function("-", invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return new VectorValue(dArray[0] - dArray2[0], dArray[1] - dArray2[1], dArray[2] - dArray2[2]);
            }
        });
        functions.add(new VectorDoubleFunction("/", invalid){

            @Override
            protected Value f(double[] dArray, double d) {
                return new VectorValue(dArray[0] / d, dArray[1] / d, dArray[2] / d);
            }
        });
        functions.add(new VectorX2Function("X", invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return new VectorValue(dArray[1] * dArray2[2] - dArray[2] * dArray2[1], dArray[2] * dArray2[0] - dArray[0] * dArray2[2], dArray[0] * dArray2[1] - dArray[1] * dArray2[0]);
            }
        });
        functions.add(new VectorX2Function("==", BooleanValue.invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return BooleanValue.get(dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2]);
            }
        });
        functions.add(new VectorX2Function("!=", BooleanValue.invalid){

            @Override
            protected Value f(double[] dArray, double[] dArray2) {
                return BooleanValue.get(dArray[0] != dArray2[0] || dArray[1] != dArray2[1] || dArray[2] != dArray2[2]);
            }
        });
    }
}

