/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.state.scope;

import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.plugins.interf.IMacro;
import cml.kickass.plugins.interf.IModifier;
import cml.kickass.state.scope.EntityScope;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdEntityScope;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.SymbolScopeValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StdScope
implements Scope {
    private String name;
    private Scope parrent;
    private Collection<Scope> children = new ArrayList<Scope>();
    private SymbolScope symbols = null;
    private EntityScope<ExecutableDirectives> macros;
    private EntityScope<ExecutableDirectives> pseudoCommands;
    private EntityScope<IMacro> macroPlugins;
    private EntityScope<IModifier> modifierPlugins;

    public StdScope(Scope scope, boolean bl) {
        this(null, scope, bl);
    }

    public StdScope(String string, Scope scope, boolean bl) {
        this.parrent = scope;
        if (scope == null) {
            this.symbols = new SymbolScope(null);
            this.macros = new StdEntityScope<ExecutableDirectives>(null);
            this.pseudoCommands = new StdEntityScope<ExecutableDirectives>(null);
            this.macroPlugins = new StdEntityScope<IMacro>(null);
            this.modifierPlugins = new StdEntityScope<IModifier>(null);
        } else {
            this.symbols = new SymbolScope(scope.getSymbols());
            this.macros = scope.getMacros();
            this.pseudoCommands = scope.getPseudoCommands();
            this.macroPlugins = scope.getMacroPlugins();
            this.modifierPlugins = scope.getModifierPlugins();
        }
        if (bl) {
            scope.registerChild(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void registerChild(Scope scope) {
        this.children.add(scope);
    }

    @Override
    public Collection<Scope> getChildren() {
        return this.children;
    }

    @Override
    public void resetBeforePass() {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : this.getSymbols().getLocalDefinedEntities().entrySet()) {
            if (!((SymbolScopeValue)entry.getValue()).keepInNextPass()) continue;
            ((SymbolScopeValue)entry.getValue()).initBeforeParse();
            hashMap.put(entry.getKey(), entry.getValue());
        }
        this.symbols.setLocalDefinedEntities(hashMap);
        for (Scope scope : this.children) {
            scope.resetBeforePass();
        }
    }

    @Override
    public Scope getParrent() {
        return this.parrent;
    }

    @Override
    public EntityScope<ExecutableDirectives> getMacros() {
        return this.macros;
    }

    @Override
    public EntityScope<IMacro> getMacroPlugins() {
        return this.macroPlugins;
    }

    @Override
    public EntityScope<IModifier> getModifierPlugins() {
        return this.modifierPlugins;
    }

    @Override
    public EntityScope<ExecutableDirectives> getPseudoCommands() {
        return this.pseudoCommands;
    }

    @Override
    public SymbolScope getSymbols() {
        return this.symbols;
    }
}

