#ifndef _SHADER_H_
#define _SHADER_H_

class Ext;

#include "ext.hpp"


void debugShader(GLuint obj, const char *name);
class ShaderManager;

extern class Ext glExt;
extern ShaderManager *shaders;

//////////////////////////////////////
// Shader class
//////////////////////////////////////

class Shader 
{
public:

	Shader() { initialized = false; };
	~Shader() {};

	// name for debug, frag shader, vertex shader
	void init(const char *name, const char *frag, const char *vert);
	
	// this does not currently work.
	void initFromFile(const char *name, char *fragFile, char *vertFile);
	
	// fetch string from file
	static char *loadFromFile(char *filename);
	
	void deinit();

	bool initialized;
	const char *name;

	GLhandleARB vertex;
	GLhandleARB fragment;
	// edelliset yhdes
	GLhandleARB program;

	void bind();
	void unbind();

	// Send parameters
	bool setUniform1f(char* varname, GLfloat v0);  
	bool setUniform2f(char* varname, GLfloat v0, GLfloat v1); 
	bool setUniform3f(char* varname, GLfloat v0, GLfloat v1, GLfloat v2); 
	bool setUniform4f(char* varname, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3); 
	
	bool setUniform1i(char* varname, GLint v0);
	bool setUniform2i(char* varname, GLint v0, GLint v1);
	bool setUniform3i(char* varname, GLint v0, GLint v1, GLint v2);
	bool setUniform4i(char* varname, GLint v0, GLint v1, GLint v2, GLint v3);
	
	bool setUniform1fv(char* varname, GLsizei count, GLfloat *value);
	bool setUniform2fv(char* varname, GLsizei count, GLfloat *value);
	bool setUniform3fv(char* varname, GLsizei count, GLfloat *value);
	bool setUniform4fv(char* varname, GLsizei count, GLfloat *value);
	bool setUniform1iv(char* varname, GLsizei count, GLint *value);
	bool setUniform2iv(char* varname, GLsizei count, GLint *value);
	bool setUniform3iv(char* varname, GLsizei count, GLint *value);
	bool setUniform4iv(char* varname, GLsizei count, GLint *value);
	   
	bool setUniformMatrix2fv(char* varname, GLsizei count, GLboolean transpose, GLfloat *value);
	bool setUniformMatrix3fv(char* varname, GLsizei count, GLboolean transpose, GLfloat *value);
	bool setUniformMatrix4fv(char* varname, GLsizei count, GLboolean transpose, GLfloat *value);
	
	// Receive Uniform variables:
	void GetUniformfv(char* name, GLfloat* values);
	void GetUniformiv(char* name, GLint* values); 
	
	// Vertex Attributes
	bool setVertexAttrib1f(char* varname, GLfloat v0);
	bool setVertexAttrib2f(char* varname, GLfloat v0, GLfloat v1);
	bool setVertexAttrib3f(char* varname, GLfloat v0, GLfloat v1, GLfloat v2);
	bool setVertexAttrib4f(char* varname, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);	

	GLint GetUniLoc(const GLcharARB *name);        
protected:
};


//////////////////////////////////////
// Holder for shaders
//////////////////////////////////////


class ShaderManager
{
	public:

		~ShaderManager();			

		// luonti funktio jolla varmistetaan ett luokasta on vain
		// YKSI instanssi olemassa
		static ShaderManager *create();
		
		void release();
		void initShaders(); 
		void deInitShaders();
		void debug();

		// Getters
		unsigned int getShaderCount();
		Shader *getShader(unsigned int index);
		Shader *getShader(char *name);
		bool addShader(const char *name, Shader *shader);
		bool addShader(Shader *shader);
		
		void unbind();
				
	private:

		static bool createdFlag;			// true jos yksi instanssi olemassa
		static ShaderManager *instance;

		unsigned int nShaders;
		List <Shader> shaderList; // TODO: Char *

		// kun nm on privatena niin voidaan est uusien ilmentymien luonti
		ShaderManager();
		ShaderManager(const ShaderManager&) {}
		ShaderManager& operator = (const ShaderManager&) {}
};

#endif