#ifndef _PRIMITIVES_HPP_
#define _PRIMITIVES_HPP_

#include "externs.hpp"
#include "mathematics.hpp"

class Primitives
{
public:

    static void init();

	static void textureTausta(bool xflip, bool yflip);
	static void textureTaustaScale(bool xflip, bool yflip, float scale);
	static void textureTaustaMove(bool xflip, bool yflip, float xoff, float yoff);
	static void textureTaustaScaleMove(bool xflip, bool yflip, float scale, float xoff, float yoff);
    static void flatTausta(float r, float g, float b, float alpha);
	static void renderTexturedPlaneWithFadeOut(Vector &p1, Vector &p2, Vector &p3, Vector &p4, int slices, float texturetimes, Vector color, Vector origin, float mindist, float maxdist, float alpha=1.0f);

	static void wireCube(float size);
	static void flatCube(float size);
	static void texturedCube(float size, float tmul);
    static void wireGridBox(float size, int count);
	static void fadeText(float x, float y, float scale, float alpha, float pos, float starttime, float endtime, float ramp,
				 		  char *fontti, char *teksti);

    static void drawDebugGrid(float alpha);
    static void drawBillboard(Vector &point, float size);

};

#pragma warning(disable: 4305)


static Vector tetravertices[4] = 
{
	Vector(-1, -1, -1),
	Vector(1, 1, -1),
	Vector(1, -1, 1),
	Vector(-1, 1, 1)
};

static int tetrafaces[4][3] = 
{
	1,2,3,
	1,0,2,
	3,2,0,
	0,1,3
};

static Vector octavertices[6] = 
{
	Vector(1,  0,  0),
	Vector(0, -1,  0),
	Vector(-1,  0,  0),
	Vector(0,  1,  0),
	Vector(0,  0,  1),
	Vector(0,  0, -1)
};

static int octafaces[8][3] = 
{
	4, 0, 1,
	4, 1, 2,
	4, 2, 3,
	4, 3, 0,
	5, 1, 0,
	5, 2, 1,
	5, 3, 2,
	5, 0, 3,
};

static Vector cubevertices[8] = 
{
	Vector(-1, -1, -1),
	Vector( 1, -1, -1),
	Vector( 1,  1, -1),
	Vector(-1,  1, -1),
	Vector(-1, -1,  1),
	Vector( 1, -1,  1),
	Vector( 1,  1,  1),
	Vector(-1,  1,  1),
};
static int cubefaces[6][4] = 
{
	0, 1, 2, 3,
	5, 4, 7, 6,
	6, 2, 1, 5,
	3, 7, 4, 0,
	7, 3, 2, 6,
	5, 1, 0, 4,
};

static Vector icosavertices[12] = 
{
	Vector(0, -0.52573,  0.85065),
	Vector(0.85065,  0,  0.52573),
	Vector(0.85065,  0, -0.52573),
	Vector(-0.85065,  0, -0.52573),
	Vector(-0.85065,  0,  0.52573),
	Vector(-0.52573,  0.85065,  0),
	Vector(0.52573,  0.85065,  0),
	Vector(0.52573, -0.85065,  0),
	Vector(-0.52573, -0.85065,  0),
	Vector(0, -0.52573, -0.85065),
	Vector(0,  0.52573, -0.85065),
	Vector(0,  0.52573,  0.85065)
};

static int icosafaces[20][3] = 
{
	6, 2, 1, 
	2, 7, 1, 
	5, 4, 3, 
	8, 3, 4, 
	11, 5, 6, 
	10, 6, 5, 
	2, 10, 9, 
	3, 9, 10, 
	9, 8, 7, 
	0, 7, 8, 
	1, 0, 11, 
	4, 11, 0, 
	10, 2, 6, 
	11, 6, 1, 
	10, 5, 3, 
	11, 4, 5, 
	9, 7, 2, 
	0, 1, 7, 
	8, 9, 3, 
	0, 8, 4, 
};

static Vector dodecavertices[20] = 
{
	Vector(-0.57735, -0.57735, 0.57735),
	Vector(0.93417, 0.35682, 0),
	Vector(0.93417, -0.35682, 0),
	Vector(-0.93417, 0.35682, 0),
	Vector(-0.93417, -0.35682, 0),
	Vector(0, 0.93417, 0.35682),
	Vector(0, 0.93417, -0.35682),
	Vector(0.35682, 0, -0.93417),
	Vector(-0.35682, 0, -0.93417),
	Vector(0, -0.93417, -0.35682),
	Vector(0, -0.93417, 0.35682),
	Vector(0.35682, 0, 0.93417),
	Vector(-0.35682, 0, 0.93417),
	Vector(0.57735, 0.57735, -0.57735),
	Vector(0.57735,0.57735,0.57735),
	Vector(-0.57735, 0.57735, -0.57735),
	Vector(-0.57735, 0.57735, 0.57735),
	Vector(0.57735, -0.57735, -0.57735),
	Vector(0.57735, -0.57735, 0.57735),
	Vector(-0.57735, -0.57735, -0.57735)
};
static int dodecafaces[12][5] = 
{
	1, 2, 18, 11, 14, 
	1, 13, 7, 17, 2, 
	3, 4, 19, 8, 15, 
	3, 16, 12, 0, 4, 
	3, 15, 6, 5, 16, 
	1, 14, 5, 6, 13, 
	2, 17, 9, 10, 18, 
	4, 0, 10, 9, 19, 
	7, 8, 19, 9, 17, 
	6, 15, 8, 7, 13, 
	5, 14, 11, 12, 16, 
	10, 0, 12, 11, 18, 
};


void tetrahedron();
void octahedron();
void hexahedron();
void icosahedron();
void dodecahedron();


#endif