#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Water.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Water::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void Water::renderScene(float pos, float alpha)
{
 
	bool imageUpdated=false;
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
		for(int n=0; n<1; n++)
		{
			int x = rand()%watereffu->size;
			int y = rand()%watereffu->size;
			watereffu->buffer2[(x)*watereffu->size+y] = 255;
		}
	
		watereffu->updateBuffers();
		imageUpdated = true;
        this->frametimer->endStep();
    }

	if(imageUpdated) 
	{
		watereffu->uploadNormalMap(1.0f);
		watereffu->uploadDxDy();
	}

	
	glColor3f(0.4f, 0.4f, 0.4f);
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, watereffu->normalMapTexture);
	//glBindTexture(GL_TEXTURE_2D, watereffu->dxdyMapTexture);
	Primitives::textureTausta(0,0);


	// TODO: REMOVE THIS
	if(dmsGetKey(VK_F3))
	for(int n=0; n<100; n++)
	{
		int x = rand()%watereffu->size;
		int y = rand()%watereffu->size;
		watereffu->buffer2[(x)*watereffu->size+y] = 255;
	}
	
	// --- test model shit
/*
	glLoadIdentity();

	gluLookAt(0, 0, -10,
			0, 0, 0,
			0, 1, 0);
	glColor3f(1,1,1);

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
	
	glActiveTextureARB(GL_TEXTURE0_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("deeptxt2.jpg")->getID());

    glActiveTextureARB(GL_TEXTURE1_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, watereffu->normalMapTexture);

    glActiveTextureARB(GL_TEXTURE2_ARB);
    glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("normal_map_deep2.jpg")->getID());

    //Vector3 g_lightPos = Vector3(4, 4, 4);
	Vector3 l = Math::sphereToCartesian(-120.0f, sinf(pos*24.0f), cosf(pos*pos*44.6f));
	//float g_lightPos[4] = {-1,1,-4,0};
	float g_lightPos[4] = {l.x, l.y, l.z, 0};

    glPushAttrib(GL_LIGHTING_BIT);

        glLightfv(GL_LIGHT0, GL_POSITION, g_lightPos);

		Shader *nmap = shaders->getShader("water_normal_mapping");
		nmap->bind();
		nmap->setUniform1i("colorMap", 0);
		nmap->setUniform1i("normalMap", 1);
		nmap->setUniform1i("normalMap2", 2);
  

		glPushMatrix();
			
			//glScalef(0.4f,0.4f,0.4f);

			glRotatef(pos*919.0f+175, -0.64f+sin((1-pos*pos*pos*pos)*3.0f), -0.34f*sinf(pos*4.2f*pos), 0.7f*pos*pos);

				

				int objectvertexcount		= model->model->getVertexCount();
				int objectfacecount			= model->model->getFaceCount();
				T3DFace *objectfaces		= model->model->getFaceArray();
				T3DVertex *objectvertices	= model->model->getVertexArray();
				T3DTBN *tbns				= model->getTBNArray();


				glBegin(GL_TRIANGLES);
					for (int i=0;i<objectfacecount;i++)
					{
						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].a].u, objectvertices[objectfaces[i].a].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].a].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].b].u, objectvertices[objectfaces[i].b].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].b].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].c].u, objectvertices[objectfaces[i].c].v);
						glMultiTexCoord4fARB(GL_TEXTURE1_ARB, tbns[i].tangent.x, tbns[i].tangent.y, tbns[i].tangent.z, 0);
						glVertex3fv((float *)&objectvertices[objectfaces[i].c].position);
					}
				glEnd();

		glPopMatrix();

		nmap->unbind();

    glPopAttrib();

	glActiveTextureARB(GL_TEXTURE2_ARB);
    glDisable(GL_TEXTURE_2D);

    glActiveTextureARB(GL_TEXTURE1_ARB);
    glDisable(GL_TEXTURE_2D);

	glActiveTextureARB(GL_TEXTURE0_ARB);
    glDisable(GL_TEXTURE_2D);
*/
}




Water::Water()
{	
    this->frametimer = new FrameTimer(1000 / 25, 5);
}

Water::~Water()
{
	watereffu->deinit();
	if(model != 0)
	{
		model->freeVBO();
		delete model;
	}
}


bool Water::init(unsigned long s, unsigned long e)
{
	watereffu = new WaterEffect();
	watereffu->init(256);

	model = 0;
	model = new T3DVBO(dmsGetObject("sp.t3d"));
	model->createVBO();
	model->initializeTBN();

	startTime = s;
	endTime = e;
	return true;
}


// ------------



void WaterEffect::init(int size)
{	
	unsigned int i;
	this->size = size;
	int s2 = size*size;
	buffer1 = new int[s2];
	buffer2 = new int[s2];
	tmpbuffer = new int[s2];

	for(i=0; i<s2; i++)
	{
		buffer1[i] = 0;
		buffer2[i] = 0;
		tmpbuffer[i] = 0;
	}

	// 4 channels
	normalMapData = new unsigned char[s2*4];
	dxdyMapData = new unsigned char[s2*4];
	for(i=0; i<s2*4; i++)
	{
		normalMapData[i] = 0;
		dxdyMapData[i] = 0;
	}

	// generate texture ids and upload empty textures
	glGenTextures (1, &dxdyMapTexture);
	glBindTexture(GL_TEXTURE_2D,dxdyMapTexture);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, size, size, 0, GL_RGBA,  GL_UNSIGNED_BYTE, dxdyMapData);


	glGenTextures (1, &normalMapTexture);
	glBindTexture(GL_TEXTURE_2D,normalMapTexture);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, size, size, 0, GL_RGBA,  GL_UNSIGNED_BYTE, normalMapData);
}

void WaterEffect::deinit()
{
	if(normalMapData != 0) delete [] normalMapData;
	if(dxdyMapData != 0) delete [] dxdyMapData;
	
	if(tmpbuffer != 0) delete [] tmpbuffer;
	if(buffer1 != 0) delete [] buffer1;
	if(buffer2 != 0) delete [] buffer2;

}

void WaterEffect::updateBuffers()
{
	int x, y;
	for(x=1; x<size-2; x++)
	{
	  for(y=1; y<size-2; y++)
	  {
		/*
		buffer2[x*W+y] = ((buffer1[(x-1)*W	+y] + 
		 				buffer1[(x+1)*W	+y] + 
		 				buffer1[x*W		+y+1] + 
		 				buffer1[x*W		+y-1] ) >> 1)  - buffer2[x*W+y];
		*/
		 
		buffer2[x*size+y]=(buffer1[(x-1)*size	+y]*0.9f + 
						buffer1[(x+1)*size	+y]*0.9f + 
						buffer1[x*size		+y+1]*0.9f + 
						buffer1[x*size		+y-1]*0.9f +			
						buffer1[(x-1)*size	+y-1]*0.1f + 
						buffer1[(x-1)*size	+y+1]*0.1f + 
						buffer1[(x+1)*size	+y+1]*0.1f + 
						buffer1[(x+1)*size	+y-1]*0.1f) * 0.5
						- buffer2[x*size+y];
			
		// dampen factor
		buffer2[x*size+y] -= buffer2[x*size+y] >> 12 ;
	  }
	}

	const int size2 = size*size;
	memcpy(tmpbuffer, buffer2,   size2*sizeof(int));
	memcpy(buffer2,   buffer1,   size2*sizeof(int));
	memcpy(buffer1,   tmpbuffer, size2*sizeof(int));
}


void WaterEffect::uploadDxDy()
{
	int x,y;
	int W = size;
	for(x=1; x<W-2; x++)
	{
	  for(y=1; y<W-2; y++)
	  {
		int s = (x*W+y)<<2;
		dxdyMapData[s+0] = buffer2[(x-1)*W+y] - buffer2[(x+1)*W+y];
		dxdyMapData[s+1] = buffer2[x*W+y-1] - buffer2[x*W+y+1];
		dxdyMapData[s+2] = buffer2[x*W+y];
		dxdyMapData[s+3] = 255;
	  }
	}

	glBindTexture(GL_TEXTURE_2D, dxdyMapTexture);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, W, W, 0, GL_RGBA, GL_UNSIGNED_BYTE, dxdyMapData);
}



void WaterEffect::uploadNormalMap(float str)
{
	// TODO: Lots of optimization should be done here

	int x, y;
	int W = size;

	float ystr = 255.0f;
	float cx,cy=ystr,cz,len;
	// draw
	for(x=1; x<W-2; x++)
	{
	  for(y=1; y<W-2; y++)
	  {
		cx=0; cy=ystr; cz=0;

	   int s00 = buffer2[(x-1)*W+ y-1];
	   int s01 = buffer2[(x)*W  + y-1];
	   int s02 = buffer2[(x+1)*W+ y-1];

	   int s10 = buffer2[(x-1)*W+ y];
	   int s12 = buffer2[(x+1)*W+ y];

	   int s20 = buffer2[(x-1)*W+ y+1];
	   int s21 = buffer2[(x)*W  + y+1];
	   int s22 = buffer2[(x+1)*W+ y+1];

	//  SobelX       SobelY
	//  1  0 -1      1  2  1
	//  2  0 -2      0  0  0
	//  1  0 -1     -1 -2 -1

		cz = ystr;
		cx = s00 + 2.0 * s10 + s20 - s02 - 2.0 * s12 - s22;
		cz = s00 + 2.0 * s01 + s02 - s20 - 2.0 * s21 - s22;

		len=sqrt(cx*cx + cy*cy + cz*cz);
		float l = 1.0f/len;
		cx*=l;
		cy*=l;
		cz*=l;

		int s = (x*W+y)<<2;
		normalMapData[s+0] = 128+cx*127;
		normalMapData[s+1] = 128+cz*127;
		normalMapData[s+2] = 128+cy*127;
		normalMapData[s+3] = 255;
	  }
	}

	glBindTexture(GL_TEXTURE_2D, normalMapTexture);
	glTexImage2D(GL_TEXTURE_2D, 0, 4, W, W, 0, GL_RGBA, GL_UNSIGNED_BYTE, normalMapData);
}
