#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Uppo.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

extern void setClearColor(Vector3 color);
void Uppo::draw()
{
	setClearColor(Vector3(0,0,0));
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.99f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);


	Vector3 bg = Vector3(0.09f, 0.1845f, 0.2969f) * (0.7f-pos*0.4f) * alpha;
	Primitives::flatTausta(bg.x, bg.y, bg.z, alpha*0.4f);

    filter.init(true);
	renderScene(pos, alpha);
    filter.glow(6, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
	
}

void Uppo::renderScene(float pos, float alpha)
{
    this->frametimer->update();
    static int framecount = 0;
    std::list<UppoOtus>::iterator it;

    while (this->frametimer->stepsLeft())
    {
        this->cam.update();

        //otukset
        for (it = this->otukset.begin(); it != this->otukset.end(); )
        {
            UppoOtus &otus = *it;
            otus.update(this->cam);

            if (otus.isDead())
            {
                it = this->otukset.erase(it);
            }
            else
            {
                it++;
            }
        }
        //piskut
        for (it = this->piskut.begin(); it != this->piskut.end(); )
        {
            UppoOtus &otus = *it;
            otus.update(this->cam);

            if (otus.isDead())
            {
                it = this->piskut.erase(it);
//                dmsMsg("pisku kuollut\n");
            }
            else
            {
                it++;
            }
        }
        //pisteet
        for (it = this->pisteet.begin(); it != this->pisteet.end(); )
        {
            UppoOtus &otus = *it;
            otus.update(this->cam);

            if (otus.isDead())
            {
                it = this->pisteet.erase(it);
//                dmsMsg("piste kuollut\n");
            }
            else
            {
                it++;
            }
        }

        //sivut
        for (it = this->sivut.begin(); it != this->sivut.end(); )
        {
            UppoOtus &otus = *it;
            otus.update(this->cam);

            if (otus.isDead())
            {
                it = this->sivut.erase(it);
//                dmsMsg("sivu kuollut\n");
            }
            else
            {
                it++;
            }
        }

        //lis uusi elin
        int count = (int)this->otukset.size();
        int count2 = (int)this->piskut.size();
        int count3 = (int)this->piskut.size();
        int count4 = (int)this->pisteet.size();

        int maxcount = 50 * pos;

        const float animal_esiintyvyys = 1.3f; //isompi = harvemmin
        if ( Math::randFloat() < powf(pos, animal_esiintyvyys) && 
             count < maxcount*0.05f)	 
        {
            UppoOtus otus;
            otus.init(this->cam, pos, UPPO_TYPE_ANIMAL);
            this->otukset.push_back(otus);
        }

        const float pisku_esiintyvyys = 1.1f; //isompi = harvemmin
        if ((framecount % 3 == 0) && 
             Math::randFloat() < powf(pos, pisku_esiintyvyys) && 
             count2 < 350)
        {
            UppoOtus otus; 
            otus.init(this->cam, pos, UPPO_TYPE_SPECK);
            this->piskut.push_back(otus);
        }

        const float sivu_esiintyvyys = 1.10f; //isompi = harvemmin
        if ((framecount % 3 == 1) && 
             Math::randFloat() < powf(pos, sivu_esiintyvyys) && 
             count3 < 50)
        {
            UppoOtus otus; 
            otus.init(this->cam, pos, UPPO_TYPE_SIVU);
            this->sivut.push_back(otus);
        }

        const float piste_esiintyvyys = 1.00f; //isompi = harvemmin
        if (Math::randFloat() < powf(pos, sivu_esiintyvyys) && 
             count4 < 80 * powf(pos, 2.0f))
        {
            UppoOtus otus;
            otus.init(this->cam, pos, UPPO_TYPE_PISTE);
            this->pisteet.push_back(otus);
        }

        framecount++;
        this->frametimer->endStep();
    }

    glLoadIdentity();
    this->cam.use();

	glEnable(GL_TEXTURE_2D);
	glEnable(GL_DEPTH_TEST);

    filter.init(true);
	
	glDisable(GL_BLEND);
//   	drawModels(alpha);

    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);//_MINUS_SRC_ALPHA);


    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);

    glEnable(GL_TEXTURE_2D);
    glDisable(GL_DEPTH_TEST);
    for (it = this->piskut.begin(); it != this->piskut.end(); it++)
    {
        UppoOtus &otus = *it;
        otus.render(alpha, xr, yr);
    }

    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("plank_shell.jpg")->getID());
    glBegin(GL_QUADS);
    for (it = this->sivut.begin(); it != this->sivut.end(); it++)
    {
        UppoOtus &otus = *it;
        otus.render(alpha, xr, yr);
    }
    glEnd();
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_POINT_SMOOTH);
    glEnable(GL_BLEND);
    glPointSize(3);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glBegin(GL_POINTS);
    for (it = this->pisteet.begin(); it != this->pisteet.end(); it++)
    {
        UppoOtus &otus = *it;
        otus.render(alpha, xr, yr);
    }
    glEnd();
    glDisable(GL_POINT_SMOOTH);


    glEnable(GL_DEPTH_TEST);

    filter.glow(4, 0.008f, 0.008f, 0.90f /* + tool->getValue("slider1")*/ , -1.0f, 1.0f); 

    
}

void UppoOtus::init(UppoCamera &cam, float pos, int type_to_create)
{
    const float y = cam.position.y;
    const float height = 6.0f;
    const float width = 4.0f;
    const float depth = 4.0f;

    static bool seahorse1 = false;
    static bool seahorse2 = false;
    static bool seahorse3 = false;

    this->type = type_to_create;

    this->sizespeed = Math::randBetween(0.005f, 0.01f);
    this->visualtimer = Math::randFloat();

    switch(this->type)
    {
        case UPPO_TYPE_ANIMAL:
        {
            this->state = UPPO_STATE_BIRTH;
            this->stateTimer = 0.0f;
            this->stateTimerSpeed = 0.01f;
            this->timer = 0.0f;
            this->position = Vector3(Math::randBetween(-width, width), 
                                     Math::randBetween(-height, -height * 0.5f) + y,
                                     Math::randBetween(-depth, depth));
            this->size = Math::randBetween(0.01f, 0.0025f);
			
			if(rand()%2)
				this->color = Vector3(0.2f, 0.5f, 0.8f)*0.5f;
			else 
				this->color = Vector3(0.7f, 0.2f, 0.5f)*0.5f;


            this->rotation = Math::randVectSphere();
            this->rotationDelta = Math::randVectSphere();
            this->direction = Math::randVectSphere();
    
        } break;

        case UPPO_TYPE_SPECK:
        {
            this->state = UPPO_STATE_NORMAL;
            this->stateTimer = 0.0f;
            this->timer = 0.0f;
            this->stateTimerSpeed = 0.01f;
            this->position = Vector3(Math::randBetween(-width, width), 
                                     Math::randBetween(-height * 3, -height * 1.5f) + y,
                                     Math::randBetween(-depth, depth));
            this->fade = Math::randBetween(0.1f, 0.2f);
//            if (Math::randFloat() > 0.00001f)
            {
                this->color = Vector3(Math::randBetween(0.3f, 0.4f),
                                      Math::randBetween(0.5f, 0.6f),
                                      Math::randBetween(0.7f, 0.9f));
            }
//            else
            {
//                this->color = Vector3(0, 0, 0);
            }

            float sizemod = 1.0f;
            switch(rand()%7)
            {
                case 0: this->texture = dmsGetTexture("circle.jpg"); break;
                case 1: this->texture = dmsGetTexture("circle.jpg"); break;
                case 2: this->texture = dmsGetTexture("protozoa1.png"); sizemod = 0.7f; break;
                case 3: this->texture = dmsGetTexture("protozoa2.png"); sizemod = 0.7f; break;
                case 4: this->texture = dmsGetTexture("plankton1.png"); sizemod = 0.8f; break;
                case 5: this->texture = dmsGetTexture("plankton2.png"); sizemod = 0.8f; break;
                case 6: this->texture = dmsGetTexture("jellyfish1.png"); sizemod = 0.8f; break;
            }
            this->size = Math::randBetween(0.10f, 0.13f)*sizemod;

            float textureX = this->texture->getWidth();
            float textureY = this->texture->getHeight();
            float bigger = (textureX > textureY) ? textureX : textureY;
            this->sizeX = (textureX / bigger) * this->size;
            this->sizeY = (textureY / bigger) * this->size;

            this->rotation = Math::randVectSphere();
            this->rotationDelta = Math::randVectSphere();
            this->direction = Math::randVectSphere();
        } break;
 

        case UPPO_TYPE_PISTE:
        {
            this->state = UPPO_STATE_NORMAL;
            this->stateTimer = 0.0f;
            this->timer = 0.0f;
            this->stateTimerSpeed = 0.01f;
            this->position = Vector3(Math::randBetween(-width, width), 
                                     Math::randBetween(-height * 3, -height * 1.5f) + y,
                                     Math::randBetween(-depth, depth));
            this->fade = Math::randBetween(0.3f, 0.5f);

            Vector3 color1 = Vector(0.2f, 0.3f, 0.5f);
            Vector3 color2 = Vector3(0.75f, 0.2f, 0.2f);

            if (Math::randFloat() > 0.5f)
            {
                color2 = Vector3(0.75f, 0.65f, 0.2f);
            }

            float ct = pos + (Math::randFloat()-0.5f)*0.1f;
            ct = min(ct, 1.0f);
            ct = max(ct, 0.0f);

            this->color = color1 * (1-ct) + color2 * ct;

            this->rotation = Math::randVectSphere();
            this->rotationDelta = Math::randVectSphere();
            this->direction = Math::randVectSphere();
        } break;
 
        

        case UPPO_TYPE_SIVU:
        {
            this->state = UPPO_STATE_NORMAL;
            this->stateTimer = 0.0f;
            this->timer = 0.0f;
            this->stateTimerSpeed = 0.01f;

            this->texture = dmsGetTexture("circle.jpg");

            float sizemod = 1.0f;
            const float seahorselimit = 0.90f;
            if (Math::randFloat() > seahorselimit && !seahorse1)
            {
                this->texture = dmsGetTexture("seahorse1.png");
                seahorse1 = true;
            }
            else if (Math::randFloat() > seahorselimit && seahorse1 && !seahorse2)
            {
                this->texture = dmsGetTexture("seahorse1.png");
                seahorse2 = true;
            }
            else if (Math::randFloat() > seahorselimit && seahorse2 && !seahorse3)
            {
                this->texture = dmsGetTexture("seahorse1.png");
                seahorse3 = true;
            }
            else switch(rand()%3)
            {
                case 0: this->texture = dmsGetTexture("circle.jpg"); break;
                case 1: this->texture = dmsGetTexture("circle.jpg"); break;
                case 2: this->texture = dmsGetTexture("protozoa1.png"); sizemod = 1.4f; break;

            }

            this->size = Math::randBetween(0.02f, 0.04f)*3*sizemod;
            
            float textureX = this->texture->getWidth();
            float textureY = this->texture->getHeight();
            float bigger = (textureX > textureY) ? textureX : textureY;
            this->sizeX = (textureX / bigger) * this->size;
            this->sizeY = (textureY / bigger) * this->size;

            
            
            
            bool vasemmalta = rand()%2 == 0;
            this->position = Vector3(vasemmalta ? -width : width, 
                                     Math::randBetween(-height * 3, -height * 1.5f) + y,
                                     Math::randBetween(-depth, depth));
            this->fade = Math::randBetween(0.3f, 0.4f);
            this->color = Vector3(Math::randBetween(0.3f, 0.4f),
                                  Math::randBetween(0.5f, 0.6f),
                                  Math::randBetween(0.7f, 0.9f));

            this->rotation = Math::randVectSphere();
            this->rotationDelta = Math::randVectSphere();
            this->direction = Math::randVectSphere() + Vector3(vasemmalta ? 1 : -1, 0, 0) * 1.1f;
        } break;
    
    }



}

void UppoOtus::update(UppoCamera &cam)
{
    const float animal_maxdist = 3.0f;
    const float speck_maxdist = 4.0f;
    this->visualtimer += this->sizespeed;

    switch(this->type)
    {
        case UPPO_TYPE_ANIMAL:
        {
            this->timer += 0.01f;
            this->rotation += this->rotationDelta * 0.001f;
            this->position += this->direction * 0.001f;
        } break;

        case UPPO_TYPE_PISTE:
        {
            this->timer += 0.01f;
            this->position += this->direction * 0.0145f * (0.55f + 0.4f*sin(this->timer * 5));
        } break;

        case UPPO_TYPE_SPECK:
        {
            this->timer += 0.01f;
            this->position += this->direction * 0.0025f * (0.7f + 0.3f*sin(this->timer * 5));
        } break;

        case UPPO_TYPE_SIVU:
        {
            this->timer += 0.01f;
            this->position += this->direction * 0.0025f * (0.7f + 0.3f*sin(this->timer * 5));
            this->fade = 0.3f + 0.1f * cosf(this->timer * 3);
        } break;
    }

    switch(this->state)
    {
        case UPPO_STATE_NONE:
        {
            //alert!
        }
        break;

        case UPPO_STATE_BIRTH:
        {
            this->stateTimer += this->stateTimerSpeed;
            if (this->stateTimer > 1.0f)
            {
                this->state = UPPO_STATE_NORMAL;
                this->stateTimer = 0.0f;
            }
        }   
        break;

        case UPPO_STATE_NORMAL:
        {
            switch(this->type)
            {
                case UPPO_TYPE_ANIMAL:
                {  
                    if (cam.position.y < this->position.y - animal_maxdist)
                    {
                        this->state = UPPO_STATE_DYING;
                        this->stateTimer = 0.0f;
                    }
                } break;

                case UPPO_TYPE_PISTE:
                case UPPO_TYPE_SPECK:
                {  
                    if (cam.position.y < this->position.y - speck_maxdist)
                    {
                        this->state = UPPO_STATE_DYING;
                        this->stateTimer = 0.0f;
                    }
                } break;
                case UPPO_TYPE_SIVU:
                {  
                    if (cam.position.y < this->position.y - speck_maxdist)
                    {
                        this->state = UPPO_STATE_DYING;
                        this->stateTimer = 0.0f;
                    }
                } break;
            }
        }
        break;

        case UPPO_STATE_DYING:
        {
            this->stateTimer += stateTimerSpeed;
        }
        break;
    };


}

void UppoOtus::render(float alpha, Vector3 &xr, Vector3 &yr)
{
    switch(this->type)
    {
        case UPPO_TYPE_ANIMAL:
        {
            glPushMatrix();
            glTranslatef(this->position.x, this->position.y, this->position.z);
            glRotatef(360 * this->rotation.x, 1, 0, 0);
            glRotatef(360 * this->rotation.y, 0, 1, 0);
            glRotatef(360 * this->rotation.z, 0, 0, 1);

            float birthmod = this->state == UPPO_STATE_BIRTH ? this->stateTimer : 1;
            float dyingmod = this->state == UPPO_STATE_DYING ? (1 - this->stateTimer) : 1;
            float a = 0.4f * alpha * birthmod * dyingmod;
            glColor4f(0.5f, 0.76f, 0.86f, a);
            Primitives::wireCube(this->size);
            glPopMatrix();
        } break;

        case UPPO_TYPE_SPECK:
        {
            glBindTexture(GL_TEXTURE_2D, this->texture->getID());
            glBegin(GL_QUADS);
            
            const float sizemod = 0.75f+0.25f*sinf(this->visualtimer);
            float dyingmod = this->state == UPPO_STATE_DYING ? (1 - this->stateTimer) : 1;
            Vector3 v1 = this->position + xr * -this->sizeX*sizemod + yr * -this->sizeY*sizemod;
            Vector3 v2 = this->position + xr *  this->sizeX*sizemod + yr * -this->sizeY*sizemod;
            Vector3 v3 = this->position + xr *  this->sizeX*sizemod + yr *  this->sizeY*sizemod;
            Vector3 v4 = this->position + xr * -this->sizeX*sizemod + yr *  this->sizeY*sizemod;

            glColor4f(this->color.x ,this->color.y, this->color.z, alpha * dyingmod * this->fade);
            glTexCoord2f(0, 1);
            glVertex3fv((float *)&v1);
            glTexCoord2f(1, 1);
            glVertex3fv((float *)&v2);
            glTexCoord2f(1, 0);
            glVertex3fv((float *)&v3);
            glTexCoord2f(0, 0);
            glVertex3fv((float *)&v4);
            glEnd();

        } break;

        case UPPO_TYPE_PISTE:
        {
            const float sizemod = 0.75f+0.55f*sinf(this->visualtimer);
            float dyingmod = this->state == UPPO_STATE_DYING ? (1 - this->stateTimer) : 1;

            glColor4f(this->color.x ,this->color.y, this->color.z, alpha * dyingmod * this->fade*sizemod);
            glVertex3fv((float *)&this->position);
        } break;

        case UPPO_TYPE_SIVU:
        {
            glBindTexture(GL_TEXTURE_2D, this->texture->getID());
            Matrix r;
            r.makeRotation(0, 0, this->rotation.z*0.3f);
            //glBegin handlattu ulkopuolella
            glBegin(GL_QUADS);
            const float sizemod = 0.75f+0.25f*sinf(this->visualtimer);
            float dyingmod = this->state == UPPO_STATE_DYING ? (1 - this->stateTimer) : 1;
            Vector3 v1 = this->position + ((xr * -this->sizeX + yr * -this->sizeY) * sizemod) * r;
            Vector3 v2 = this->position + ((xr *  this->sizeX + yr * -this->sizeY) * sizemod) * r;
            Vector3 v3 = this->position + ((xr *  this->sizeX + yr *  this->sizeY) * sizemod) * r;
            Vector3 v4 = this->position + ((xr * -this->sizeX + yr *  this->sizeY) * sizemod) * r;

            glColor4f(this->color.x ,this->color.y, this->color.z, alpha * dyingmod * this->fade);
            glTexCoord2f(0, 1);
            glVertex3fv((float *)&v1);
            glTexCoord2f(1, 1);
            glVertex3fv((float *)&v2);
            glTexCoord2f(1, 0);
            glVertex3fv((float *)&v3);
            glTexCoord2f(0, 0);
            glVertex3fv((float *)&v4);
            glEnd();

        } break;
    }
}

bool UppoOtus::isDead()
{
    return this->state == UPPO_STATE_DYING && this->stateTimer > 1.0f;
}

void UppoCamera::init()
{
    this->position = Vector3(0, 0, -10);
    this->target = Vector3(0, 0, 0);
    this->time = 0.0f;
}
void UppoCamera::update()
{
    Vector3 movement = Vector3(0, -0.015f, 0);
    this->position += movement; 
    this->target += movement;
    this->time += 0.01f;
}
void UppoCamera::use()
{
    float angle = 0.15f * sinf(this->time*0.5f);
    Matrix uprot;
    uprot.makeRotation(0, 0, angle);
    Vector3 up = Vector(0, 1, 0) * uprot;
	up = up.normalize();

    float dx = angle*2;

    glLoadIdentity();
    gluLookAt(this->position.x + dx, this->position.y, this->position.z,
              this->target.x + dx, this->target.y, this->target.z, 
              up.x, up.y, up.z);
}


Uppo::Uppo()
{	
    this->cam.init();
    this->frametimer = new FrameTimer(1000 / 60, 5);
}

Uppo::~Uppo()
{
}


bool Uppo::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

void Uppo::drawModels(float alpha)
{
    std::list<UppoOtus>::iterator it;
         
	glActiveTextureARB(GL_TEXTURE0_ARB);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("uppolima.jpg")->getID());

    glPushAttrib(GL_LIGHTING_BIT);

	float g_lightPos[4] = {-1,1,-4,0};
        glLightfv(GL_LIGHT0, GL_POSITION, g_lightPos);
			
		
		//glColor3f(0.55f, 0.95f, 1.0f);
		Shader *phong = shaders->getShader("uppophong");
		phong->bind();
		phong->setUniform1i("tex", 0);


		for (it = this->otukset.begin(); it != this->otukset.end(); it++)
		{

			UppoOtus &otus = *it;


            // tytpp tm
/*
            float Al[4] = {0.0f, 0.0f, 0.0f, 1.0f };
			glLightfv( GL_LIGHT0, GL_AMBIENT, Al );	
			float Dl[4] = {1.0f, 1.0f, 1.0f, 1.0f };
			glLightfv( GL_LIGHT0, GL_DIFFUSE, Dl );	
			float Sl[4] = {1.0f, 1.0f, 1.0f, 1.0f };
			glLightfv( GL_LIGHT0, GL_SPECULAR, Sl );	
*/
            float Al[4] = {0.0f, 0.0f, 0.0f, 1.0f };
			glLightfv( GL_LIGHT0, GL_AMBIENT, Al );	
			float Dl[4] = {0.2f, 0.2f, 0.2f, 1.0f };
			glLightfv( GL_LIGHT0, GL_DIFFUSE, Dl );	
			float Sl[4] = {0.4f, 0.4f, 0.4f, 1.0f };
			glLightfv( GL_LIGHT0, GL_SPECULAR, Sl );	

            float Am[4] = {otus.color.x, otus.color.y, otus.color.z, 1.0f };
			glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, Am );
			Vector3 c = (otus.color * 1.2).clamp(Vector3(0,0,0), Vector3(1,1,1));
			float Dm[4] = {0.25f, 0.25f, 0.35f, 1.0f };
			glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, Dm );
			float Sm[4] = {0.96f, 0.96f, 0.95f, 1.0f };
			glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, Sm );
			float f = 420.0f; // 
			glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, f );



				//otus.render(alpha, xr, yr);
				drawModel(otus, alpha);
		}

			
		phong->unbind();

    glPopAttrib();

	glActiveTextureARB(GL_TEXTURE0_ARB);

}

void Uppo::drawModel(UppoOtus p, float alpha)
{
/*
		glPushMatrix();
			
            glTranslatef(p.position.x, p.position.y, p.position.z);
            glRotatef(360 * p.rotation.x * 0.4f, 1, 0, 0);
            glRotatef(360 * p.rotation.y * 0.4f, 0, 1, 0);
            glRotatef(360 * p.rotation.z * 0.4f, 0, 0, 1);
            glScalef(0.1f, 0.1f, 0.1f);

            float birthmod = p.state == UPPO_STATE_BIRTH ? p.stateTimer : 1;
            float dyingmod = p.state == UPPO_STATE_DYING ? (1 - p.stateTimer) : 1;
            float a = alpha * birthmod * dyingmod;

			Shader *phong = shaders->getShader("uppophong");
			phong->setUniform1f("alpha", a);

			glScalef(p.size, p.size, p.size);			

				int objectvertexcount		= model->model->getVertexCount();
				int objectfacecount			= model->model->getFaceCount();
				T3DFace *objectfaces		= model->model->getFaceArray();
				T3DVertex *objectvertices	= model->model->getVertexArray();


				glBegin(GL_TRIANGLES);
					for (int i=0;i<objectfacecount;i++)
					{
						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].a].u, objectvertices[objectfaces[i].a].v);
						glVertex3fv((float *)&objectvertices[objectfaces[i].a].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].b].u, objectvertices[objectfaces[i].b].v);
						glVertex3fv((float *)&objectvertices[objectfaces[i].b].position);

						glNormal3fv((float *)&objectfaces[i].normal);
						glMultiTexCoord2fARB(GL_TEXTURE0_ARB, objectvertices[objectfaces[i].c].u, objectvertices[objectfaces[i].c].v);
						glVertex3fv((float *)&objectvertices[objectfaces[i].c].position);
					}
				glEnd();

		glPopMatrix();
*/
}