#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Ropes.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"
#include "alkuotukset.h"
#include "meduusa.h"

Vector3 ropescamposition;

//static const float DAMPEN_FACTOR = 0.994675f;
static const float DAMPEN_FACTOR = 0.99204675f;

extern LiikkuvaOlio *liikkuvat;
extern int liikkuvacount;

extern void setClearColor(Vector3 color);
std::vector<Alkuotus> ropeotukset;

void Ropes::draw()
{
	setClearColor(Vector3(-1,0,0));
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.9850f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

    filter.init(true);
	renderScene(pos, alpha);

	glDisable(GL_LINE_SMOOTH);
	glEnable(GL_BLEND);
	//filter.glow(6, 0.004f, 0.004f, 0.857f+sinf(3.14f*trigut->get(dmsGetModulePosition()))*0.025f, -1.0f, 1.0f);
	filter.glow(6, 0.007f, 0.007f, 0.91f-sinf(3.14f*trigut->get(dmsGetModulePosition()))*0.015f, -1.0f, 1.0f);
	
	//filter.radialblur();
    //filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}



/////////////////////////////////////////////////// PARTICLET ///////////////////////////////////////////////////////////

RopeParticle::RopeParticle()
{
}

RopeParticle::~RopeParticle()
{
}

void RopeParticle::update()
{
    this->energy -= 0.001f;
    this->time += this->timespeed;


    Vector3 (*turbulence)(Vector3&, float) = NULL;

    switch(this->func)
    {
        case 0:
            turbulence = tentacleTurbulence1;
            break;
        case 1:
            turbulence = tentacleTurbulence2;
            break;
        case 2:
            turbulence = tentacleTurbulence3;
            break;
        case 3:
            turbulence = tentacleTurbulence4;
            break;

    };

    Vector3 dir = turbulence(this->pos, this->time);
    this->pos += dir * 0.01f;
    this->pos.y += 0.015f;
}

void RopeParticle::draw(float alpha)
{
    //?
}
bool RopeParticle::isDead()
{
    return energy < 0.0f;
}

RopeEmitter::RopeEmitter()
{
}

RopeEmitter::~RopeEmitter()
{
}

void RopeEmitter::update()
{
    std::list<RopeParticle>::iterator i;

    for (i = this->particles.begin(); i != this->particles.end(); )
    {
        RopeParticle &p = *i;
        p.update();

        if (p.isDead())
        {
            i = this->particles.erase(i);
        }
        else
        {
            i++;
        }

    }
    if (Math::randFloat() > 0.5f)
    {
        RopeParticle p;
        p.pos = this->pos;
        p.energy = Math::randBetween(0.7f, 1.3f);
        p.maxenergy = p.energy; 
        p.size = Math::randBetween(0.03f, 0.06f);
        p.time = 0.0f;
        p.func = rand()%4;
        p.timespeed = Math::randBetween(0.01f, 0.02f);
        this->particles.push_back(p);
    }
}

void RopeEmitter::init()
{
    float a = Math::randBetween(0, 2*3.141592f);
    float r = 15 * Math::randFloat();
    float y = -Math::randBetween(5.0f, 10.0f);

    this->pos = Vector(cosf(a) * r, y, sinf(a) * r);
}
void RopeEmitter::draw(float alpha)
{
    std::list<RopeParticle>::iterator i;

    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);

    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glDisable(GL_DEPTH_TEST);
    glDepthMask(0);

    glBindTexture(GL_TEXTURE_2D, this->texture->getID());//dmsGetTexture("bubble1.png")->getID());
    glBegin(GL_QUADS);

    Vector3 color = Vector3(1, 1, 1);
    for (i = this->particles.begin(); i != this->particles.end(); i++)
    {
        RopeParticle &p = *i;
        float t = p.energy / p.maxenergy;
        const float size = p.size;
        const float fade = (1-powf(t, 15)) * 1.0f * t;

		Vector3 dcam = (ropescamposition-p.pos);
		float d = dcam.x*dcam.x + dcam.y*dcam.y + dcam.z*dcam.z;
		const float fadeddist = 7.5f;
		const float dist = 2.0f;
		const float testsum = dist+fadeddist;
		const float invd = 1.0f/dist;
		float feidi = (d > testsum ) ? 1.0 : ((d)<fadeddist ? 0.0 : (d-fadeddist) * invd);

        Vector3 v1 = p.pos + xr * -size + yr * -size;
        Vector3 v2 = p.pos + xr *  size + yr * -size;
        Vector3 v3 = p.pos + xr *  size + yr *  size;
        Vector3 v4 = p.pos + xr * -size + yr *  size;

        glColor4f(color.x , color.y, color.z, alpha * fade * feidi);
        glTexCoord2f(0, 1);
        glVertex3fv((float *)&v1);
        glTexCoord2f(1, 1);
        glVertex3fv((float *)&v2);
        glTexCoord2f(1, 0);
        glVertex3fv((float *)&v3);
        glTexCoord2f(0, 0);
        glVertex3fv((float *)&v4);
    }
    glEnd();
    glDisable(GL_TEXTURE_2D);
    glDepthMask(1);
}




Vector t1,t2,t3,t4,t5;

void Ropes::stepLogic()
{
	OList::iterator oiter;
	CList::iterator citer;
	
	int zcount = oliot/5;

		static int id;
		// Update only every 2nd step - bg effect..
		if(id==0)
		{
			std::vector<Alkuotus>::iterator it;
			for (it = ropeotukset.begin(); it < ropeotukset.end(); it++)
			{
	            (*it).update();
			}
		}
		id++;

		// Integrate
		for (oiter=mObjects.begin(); oiter!=mObjects.end(); oiter++) 
		{
			if(!((VerletObject*)*oiter)->mAlive) continue;

			((VerletObject*)*oiter)->update();
			// Reset forces!
			((VerletObject*)*oiter)->resetForces();
			// Accumulate forces
			((VerletObject*)*oiter)->accumulateForces();
		}

		const int ITERATIONS = 5;
		for(int n=0; n<ITERATIONS; n++)
		{
			for (citer=mConstraints.begin(); citer!=mConstraints.end(); citer++) 
			{
				if(!((VerletConstraint*)*citer)->mAlive) continue;
				
				((VerletConstraint*)*citer)->satisfyConstraint();
			}
		}

		// Attach start points to the splines points
		int x = 0;
		int start = 0;
		for(x=start; x<start+zcount; x++) moveobut[x]->mPos = t1 + moveobut[x]->mOldPos;
		start += zcount;
		for(x=start; x<start+zcount; x++) moveobut[x]->mPos = t2 + moveobut[x]->mOldPos;
		start += zcount;
		for(x=start; x<start+zcount; x++) moveobut[x]->mPos = t3 + moveobut[x]->mOldPos;
		start += zcount;
		for(x=start; x<start+zcount; x++) moveobut[x]->mPos = t4 + moveobut[x]->mOldPos;
		start += zcount;
		for(x=start; x<start+zcount; x++) moveobut[x]->mPos = t5 + moveobut[x]->mOldPos;
		
}

void Ropes::renderScene(float pos, float alpha)
{
    static float anal_cum = 0.0f;
    float analval = 0.1f*anal->get();
    anal_cum = anal_cum * 0.94f + analval * 0.06f;
    analval = anal_cum;

	t1 = spl1->getValue(Math::clampVal(pos + sin(pos*14.0f)*0.006f,0,1));
	t2 = spl2->getValue(Math::clampVal(pos + sin(pos*24.0f)*0.01f,0,1));
	t3 = spl3->getValue(Math::clampVal(pos + sin(pos*14.0f)*0.021f,0,1));
	t4 = spl4->getValue(Math::clampVal(pos + sin(pos*24.0f)*0.013f,0,1));
	t5 = spl5->getValue(Math::clampVal(pos + sin(pos*24.0f)*0.015f,0,1));

	int i;
    std::vector<RopeEmitter>::iterator it2;
    this->frametimer->update();
	while (this->frametimer->stepsLeft())
    {
		stepLogic();
       
        for (i = 0; i < liikkuvacount; i++)
        {
            liikkuvat[i].update();
        }
        for (it2 = this->emitterit.begin(); it2 != this->emitterit.end(); it2++)
        {
            RopeEmitter &e = *it2;
            e.update();
            //horrible hack;
            e.init();
        }

		this->frametimer->endStep();
    }


	float moduletime = dmsGetModulePosition();
	float speechsync = 0.0f;
	if(moduletime > 235497)
	{
		speechsync = Math::calcPosFloat(moduletime, 237842, 237842+1000);
		speechsync -= Math::calcPosFloat(moduletime, 253047, 253047+1000);
		speechsync = Math::clampVal(speechsync * analval * 1.25f, 0, 1);
	}


    Vector3 cam = Vector3(0,2,0) 
				+ Math::sphereToCartesian(3.0f-pos*1.25f, pos*2.0f,-pos*3.15f-2.1f*sinf(pos*1.35f));
	Vector3 tgt = (t1 + t2 + t3 + t4 + t5)*0.2f;
	//tgt += tool->getColor("color3") * powf(Math::calcPosFloat(pos, 0.85f, 1.0f),2) * tool->getValue("slider2") * 2.0f;
	tgt += Vector3(0.04f, 0.75f, 0.5f) * powf(Math::calcPosFloat(pos, 0.85f, 1.0f),2) * 0.86f;
    Vector3 upw = Vector3(0, 1, 0);


	ropescamposition = cam;
    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);

    for (it2 = this->emitterit.begin(); it2 != this->emitterit.end(); it2++)
    {
        RopeEmitter &e = *it2;
        e.draw(alpha);
    }

    
    glPointSize(3.0f);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    glDisable(GL_TEXTURE_2D);
    glBegin(GL_POINTS);
    std::vector<Alkuotus>::iterator it;
	int zz=0;
	float linealpha = alpha;
	linealpha *= (1-speechsync*0.75f);
	float sync = trigut2->get(dmsGetModulePosition());
	float linealpha2 = sinf(3.14f*sync);
	linealpha2 += Math::calcPosFloat(dmsGetModulePosition(), 238200, 239268);
	if(linealpha2 > 1.0f) linealpha2 = 1.0f;
	float randomalpha = powf(sinf(pos*2.0f),4);
	for (it = ropeotukset.begin(); it < ropeotukset.end(); it++)
    {
        (*it).drawLine(zz<1000 ? (((zz&7)==0) ? linealpha*randomalpha : linealpha) : linealpha2);
		zz++;
    }
    glEnd();
    glDisable(GL_POINT_SMOOTH);
	glDisable(GL_LINE_SMOOTH);

    glPointSize(3.0f);
    glDisable(GL_TEXTURE_2D);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glBegin(GL_POINTS);

	if(moduletime > 228000)
	{
		float liikkuvaalpha = alpha*(powf(Math::calcPosFloat(moduletime,228000, 229999), 2)); 
		for (i = 0; i < liikkuvacount; i++)
		{
			liikkuvat[i].draw(liikkuvaalpha, 7.5f);
		}	
	}

    glEnd();
    glDisable(GL_POINT_SMOOTH);


    glEnable(GL_TEXTURE_2D);
    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);
    glDisable(GL_DEPTH_TEST);
    glBlendFunc(GL_ONE, GL_ONE);
    glDepthMask(0);

	float size = 0.1f + (speechsync*0.1f);;
	Vector3 sizexr = xr * size;
	Vector3 sizeyr = yr * size;

	// sync
	//sync += analval;
	//speechtrigu->get(dmsGetModulePosition());

	if(speechsync > 0.0f)
    	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_turq.jpg")->getID());
	else
		glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_blue.jpg")->getID());

    glBegin(GL_QUADS);
	// draw flashes
		if(speechsync > 0.0f || (sync > 0.0f && moduletime > 228000))
		{
			float sc = sinf(sync*3.14f)*0.5f;
			float sc2 = speechsync;
			glColor3f(sc+sc2,sc+sc2,sc+sc2);
			for (i = 0; i < liikkuvacount; i++)
			{
				Vector3 p = liikkuvat[i].movement.getPosition();
				
				p.y *= 7.5f;

				Vector3 v1 = p - sizexr - sizeyr;
				Vector3 v2 = p + sizexr - sizeyr;
				Vector3 v3 = p + sizexr + sizeyr;
				Vector3 v4 = p - sizexr + sizeyr;

				
				glTexCoord2f(0, 0);
				glVertex3fv((float *)&v1);
				glTexCoord2f(1, 0);
				glVertex3fv((float *)&v2);
				glTexCoord2f(1, 1);
				glVertex3fv((float *)&v3);
				glTexCoord2f(0, 1);
				glVertex3fv((float *)&v4);
    

			}	
		}
    glEnd();

    glDepthMask(1);
	glEnable(GL_DEPTH_TEST);

	glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDisable(GL_TEXTURE_2D);

	alpha *= 0.475f;

	glColor4f(0.9f, 0.4f, 0.15f, alpha);
	            

	glLineWidth(2);
    glEnable(GL_LINE_SMOOTH);

	int p = 0;
	for(int z=0; z<oliot; z++)
	{
		switch((z)&3)
		{
        case 0: 
			glColor4f(0.4f, 0.27f, 0.9f, alpha);
			break;
		case 1: 
			glColor4f(0.4f, 0.47f, 0.9f, alpha);
			break;
        case 2: 
			glColor4f(0.4f, 0.47f, 0.79f, alpha);
			break;
		case 3: 
			glColor4f(0.9f, 0.3f, 0.8f, alpha); 
			break;
		}


		glBegin(GL_LINE_STRIP);
		for(int i=0; i<obutperolio-1; i++)
		{
			glVertex3fv((float*)&(mObjects[p]->mPos));
			p++;
		}
		p++;
		glEnd();
	}
    glDisable(GL_LINE_SMOOTH);
}

Ropes::Ropes()
{	
    
	anal = new Analyzer(3);

}

Ropes::~Ropes()
{
}


bool Ropes::init(unsigned long s, unsigned long e)
{
	this->frametimer = new FrameTimer(1000 / 60.0f, 15);
	startTime = s;
	endTime = e;
	

	mConstraints.clear();
	mObjects.clear();

	int i;
    for (i = 0; i < 2500; i++)
    {
        Alkuotus otus;
        otus.init();
		BoundedMovement *movement = otus.getMovement();
		movement->setBoundLimits(-4,4,-4,4,-4,4);
		movement->setPosition(Vector3(Math::randBetween(-23, 23), 
										Math::randBetween(-23, 23),
										Math::randBetween(-23, 23)));

        if (i % 6 == 0)
        {            
            movement->setSpeed(Math::randBetween(0.075f, 0.10f));
        }
        ropeotukset.push_back(otus);
    }


	trigut = new TriggerSystem();
	trigut->add(229207+250, 230557+250);
	trigut->add(232299+250, 232949+250);
	trigut->add(236402+250, 237652+250);

	trigut2 = new TriggerSystem();
	trigut2->add(229207+250, 230557+1050);
	trigut2->add(232299+250, 232949+2350);
	//trigut2->add(236402+250, 237652+1000);

	speechtrigu = new TriggerSystem();
	speechtrigu->add(248497, 249547);
	speechtrigu->add(248986, 250036);
	speechtrigu->add(249474, 250524);
	speechtrigu->add(249986, 251036);
	speechtrigu->add(250498, 251548);
	speechtrigu->add(250987, 252037);
	speechtrigu->add(251522, 252572);
	speechtrigu->add(252034, 253084);
	speechtrigu->add(252593, 253643);
	speechtrigu->add(253058, 254108);
	speechtrigu->add(253547, 254597);
	speechtrigu->add(238210, 239260);
	speechtrigu->add(239072, 240122);
	speechtrigu->add(241259, 242309);
	speechtrigu->add(242260, 243310);
	speechtrigu->add(243097, 244147);
	speechtrigu->add(238842, 239892);
	speechtrigu->add(240040, 241090);
	speechtrigu->add(247203, 248253);

	spl1 = new CatmullRom();
	spl2 = new CatmullRom();
	spl3 = new CatmullRom();
	spl4 = new CatmullRom();
	spl5 = new CatmullRom();
	
	srand(19);

	Vector3 moveup = Vector3(0,1,0);

	Vector v1 = Vector(0,0,0);

	for(i=0; i<14; i++) spl1->addPoint((Vector3)v1+Math::randVector(0.62f, 0.52f, -1.25f)+moveup);
	for(i=0; i<9; i++) spl2->addPoint((Vector3)v1+Math::randVector(1.42f, 1.42f, -1.25f)+moveup);
	for(i=0; i<14; i++) spl3->addPoint((Vector3)v1+Math::randVector(0.42f, 2.0f, -1.25f)+moveup);
	for(i=0; i<10; i++) spl4->addPoint((Vector3)v1+Math::randVector(1.42f, 1.42f, -1.25f)+moveup);
	for(i=0; i<8; i++) spl5->addPoint((Vector3)v1+Math::randVector(1.62f, 1.62f, -1.25f)+moveup);
	
	spl1->addPoint(Vector3());
	spl2->addPoint(Vector3());
	spl3->addPoint(Vector3());
	spl4->addPoint(Vector3());
	spl5->addPoint(Vector3());

	spl1->endCreation();
	spl2->endCreation();
	spl3->endCreation();
	spl4->endCreation();
	spl5->endCreation();


	t1 = spl1->getValue(0.00f);
	t2 = spl2->getValue(0.00f);
	t3 = spl3->getValue(0.00f);
	t4 = spl4->getValue(0.00f);
	t5 = spl5->getValue(0.00f);


	srand(23);
	oliot = 200;
	moveobut = new VerletObject*[oliot];
	Vector3 posp;
	int zcount = oliot/5;
	const int count = 30;
	obutperolio = count;
	Vector posold;
	
	for(int z=0; z<oliot; z++)
	{
		int i;
		VerletObject **p = new VerletObject*[count];
		
		if(z<zcount) posold = t1;
		else if(z<zcount*2) posold = t2;
		else if(z<zcount*3) posold = t3;
		else if(z<zcount*4) posold = t4;
		else  posold = t5;

		for(i=0; i<count; i++)
		{
			p[i] = new VerletObject();
			p[i]->mStatic = (i!=0 ? false : true);
		
			float mod = i==0 ? 0.025f : 0.1260f;
			
			posold = posold + Math::randVector()*mod;
			p[i]->setPosition(posold);
			/*
			}
			else if(z < zcount*2)
			{
				p[i]->setPosition(posold);
			}
			else if(z < zcount*3)
			{
				p[i]->setPosition(posold);
			}
			else if(z < zcount*4)
			{
				p[i]->setPosition(posold);
			}
			else
			{
				p[i]->setPosition(t5 + Math::randVector()*mod);
			}
			*/

			mObjects.push_back(p[i]);
		}
			
		moveobut[z] = p[0];

		for(i=1; i<count; i++)
		{
			VerletConstraint *v = new VerletConstraint();
			v->setObjects(p[i-1], p[i]);
			v->mRestDistance = 0.005f + Math::randFloat(0.065f);
			mConstraints.push_back(v);
		}
	}

	// Step logic a bit to get things balanced
	for(i=0; i<100; i++) stepLogic();

    for (i = 0; i < 4; i++)
    {
        RopeEmitter e;
        e.init();
        Texture *texture;
        switch(i%2)
        {
            case 0:
                texture = dmsGetTexture("bubble1.png"); break;
            case 1:
                texture = dmsGetTexture("bubble2.png"); break;
        }
        e.texture = texture;
        this->emitterit.push_back(e);		
    }



	return true;
}



// ---------------------

VerletObject::VerletObject()
{
	this->mStatic = false;
	this->mPos = Vector();
	this->mOldPos = Vector();
	this->mForce = Vector(0,0,0);
	this->mMass = 1000.0f;
	this->mInvMass = 1.0f/mMass;
	this->mAlive = true;
}
VerletObject::~VerletObject()
{}

void VerletObject::setPosition(Vector3 p)
{
	this->mPos = p;
	this->mOldPos = p;
}
void VerletObject::setSpeed(Vector3 v)
{
	this->mOldPos = mPos - v;
}
void VerletObject::setMass(float m)
{
	this->mMass = m;
	this->mInvMass = 1.0f/m;
}

Vector3 VerletObject::getPosition()
{
	return this->mPos;
}

Vector3 VerletObject::getSpeed()
{
	return (this->mOldPos - this->mPos);
}

float VerletObject::getMass()
{
	return this->mMass;
}
	
void VerletObject::accumulateForces()
{
	// ?! gravity?
	//float GRAVITY = 0.01f;//tool->getValue("slider1") * 10.0f ;
	//mForce += Vector3(0, -GRAVITY, 0) * mMass;
}

void VerletObject::resetForces()
{
	this->mForce = Vector3(0,0,0);
}
	
void VerletObject::update()
{
	if(!mStatic)
	{
		Vector3 op = mPos;
		mPos += ((mPos-mOldPos)*DAMPEN_FACTOR) + (mForce * mInvMass);
		mOldPos = op;
	}
}

void VerletObject::destroy()
{
	this->mAlive = false;
}

bool VerletObject::getStatic()
{
	return this->mStatic;
}

void VerletObject::setStatic(bool b)
{
	this->mStatic = b;
}
	
// ---------------------------------------------------

VerletConstraint::VerletConstraint()
{
	mObjectA = NULL;
	mObjectB = NULL;
	this->mAlive = true;
	this->mRestDistance = 0.1f;
}

VerletConstraint::~VerletConstraint()
{

}

void VerletConstraint::setObjects(VerletObject *a1, VerletObject *a2)
{
	this->mObjectA = a1;
	this->mObjectB = a2;
}

void VerletConstraint::setRestDistance(float l)
{
	this->mRestDistance = l;
}

void VerletConstraint::satisfyConstraint()
{
	// STICK
	if(mObjectB->mStatic && mObjectA->mStatic) return;

	Vector3 d = mObjectB->mPos - mObjectA->mPos;
	
	float len = sqrt(d.x*d.x + d.y*d.y + d.z*d.z);
	if(len < 0.001f) len = 0.001f;
	float diff = (len - mRestDistance) / len;
	
	if(!mObjectA->mStatic)
	{
		mObjectA->mPos += d * diff * 0.5f;
	}
	
	if(!mObjectB->mStatic)
	{
		mObjectB->mPos -= d * diff * 0.5f;
	}
}

void VerletConstraint::destroy()
{}

VerletObject *VerletConstraint::getObjectA()
{
	return this->mObjectA;
}

VerletObject *VerletConstraint::getObjectB()
{
	return this->mObjectB;
}
