#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Pohja.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"
#include "alkuotukset.h"
#include "../boundedmovement.h"

void Pohja::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

	renderScene(pos, alpha);
}


void Kolmikko::update()
{
    this->fadeTimer -= 0.01f;
    if (this->emitTimer > 0.0f)
    {
        this->emitTimer -= 0.05f;
    }
    this->t1 += this->h1;
    this->t2 += this->h2;
    this->t3 += this->h3;

    const float fadeup = 0.003f;
    this->f1 = min(this->f1 + fadeup, this->f1max);
    this->f2 = min(this->f2 + fadeup, this->f2max);
    this->f3 = min(this->f3 + fadeup, this->f3max);

    if (this->f1 + this->f2 + this->f3 > (this->f1max + this->f2max + this->f3max) * 0.7f)
    {
        this->canEmit = true;
    }
    else
    {
        this->canEmit = false;
    }

}
void Kolmikko::render(float alpha, Vector3 &xr, Vector3 &yr)
{
    float extrafade = 0.15f * (this->fadeTimer > 0.0f ? alpha * this->fadeTimer : 0);

    float fade1 = 0.8f + 0.2f * sinf(this->t1) + extrafade;
    float fade2 = 0.8f + 0.2f * sinf(this->t2) + extrafade;
    float fade3 = 0.8f + 0.2f * sinf(this->t3) + extrafade;

    Vector3 c = (this->p1 + this->p2 + this->p3)*0.333333f;
    Vector3 k1 = this->p1 - c;
    Vector3 k2 = this->p2 - c;
    Vector3 k3 = this->p3 - c;

    const float movement = sinf(this->emitTimer*3.141592f)*0.5f;//extrafade*10;
    Vector3 a1 = this->p1 + k1 * movement - xr * this->s1 * fade1 - yr * this->s1 * fade1;
    Vector3 a2 = this->p1 + k1 * movement + xr * this->s1 * fade1 - yr * this->s1 * fade1;
    Vector3 a3 = this->p1 + k1 * movement + xr * this->s1 * fade1 + yr * this->s1 * fade1;
    Vector3 a4 = this->p1 + k1 * movement - xr * this->s1 * fade1 + yr * this->s1 * fade1;

    Vector3 b1 = this->p2 + k2 * movement - xr * this->s2 * fade2 - yr * this->s2 * fade2;
    Vector3 b2 = this->p2 + k2 * movement + xr * this->s2 * fade2 - yr * this->s2 * fade2;
    Vector3 b3 = this->p2 + k2 * movement + xr * this->s2 * fade2 + yr * this->s2 * fade2;
    Vector3 b4 = this->p2 + k2 * movement - xr * this->s2 * fade2 + yr * this->s2 * fade2;

    Vector3 c1 = this->p3 + k3 * movement - xr * this->s3 * fade3 - yr * this->s3 * fade3;
    Vector3 c2 = this->p3 + k3 * movement + xr * this->s3 * fade3 - yr * this->s3 * fade3;
    Vector3 c3 = this->p3 + k3 * movement + xr * this->s3 * fade3 + yr * this->s3 * fade3;
    Vector3 c4 = this->p3 + k3 * movement - xr * this->s3 * fade3 + yr * this->s3 * fade3;

    glColor4f(1, 1, 1, alpha * this->f1 * fade1);
    glTexCoord2f(0, 0);
    glVertex3fv((float *)&a1);
    glTexCoord2f(1, 0);
    glVertex3fv((float *)&a2);
    glTexCoord2f(1, 1);
    glVertex3fv((float *)&a3);
    glTexCoord2f(0, 1);
    glVertex3fv((float *)&a4);

    glColor4f(1, 1, 1, alpha * this->f2 * fade2);
    glTexCoord2f(0, 0);
    glVertex3fv((float *)&b1);
    glTexCoord2f(1, 0);
    glVertex3fv((float *)&b2);
    glTexCoord2f(1, 1);
    glVertex3fv((float *)&b3);
    glTexCoord2f(0, 1);
    glVertex3fv((float *)&b4);

    glColor4f(1, 1, 1, alpha * this->f3 * fade3);
    glTexCoord2f(0, 0);
    glVertex3fv((float *)&c1);
    glTexCoord2f(1, 0);
    glVertex3fv((float *)&c2);
    glTexCoord2f(1, 1);
    glVertex3fv((float *)&c3);
    glTexCoord2f(0, 1);
    glVertex3fv((float *)&c4);

}

void Kolmikko::setFade()
{
    this->fadeTimer = 1.0f;
    this->emitTimer = 1.0f;

}

void Kolmikko::init(Vector3 &position, float start, float sizemod)
{
    const float hajonta = 0.2f*sizemod;
    this->p1 = position + Math::randVector()*hajonta;
    this->p2 = position + Math::randVector()*hajonta;
    this->p3 = position + Math::randVector()*hajonta;

    const float minfade = 0.5f;
    const float maxfade = 0.8f;
    this->f1max = Math::randBetween(minfade, maxfade);
    this->f2max = Math::randBetween(minfade, maxfade);
    this->f3max = Math::randBetween(minfade, maxfade);

    this->f1 = start;
    this->f2 = start;
    this->f3 = start;

    const float minsize = 0.1f;
    const float maxsize = 0.2f;
    this->s1 = Math::randBetween(minsize, maxsize) * sizemod;
    this->s2 = Math::randBetween(minsize, maxsize) * sizemod;
    this->s3 = Math::randBetween(minsize, maxsize) * sizemod;

    this->t1 = 0.0f;
    this->t2 = 0.0f;
    this->t3 = 0.0f;

    const float minspeed = 0.01f;
    const float maxspeed = 0.05f;

    this->h1 = Math::randBetween(minspeed, maxspeed);
    this->h2 = Math::randBetween(minspeed, maxspeed);
    this->h3 = Math::randBetween(minspeed, maxspeed);

    this->canEmit = false;
    this->fadeTimer = 0.0f;
    this->emitTimer = -1.0f;

}

Vector3 NousevaTurbulenssi(Vector3 &pos, float time)
{
    float x = sinf(pos.x + time * 6);
    float y = cosf(pos.y + pos.x + pos.z + time * 0.3f) * 0.1f;
    float z = sinf(pos.z - pos.x + time * 3)*0.5f;
    return Vector3(x, y, z);

}

void Nouseva::update()
{
    this->time += 0.003f;
    this->position += Vector3(0, 0.01f, 0) + NousevaTurbulenssi(this->position, this->time)*0.0051f; //TODO
    this->rotation += this->rotationdelta;
}

void Nouseva::render(float alpha, float sync, Vector3 &xr, Vector3 &yr, int id)
{
    int i = 0;
/*
    float size = 0.1f;
    Vector3 a1 = this->position - xr * size - yr * size;
    Vector3 a2 = this->position + xr * size - yr * size;
    Vector3 a3 = this->position + xr * size + yr * size;
    Vector3 a4 = this->position - xr * size + yr * size;

    float fade = Math::calcPosCos(this->time, 0.0f, 0.02f) * cosf(this->time * 3.141592f * 0.5f);
    glColor4f(1, 1, 1, alpha * fade * 0.4f);
    glTexCoord2f(0, 0);
    glVertex3fv((float *)&a1);
    glTexCoord2f(1, 0);
    glVertex3fv((float *)&a2);
    glTexCoord2f(1, 1);
    glVertex3fv((float *)&a3);
    glTexCoord2f(0, 1);
    glVertex3fv((float *)&a4);
*/

	// TODO: set these modes etc only once..

	glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

	float size = 0.05f;
    Texture *texture;
    switch(id%2)
    {
        case 0:
            texture = dmsGetTexture("bubble1.png"); break;
        case 1:
            texture = dmsGetTexture("bubble2.png"); break;
    }

    glBindTexture(GL_TEXTURE_2D, texture->getID());

	Vector3 p;

     
	glColor3f(1,1,1);
		p = this->position;
		
    glBegin(GL_QUADS);

		Vector3 sizexr = xr * size;
		Vector3 sizeyr = yr * size;
		Vector3 v1 = p - sizexr - sizeyr;//xr * -size + yr * -size;
		Vector3 v2 = p + sizexr - sizeyr;//+ xr *  size + yr * -size;
		Vector3 v3 = p + sizexr + sizeyr;//xr *  size + yr *  size;
		Vector3 v4 = p - sizexr + sizeyr;//xr * -size + yr *  size;

		
		glTexCoord2f(0, 0);
		glVertex3fv((float *)&v1);
		glTexCoord2f(1, 0);
		glVertex3fv((float *)&v2);
		glTexCoord2f(1, 1);
		glVertex3fv((float *)&v3);
		glTexCoord2f(0, 1);
		glVertex3fv((float *)&v4);
    
    glEnd();

	glDisable(GL_TEXTURE_2D);

	// vanha alla
/*
    float fade = Math::calcPosCos(this->time, 0.0f, 0.02f) * cosf(this->time * 3.141592f * 0.5f);

    glColor4f(0.5f, 0.7f, 0.9f, fade * alpha);
    glPushMatrix();
    glTranslatef(this->position.x, this->position.y, this->position.z);
    glRotatef(360 * this->rotation.x, 1, 0, 0);
    glRotatef(360 * this->rotation.y, 0, 1, 0);
    glRotatef(360 * this->rotation.z, 0, 0, 1);

    const int strips = 40;
    Vector3 table[strips];

    const float radius = 0.1f * this->size;
    glBegin(GL_LINE_LOOP);
    for (i = 0; i < strips; i++)
    {
        float t = i / (float)strips;
        float a = t * 3.141592f * 2;

        const float disp = cosf(t * 3.141592f * 2);
        const float r = radius * (0.5f + 0.3f*disp * disp) * fade * (1.2f+0.2f*sinf(this->time * 10.4f));
        Vector3 p = Vector3(sinf(a), cosf(a), (0.5f+0.5f*sinf(this->time*6))*0.02f*sinf(t*2*3.141592f*4)) * r;
        glVertex3fv((float *)&p);
        table[i] = p;
    }
    glEnd();

    float shade = Vector3(1, 0.4f, 0.7f).normalize().dotProduct(this->rotation);
    Vector3 color1 = Vector3(0.5f, 0.7f, 0.9f);
    Vector3 color2 = Vector3(0.9f, 0.66f, 0.4f);
    Vector3 c = color1 + (color2 - color1) * sync;
    glColor4f(c.x, c.y, c.z, fade * alpha * shade * 0.3f);

    glBegin(GL_TRIANGLE_FAN);
    for (i = 0; i < strips; i++)
    {
        glVertex3fv((float *)&table[i]);
    }
    glEnd();

    glPopMatrix();
*/
}

bool Nouseva::isDead()
{
    return this->time >= 1.0f;
}

void Pohja::renderScene(float pos, float alpha)
{
/*
    Vector3 cam = Vector3(0.1f, 6, -7);
    Vector3 tgt = Vector3(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);
*/
    std::vector<Kolmikko>::iterator i;
    std::list<Nouseva>::iterator j;

    static int updatecount = 0;
    
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (i = kolmikot.begin(); i < kolmikot.end(); i++)
        {
            Kolmikko &k = *i;
            k.update();
        }
        for (i = kolmikot2.begin(); i < kolmikot2.end(); i++)
        {
            Kolmikko &k = *i;
            k.update();
        }
        for (j = nousevat.begin(); j != nousevat.end(); )
        {
            Nouseva &n = *j;
            n.update();
            if (n.isDead())
            {
                j = nousevat.erase(j);
            }
            else
            {
                j++;
            }
        }

		std::vector<Alkuotus>::iterator it;
		for (it = otukset.begin(); it < otukset.end(); it++)
        {
            (*it).update();
        }

		if(dmsGetModulePosition() < 237000)
		{
			//uudet nousevat
			updatecount++;
			if (updatecount % 25 == 0 && (int)nousevat.size() < 500)
			{
				int count = (int)kolmikot.size();
				for (int i = 0; i < 4; i++)
				{
					int offset = rand() % count;
					Kolmikko &k = kolmikot[offset];

					if (k.canEmit)
					{
						Vector3 start = (k.p1 + k.p2 + k.p3) * 0.33333f;
						k.setFade();

						Nouseva n;
						n.position = start;
						n.rotation = Math::randVectSphere();
						n.rotationdelta = Math::randVectSphere() * 0.002f;
						n.time = 0.0f;
						n.size = Math::randBetween(0.3f, 0.7f);

						nousevat.push_front(n);
					}
				}
			}
		}

        this->frametimer->endStep();
    }

    cameras->useCamera(0);

    glDepthMask(0);


    float sync = 0.2f*anal->get_balanced();
    
	//this->merenpohja->render(dmsGetTexture("deeptxt2.jpg"), alpha*0.3f);
	this->merenpohja->renderWithNormalMaps(dmsGetTexture("deeptxt3.jpg"), dmsGetTexture("normal_map_deep3.jpg"), Vector3(1,1,1), alpha*0.25f);

    glDepthMask(1);

    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);

    glEnable(GL_TEXTURE_2D);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_BLEND);
    glDisable(GL_DEPTH_TEST);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_white.jpg")->getID());

    glBegin(GL_QUADS);
    for (i = kolmikot.begin(); i < kolmikot.end(); i++)
    {
        Kolmikko &k = *i;
        k.render(alpha, xr, yr);
    }
    glEnd();
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_yellow.jpg")->getID());

    glBegin(GL_QUADS);
    for (i = kolmikot2.begin(); i < kolmikot2.end(); i++)
    {
        Kolmikko &k = *i;
        k.render(alpha, xr, yr);
    }
    glEnd();

    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_white.jpg")->getID());

//    glBegin(GL_QUADS);

    filter.init(true);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_LINE_SMOOTH);
    Math::antiRotate(&xr, &yr, &zr);

    glLineWidth(2.0f);
	int nnn = 0;
    for (j = nousevat.begin(); j != nousevat.end(); j++)
    {
        Nouseva &n = *j;
        n.render(alpha, sync, xr, yr, nnn);
		nnn++;
    }
    
    glPointSize(3.0f);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    glDisable(GL_TEXTURE_2D);
    glBegin(GL_POINTS);
    std::vector<Alkuotus>::iterator it;
	for (it = otukset.begin(); it < otukset.end(); it++)
    {
        (*it).drawLine(alpha);
    }
    glEnd();
    glDisable(GL_POINT_SMOOTH);
	glDisable(GL_LINE_SMOOTH);

    filter.glow(8, 0.005f, 0.005f, 0.91f, -1.0f, 1.0f);
//    glEnd();
}




Pohja::Pohja()
{
    const float size = 7.0f;
    const float size2 = 14.0f;

    int i = 0;
    srand(6116);
    for (i = 0; i < 150; i++)
    {
        Vector3 p = Vector3(Math::randBetween(-size, size), 
                            0, 
                            Math::randBetween(-size, size));
        const float start = Math::randBetween(-0.5f, 0.0f);
        Kolmikko k; 
        k.init(p, start);
        kolmikot.push_back(k);
    }

    for (i = 0; i < 70; i++)
    {
        Vector3 p = Vector3(Math::randBetween(-size2, size2), 
                            0, 
                            Math::randBetween(-size2, size2));

        float a = Math::randFloat()*2*3.141592f;
        Vector3 dir = Vector3(cosf(a), 0, sinf(a)) * 0.2f;

        int count = 10 + rand()%12;
        const float start = Math::randBetween(-0.7f, -0.3f);
        for (int j = 0; j < count; j++)
        {
            float s = start + j * 0.06f;
            Kolmikko k;
            k.init(p, s, 0.7f );

            p += dir;
            kolmikot2.push_back(k);

        }
    }
    const int groundX = 50;
    const int groundY = 50;
    this->merenpohja = new GroundPlane(groundX, groundY, size2, 6.0f);
    this->merenpohja->makeCircularFade(40.0f, 40.0f);
    anal = new Analyzer(3);
/*
    this->merenpohja->setupFade();
    float *fade = this->merenpohja->getFade();

    vector<Kolmikko>::iterator iter;

    for (iter = this->kolmikot.begin(); iter < this->kolmikot.end(); iter++)
    {
        Kolmikko &k = *iter;
        Vector3 &p = k.p1;

        int ix = p.x + size2 * 0.5f;
        int iy = p.z + size2 * 0.5f;

        const int kernelsize = 2;
        for (int a = iy - kernelsize; a < iy + kernelsize; a++)
        {
            for (int b = ix - kernelsize; b < iy + kernelsize; b++)
            {
                float dx = fabsf(b - ix) / (float)kernelsize;
                float dy = fabsf(a - iy) / (float)kernelsize;
                float value = this->merenpohja->safeGet(a, b);
                this->merenpohja->safePut(a, b, 1.0f);//value + sqrtf(1 - dx*dx + dy*dy));
            }
        }
    }
    this->merenpohja->enableFade();
*/
    this->frametimer = new FrameTimer(1000 / 60, 5);

    for (i = 0; i < 500; i++)
    {
        Alkuotus otus;
        otus.init();
        if (i % 6 == 0)
        {
            BoundedMovement *movement = otus.getMovement();
            movement->setSpeed(Math::randBetween(0.03f, 0.1f));
        }
        this->otukset.push_back(otus);
    }


}

Pohja::~Pohja()
{
}


bool Pohja::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

