#define RALEN_SAADOT

#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Oliot.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

extern void setClearColor(Vector3 color);

// Siirsin tnne koska kytn muual & ei tarvii tupla resurssei!
LiikkuvaOlio *liikkuvat;
int liikkuvacount;

void Oliot::draw()
{
	setClearColor(Vector3(0.005f, 0.005f, 0.01f));
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.99f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}


/////////////////////////////////////////////////////////////////////////////
///                             KampaOlio            
/////////////////////////////////////////////////////////////////////////////


void KampaOlio::init()
{
    const float r = Math::randBetween(7.0f, 9.0f);
    const float a = Math::randFloat() * 2 * 3.141592f;
    const float y = Math::randBetween(0.3f, 3.0f);

    this->position = Vector3(cosf(a) * r, y, sinf(a) * r);
    this->orientation = Math::randVectSphere()*2*3.141592f;


    switch(rand()%3)
    {
        case 0:
//            this->color = Vector3(0.3f, 0.6f, 0.7f);
            this->color = Vector3(0.6f, 0.2f, 0.3f);
            this->texture = dmsGetTexture("flare_white.jpg");
            break;
        case 1:
//            this->color = Vector3(0.3f, 0.6f, 0.7f);
            this->color = Vector3(0.6f, 0.2f, 0.3f);
            this->texture = dmsGetTexture("flare_red.jpg");
            break;
        case 2:
//            this->color = Vector3(0.8f, 0.3f, 0.8f);
            this->color = Vector3(0.8f, 0.3f, 0.5f);
            this->texture = dmsGetTexture("flare_blue.jpg");
            break;
    }

    this->length = Math::randBetween(0.3f, 0.5f);
    this->width = Math::randBetween(0.1f, 0.25f);
    this->spikes = 7 + rand()%7;

    this->rightside = new Vector3[this->spikes];
    this->leftside = new Vector3[this->spikes];
    this->sizes = new float[this->spikes];

    this->aika = 0.0f;
    this->speed = Math::randBetween(0.002f, 0.005f);
    this->rotation = Math::randVectSphere() * 0.001f;
    this->initVelocity();
}

void KampaOlio::initVelocity()
{
    this->velocity = Math::randVectSphere() * 0.0015f;
}

void KampaOlio::update()
{
    this->aika += this->speed;
    this->position += this->velocity;
    this->orientation += this->rotation;

    if (this->position.y <  0.1f)
    {
        this->initVelocity();
        this->velocity.y = fabsf(this->velocity.y);
    }

}
void KampaOlio::drawValo(Vector3 &pos, Vector3 &xr, Vector3 &yr, Vector3 &zr, float size, float alpha)
{
    Vector3 v1 = pos + xr * -size + yr * -size;
    Vector3 v2 = pos + xr *  size + yr * -size;
    Vector3 v3 = pos + xr *  size + yr *  size;
    Vector3 v4 = pos + xr * -size + yr *  size;

    glColor4f(1,1,1, alpha);
    glTexCoord2f(0, 0);
    glVertex3fv((float *)&v1);
    glTexCoord2f(1, 0);
    glVertex3fv((float *)&v2);
    glTexCoord2f(1, 1);
    glVertex3fv((float *)&v3);
    glTexCoord2f(0, 1);
    glVertex3fv((float *)&v4);
}

void KampaOlio::draw(float alpha)
{
    int i = 0;
    glPushMatrix();
    glTranslatef(this->position.x, this->position.y, this->position.z);
    glRotatef(360 * this->orientation.x, 1, 0, 0);
    glRotatef(360 * this->orientation.y, 0, 1, 0);
    glRotatef(360 * this->orientation.z, 0, 0, 1);

    Matrix rot;

    glDepthMask(0);
    glDisable(GL_TEXTURE_2D);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);
    glBegin(GL_LINES);
    for (i = 0; i < this->spikes; i++)
    {
        float t  = i / (float)(this->spikes - 1);
        Vector3 p = Vector3(this->length * (2 * t - 1), 0, 0);

        rot.makeRotation(0.15f * sinf(t*7 + this->aika * 12), 0, 0);
        
        const float w = powf(sinf(t * 3.141592f), 1.0f + 0.3f*sinf(this->aika*15)) * this->width;

        this->sizes[i] = 0.3f * w;
        Vector3 v1 = p + Vector3(0, w, 0) * rot;
        Vector3 v2 = p + Vector3(0, -w, 0) * rot;

        this->leftside[i] = v1;
        this->rightside[i] = v2;

        glColor4f(this->color.x, this->color.y, this->color.z, alpha*(0.7f + 0.3f*sinf(this->aika*8+i*0.3f)));
        glVertex3fv((float *)&v1);
        glVertex3fv((float *)&v2);
    }
    glEnd();


    glEnable(GL_TEXTURE_2D);

    float texturefade = 0.0f;
	// Haetaan vastaava tekstuuri
    if (this->special)
    {
        // Caustic numero
        int n = int(this->aika*32*20*1.5f)%32 + 1;
	
	    char buf[75];
	    sprintf(buf, "cau_0%02d.jpg", n);
	    Texture *texture = dmsGetTexture(buf);
        glBindTexture(GL_TEXTURE_2D, texture->getID());
        texturefade = 1.4f;
    }
    else
    {
        glBindTexture(GL_TEXTURE_2D, dmsGetTexture("deeptxt2.jpg")->getID());
        texturefade = 0.4f;
    }
    
    glColor4f(this->color.x, this->color.y, this->color.z, alpha*0.2f);
    glBegin(GL_QUAD_STRIP);
    for (i = 0; i < this->spikes; i++)
    {
        Vector3 leftvertex = this->leftside[i];
        Vector3 rightvertex = this->rightside[i];

        const float texscale = 2.0f;

        glTexCoord2f(leftvertex.x, leftvertex.y);
        glVertex3fv((float *)&leftvertex);
        glTexCoord2f(rightvertex.x, rightvertex.y);
        glVertex3fv((float *)&rightvertex);
    }
    glEnd();

    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);
	glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBindTexture(GL_TEXTURE_2D, this->texture->getID());
    glBegin(GL_QUADS);
    for (i = 0; i < this->spikes; i++)
    {
        const float alphamod = 0.3f+0.3f*sinf(i*0.5f + this->aika* 16);
        drawValo(this->leftside[i], xr, yr, zr, this->sizes[i], alpha*alphamod);
        drawValo(this->rightside[i], xr, yr, zr, this->sizes[i], alpha*alphamod);
    }
    
    glEnd();
    glDepthMask(1);
    glPopMatrix();
}

/////////////////////////////////////////////////////////////////////////////
///                             RihmaOlio
/////////////////////////////////////////////////////////////////////////////

void RihmaOlio::init()
{
    int i = 0;
    const float r = 7.0f;
    const float a = Math::randFloat() * 2 * 3.141592f;
    const float y = Math::randBetween(0.3f, 3.0f);

    this->position = Vector3(cosf(a) * r, y, sinf(a) * r);
    this->st = Math::randBetween(193580, 194580);
    this->et = this->st + Math::randBetween(500, 800);

    this->st2 = Math::randBetween(195580, 196580);
    this->et2 = this->st2 + Math::randBetween(800, 1600);

    //this->st = Math::randBetween(0.44f, 0.50f);
    //this->et = this->st + Math::randBetween(0.01f, 0.02f);

    //this->st2 = Math::randBetween(0.65f, 0.68f);
    //this->et2 = this->st2 + Math::randBetween(0.02f, 0.04f);

    const int splinepoints = 7;

    this->path = new CatmullRom();
    this->path->startCreation();

    Vector3 p = this->position;

//    dmsMsg("RihmaOlio() - position = (%2.2f %2.2f %2.2f)\n", this->position.x, this->position.y, this->position.z);
    
    for (i = 0; i < splinepoints; i++)
    {
        this->path->addPoint(p);

        Vector3 d = Math::randVectSphere() * 0.2f;
        d.y = fabsf(d.y) * 7;

        p += d;
//        dmsMsg("          - position = (%2.2f %2.2f %2.2f)\n", p.x, p.y, p.z);
    }

    this->path->endCreation();
//    this->path->arcLengthParametrize();

    switch(rand()%3)
    {
        case 0:
            this->color = Vector3(0.6f, 0.3f, 0.3f);
            break;
        case 1:
            this->color = Vector3(0.3f, 0.6f, 0.7f);
            break;
        case 2:
            this->color = Vector3(0.8f, 0.3f, 0.5f);
            break;
    }

    this->phase = 0.0f;
    this->speed = Math::randBetween(0.002f, 0.01f);

 }

void RihmaOlio::update(float pos)
{
    this->t = powf(sinf(Math::calcPosFloat(pos, this->st, this->et)*0.5f*3.141592f), 0.5f);
    this->t2 = powf(sinf(Math::calcPosFloat(pos, this->st2, this->et2)*0.5f*3.141592f), 0.5f);
    if (this->t > 0.0001f)
    {
        this->phase += this->speed;
    }
}

void RihmaOlio::draw(float pos, float alpha)
{
    if (this->t > 0.0001f)
    {
        const int strips = 50;
        glBegin(GL_LINE_STRIP);

        for (float u = 0; u < this->t; u += 1.0f / strips)
        {
            glColor4f(this->color.x, this->color.y, this->color.z, alpha * u * 0.5f);
            Vector3 v = this->path->getValue(u);
            glVertex3fv((float *)&v);
            this->valoPosition = v;
        }
        glEnd();

    }
}

void RihmaOlio::draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha)
{
    if (this->t > 0.0001f)
    {
        drawValo(this->valoPosition, xr, yr, zr, 0.15f * this->t * (0.5f+0.5f*sinf(this->phase * 2)), alpha*1.0f * this->t * (0.7f + 0.3f*sinf(this->phase)));
    }
}

void RihmaOlio::draw3(Vector3 &xr, Vector3 &yr, Vector3 &zr, float pos, float alpha)
{
    if (this->t2 > 0.0001f)
    {
        const int flarecount = 10;
        for (int i = 0; i < flarecount; i++)
        {
            float u = i / (float)flarecount;

            Vector3 position = this->path->getValue(u);
            drawValo(position, xr, yr, zr, 
                     0.10f * this->t2 * (0.5f+0.5f*sinf(this->phase * 2 + u*4)), 
                     alpha*0.6f * this->t2 * (0.7f + 0.3f*sinf(this->phase + u*6)));
        }
    }
}


void RihmaOlio::drawValo(Vector3 &pos, Vector3 &xr, Vector3 &yr, Vector3 &zr, float size, float alpha)
{
	Vector3 xr1 = xr * size;
	Vector3 yr1 = yr * size;

	Vector3 v1 = pos - xr1 - yr1;
	Vector3 v2 = pos + xr1 - yr1;
    Vector3 v3 = pos + xr1 + yr1;
    Vector3 v4 = pos - xr1 + yr1;

    /*
	Vector3 v1 = pos + xr * -size + yr * -size;
    Vector3 v2 = pos + xr *  size + yr * -size;
    Vector3 v3 = pos + xr *  size + yr *  size;
    Vector3 v4 = pos + xr * -size + yr *  size;
	*/
    glColor4f(1,1,1, alpha);
    glTexCoord2f(0, 0);
    glVertex3fv((float *)&v1);
    glTexCoord2f(1, 0);
    glVertex3fv((float *)&v2);
    glTexCoord2f(1, 1);
    glVertex3fv((float *)&v3);
    glTexCoord2f(0, 1);
    glVertex3fv((float *)&v4);
}

/////////////////////////////////////////////////////////////////////////////
///                          Kimalteet
/////////////////////////////////////////////////////////////////////////////

/*
class Kimalle
{
public:
    Kimalle();
    ~Kimalle();

    void init();
    void update();
    void draw1(float alpha);
    void draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float alpha);

private:
    float st, et;
    float phase;
    float speed;

    CatmullRom *path;
    float glow;
    float glowspeed;

};
*/

Kimalle::Kimalle()
{
}

Kimalle::~Kimalle()
{
}

void Kimalle::init()
{
    int i = 0;

    float a = Math::randFloat()*2*3.141592f;
    float r = Math::randFloat()*5;// * powf(Math::randFloat(), 1.3f);
    Vector3 p = Vector3(sinf(a), 0, cosf(a)) * r;
    this->path = new CatmullRom();
    this->path->startCreation();

    const float minspeed = 0.003f;
    const float maxspeed = 0.0067f;
    this->phase = Math::randFloat();
    this->speed = Math::randBetween(minspeed, maxspeed) * powf(Math::randFloat(), 2.0f);
    this->glow = Math::randFloat();
    this->glowspeed = Math::randBetween(0.005f, 0.02f);
    this->basefade = Math::randBetween(0.5f, 0.8f);
    const float twisting = Math::randBetween(15, 35) * powf(Math::randFloat(), 1.2f);
	const float twistingradius = Math::randBetween(0.2f, 2.9f) * powf(Math::randFloat(), 1.3f);
    const float spe = this->speed / maxspeed;
    const int points = 25;
	
    for (i = 0; i < points; i++)
    {
        float it = i / (float)points;

        const float ir = min(it*3, 1);
        float a2 = it * twisting;
        Vector3 ring = Vector3(sinf(a2), 0, cosf(a2)) * twistingradius * ir;
        Vector3 delta = Math::randVectSphere()*Math::randFloat()*0.3f*powf(spe, 1.5f);

		this->path->addPoint(p + ring + delta);
        p.y += Math::randBetween(0.4f, 0.6f);
    }
    this->path->endCreation();


    this->st = Math::randBetween(0.49f, 0.85f);
    this->et = this->st + Math::randBetween(0.04f, 0.07f);
    
}

void Kimalle::update(float pos)
{
    this->glow += this->glowspeed;
    this->phase += this->speed;

    this->phase = fmodf(this->phase, 1);
    this->self_t = Math::calcPosFloat(pos, this->st, this->et);
    this->fade = min(1, 4*sinf(this->phase*3.141592f)) * this->self_t * this->basefade;
}

void Kimalle::draw1(float alpha)
{
    if (this->self_t > 0.0001f)
    {
        float t1 = this->phase;
        float t2 = this->phase + 0.01f;

        t2 = min(t2, 1);

        Vector3 p1 = this->path->getValue(t1);
        Vector3 p2 = this->path->getValue(t2);
        glColor4f(1,1,1,alpha*this->fade*0.3f);
        glVertex3fv((float *)&p1);
        glVertex3fv((float *)&p2);
    }
}

void Kimalle::draw2(Vector3 &xr, Vector3 &yr, Vector3 &zr, float alpha)
{
    if (this->self_t > 0.0001f)
    {
        Vector3 p = this->path->getValue(this->phase);
        float g = sinf(this->glow*2*3.141592f);
        const float cutoff = 0.6f;
        if (g > cutoff)
        {
            const float smod = Math::calcPosFloat(g, cutoff, 1.0f)*this->fade;

            const float size = 0.40f*smod;
            glColor4f(1,1,1,alpha*smod*0.60f);

            Vector3 v1 = p - xr * size - yr * size;
            Vector3 v2 = p + xr * size - yr * size;
            Vector3 v3 = p + xr * size + yr * size;
            Vector3 v4 = p - xr * size + yr * size;

            glTexCoord2f(0, 0);
            glVertex3fv((float *)&v1);
            glTexCoord2f(1, 0);
            glVertex3fv((float *)&v2);
            glTexCoord2f(1, 1);
            glVertex3fv((float *)&v3);
            glTexCoord2f(0, 1);
            glVertex3fv((float *)&v4);
        }
    }
}

/////////////////////////////////////////////////////////////////////////////
///                          LiikkuvaOlio
/////////////////////////////////////////////////////////////////////////////


void LiikkuvaOlio::init()
{
    const float xdim = 15.0f;
    const float ydim = 5.0f;
    const float zdim = 15.0f;

    Vector3 initialPos = Vector3(Math::randBetween(-xdim, xdim), 
                                 Math::randBetween(0, ydim),
                                 Math::randBetween(-zdim, zdim));
    
    this->movement.setUseBounds(true);
    this->movement.setPosition(initialPos);
    this->movement.setDirection(Math::randBetween(0, 2*3.141592f), Math::randBetween(0, 2*3.141592f));
    this->movement.setBoundLimits(-xdim, xdim, 0, ydim, -zdim, zdim);
    this->movement.setTurning(0, 0);
    this->movement.setSpeed(Math::randBetween(0.001f, 0.005f));

    this->color = Vector3(0.3f, 0.3f, Math::randBetween(0.4f, 0.7f));
    this->phase = Math::randFloat();
    this->phasespeed = Math::randBetween(0.01f, 0.02f);
}

void LiikkuvaOlio::turn()
{
}

void LiikkuvaOlio::draw(float alpha, float ymove)
{
    glColor4f(this->color.x, this->color.y, this->color.z, alpha * (0.6f + 0.4f * sinf(this->phase)));
    Vector3 p = this->movement.getPosition();
	if(fabs(ymove) > 0.001f)
	{
		p.y *= ymove;	
	}
    Vector3 v1 = p + Vector3(-0.03f, 0, 0);
    Vector3 v2 = p + Vector3(0.03f, 0, 0);

    glVertex3fv((float *)&v1);
    glVertex3fv((float *)&v2);
}

void LiikkuvaOlio::update()
{
    this->movement.update();
    if (Math::randFloat() < 0.01f)
    {
        this->movement.selectNewDirection();
    }

    this->phase += this->phasespeed;
}

/////////////////////////////////////////////////////////////////////////////
///                             efekti
/////////////////////////////////////////////////////////////////////////////

void Oliot::renderGeometry(float pos, float alpha)
{
    int i = 0;
	this->merenpohja->renderWithNormalMaps(dmsGetTexture("deeptxt2.jpg"), dmsGetTexture("normal_map_deep2.jpg"), Vector3(1,1,1), alpha*0.3f);

    //taustarihmat
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_LINE_SMOOTH);
    glDisable(GL_DEPTH_TEST);
    for (i = 0; i < this->rihmacount; i++)
    {
        this->rihmat[i].draw(dmsGetModulePosition(), alpha);
    }
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_turq.jpg")->getID());

    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);
    glDisable(GL_DEPTH_TEST);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glDepthMask(0);
    glBegin(GL_QUADS);

    for (i = 0; i < this->rihmacount; i++)
    {
        this->rihmat[i].draw2(xr, yr, zr, dmsGetModulePosition(), alpha);
    }
    glEnd();
    glDepthMask(1);
    glEnable(GL_DEPTH_TEST );

    //kampaotukset
    glLineWidth(2.0f);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    //glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    for (i = 0; i < this->kampacount; i++)
    {
        this->kammat[i].draw(alpha);
    }

}


void Oliot::renderScene(float pos, float alpha)
{
    int i = 0;
    vector<Kimalle>::iterator it;
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (i = 0; i < this->kampacount; i++)
        {
            this->kammat[i].update();
        }
        for (i = 0; i < this->rihmacount; i++)
        {
            this->rihmat[i].update(dmsGetModulePosition());
        }
        for (i = 0; i < liikkuvacount; i++)
        {
            liikkuvat[i].update();
        }
        for (it = this->kimalteet.begin(); it < this->kimalteet.end(); it++)
        {
            (*it).update(pos);
        }

        this->frametimer->endStep();
    }
 
    glLoadIdentity();
    //cubemapit
/*
    Vector3 objectposition = Vector3(0, 4.5f, 0);
    glTranslatef(objectposition.x, objectposition.y, objectposition.z);

    this->cubemap->startRendering();
    for (i = 0; i < 6; i++)
    {
        int side = i;
        this->cubemap->setupRenderSide(side);
        this->renderGeometry(pos, alpha);
        this->cubemap->finishRenderSide(side);
    }
    this->cubemap->endRendering();
*/
    glLoadIdentity();
    cameras->useCamera(2);


	float merenpohjaalpha = alpha * 0.35;
	merenpohjaalpha = merenpohjaalpha - 0.25f * (powf(Math::calcPosFloat(dmsGetModulePosition(), 191580, 195580), 3)); 
	merenpohjaalpha = Math::clampVal(merenpohjaalpha, 0, 1);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    //this->merenpohja->render(dmsGetTexture("deeptxt2.jpg"), alpha*0.2f);
	this->merenpohja->renderWithNormalMaps(dmsGetTexture("deeptxt2.jpg"), dmsGetTexture("normal_map_deep2.jpg"), Vector3(1,1,1), merenpohjaalpha);


	glDisable(GL_BLEND);

/*
    //meshi
    float a1, a2, a3, a4, b1, b2, b3, b4, c1, c2, c3, c4, d1, d2, d3, d4;
	float matriisi[16];
	glGetFloatv(GL_MODELVIEW_MATRIX, matriisi);	

	// Transponoidaan pyritysosa == inverse matriisi
	a1 = matriisi[ 0];
	a2 = matriisi[ 1];
	a3 = matriisi[ 2];
	a4 = matriisi[ 3];
	b1 = matriisi[ 4];
	b2 = matriisi[ 5];
	b3 = matriisi[ 6];
	b4 = matriisi[ 7];
	c1 = matriisi[ 8];
	c2 = matriisi[ 9];
	c3 = matriisi[10];
	c4 = matriisi[11];
	d1 = matriisi[12];
	d2 = matriisi[13];
	d3 = matriisi[14];
	d4 = matriisi[15];

	matriisi[ 0] = a1;
	matriisi[ 1] = b1;
	matriisi[ 2] = c1;
	matriisi[ 3] = d1;
	matriisi[ 4] = a2;
	matriisi[ 5] = b2;
	matriisi[ 6] = c2;
	matriisi[ 7] = d2;
	matriisi[ 8] = a3;
	matriisi[ 9] = b3;
	matriisi[10] = c3;
	matriisi[11] = d3;
	matriisi[12] = a4;
	matriisi[13] = b4;
	matriisi[14] = c4;
	matriisi[15] = d4;
  
    const float valospeed = 3.0f;
    Vector3 valopos = Vector3(cosf(pos*11*valospeed) - sinf(pos*17*valospeed)*0.5f, 
                              cosf(pos*9*valospeed) * 1.2f,
                              0.7f + cosf(pos*21*valospeed)) * 10;

    float ambient[]= { 1,1,1, 1.0f};
	float diffuse[]={1.0f, 1.0f, 1.0f, 1.0f};
	float position[]={ valopos.x, valopos.y, valopos.z, 0.0f};
	float specular[]={1.0f, 1.0f, 1.0f, 1.0f};
	glLightfv(GL_LIGHT1, GL_AMBIENT, ambient);	
	glLightfv(GL_LIGHT1, GL_DIFFUSE, diffuse);		
	glLightfv(GL_LIGHT1, GL_POSITION, position);
	glLightfv(GL_LIGHT1, GL_SPECULAR, specular);
	
	glEnable(GL_LIGHT1);
    glEnable(GL_LIGHTING);

    glPushMatrix();

	glMatrixMode(GL_TEXTURE);
	glPushMatrix();	
	glLoadMatrixf(matriisi); //inverse matriisi teksturematrixiin niin saadaan pyritys
	glMatrixMode(GL_MODELVIEW);

    //objekti
	glDisable(GL_BLEND);
	glEnable(GL_TEXTURE_CUBE_MAP_EXT);
	glEnable(GL_NORMALIZE);
	glEnable(GL_CULL_FACE);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_TEXTURE_GEN_S); 
	glEnable(GL_TEXTURE_GEN_T); 
	glEnable(GL_TEXTURE_GEN_R);
	glEnable(GL_NORMALIZE);
	glEnable(GL_CULL_FACE);
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
    glDepthMask(1);

    glPushMatrix();
    glTranslatef(objectposition.x, objectposition.y, objectposition.z);
    glRotatef(pos*400, 0.4f+cosf(pos*11), 1.0f-pos*1.2f, pos*0.7f - sinf(pos*11));
    this->mesh->renderVBO(MESH_VERTEX_BIT | MESH_NORMAL_BIT);
    glPopMatrix();

	glMatrixMode(GL_TEXTURE);
	glPopMatrix();

	glMatrixMode(GL_MODELVIEW);
    glPopMatrix();

    glDisable(GL_LIGHTING);
    glDisable(GL_LIGHT0);

    glDisable(GL_TEXTURE_CUBE_MAP_EXT);
	glDisable(GL_TEXTURE_GEN_S); 
	glDisable(GL_TEXTURE_GEN_T); 
	glDisable(GL_TEXTURE_GEN_R);
	glDisable(GL_NORMALIZE);
	glDisable(GL_CULL_FACE);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_TEXTURE_2D);
*/


    //kampaotukset
    glLineWidth(2.0f);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    filter.init();
    for (i = 0; i < this->kampacount; i++)
    {
        this->kammat[i].draw(alpha);
    }

    //pienet jutut
    glPointSize(3.0f);
    glDisable(GL_TEXTURE_2D);
    glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
    glEnable(GL_POINT_SMOOTH);
    glBegin(GL_POINTS);

	if(dmsGetModulePosition() < 193580)
	{
		float liikkuvaalpha = alpha * (1 - powf(Math::calcPosFloat(dmsGetModulePosition(),191580, 193580), 2)); 
		for (i = 0; i < liikkuvacount; i++)
		{
	        liikkuvat[i].draw(liikkuvaalpha);
	    }
	}
    glEnd();
    glDisable(GL_POINT_SMOOTH);


    glDepthMask(0);
    glColor4f(1,1,1,1);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
#ifdef RALEN_SAADOT
	glLineWidth(1);
#endif
    glBegin(GL_LINES);
    for (it = this->kimalteet.begin(); it < this->kimalteet.end(); it++)
    {
        (*it).draw1(alpha);
    }
    glEnd();

    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);


    glDepthMask(1);


    //taustarihmat
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_LINE_SMOOTH);
    glEnable(GL_DEPTH_TEST);
    glDepthMask(0);
    for (i = 0; i < this->rihmacount; i++)
    {
        this->rihmat[i].draw(dmsGetModulePosition(), alpha);
    }
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_turq.jpg")->getID());

    glBlendFunc(GL_SRC_ALPHA, GL_ONE);

    glDepthMask(0);
    glBegin(GL_QUADS);

    for (i = 0; i < this->rihmacount; i++)
    {
        this->rihmat[i].draw2(xr, yr, zr, dmsGetModulePosition(), alpha);
    }
    glEnd();

    glDepthMask(1);
    glEnable(GL_DEPTH_TEST );


    glDisable(GL_LINE_SMOOTH);
    filter.glow(6, 0.007f, 0.007f, 0.91f, -1.0f, 1.0f);

    glDepthMask(0);
    glColor4f(1,1,1,1);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_BLEND);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, dmsGetTexture("flare_white.jpg")->getID());
    glBegin(GL_QUADS);

    for (it = this->kimalteet.begin(); it < this->kimalteet.end(); it++)
    {
        (*it).draw2(xr, yr, zr, alpha);
    }
    glEnd();
    glDepthMask(1);

    
    
    glDisable(GL_BLEND);
    filter.drawNoiseOverlay(alpha * 0.05f);

}




Oliot::Oliot()
{
    int i = 0;
    const int groundX = 50;
    const int groundY = 50;
    const float size2 = 15.0f;
    this->merenpohja = new GroundPlane(groundX, groundY, size2, 4.0f);
    this->merenpohja->makeCircularFade(1.0f, 1.0f);

    this->cubemap = new Cubemap();
    this->cubemap->setupDynamic(512);

    this->mesh = TMeshFactory::createTorus(3, 1.5f, 64, 64, 1.0f);//importT3D("ball.t3d");
    this->mesh->scale(2.5f);
    this->mesh->createVBO(MESH_VERTEX_BIT | MESH_NORMAL_BIT);
//    this->mesh->flipNormals();
    this->frametimer = new FrameTimer(1000 / 60, 5);

    this->kampacount = 150;
    this->kammat = new KampaOlio[this->kampacount];

    srand(61061);
    for (i = 0; i < this->kampacount; i++)
    {
        this->kammat[i].init();
    }

    this->rihmacount = 200;
    this->rihmat = new RihmaOlio[this->rihmacount];

    srand(5110);
    for (i = 0; i < this->rihmacount; i++)
    {   
        this->rihmat[i].init();
    }

    liikkuvacount = 400;
    liikkuvat = new LiikkuvaOlio[liikkuvacount];

    srand(51);
    for (i = 0; i < liikkuvacount; i++)
    {   
        liikkuvat[i].init();
    }

    srand(1961);

#ifdef RALEN_SAADOT
    for (i = 0; i < 500; i++)
#else
	for (i = 0; i < 800; i++)
#endif
    {
        Kimalle k;
        k.init();
        this->kimalteet.push_back(k);
    }

}

Oliot::~Oliot()
{
}


bool Oliot::init(unsigned long s, unsigned long e)
{


	startTime = s;
	endTime = e;
	return true;
}

