//#define NOT_FINAL_MEDUSA 
#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Meduusa.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"
#include <list>
#include "alkuotukset.h"

const int JELLYT_ILMESTYY = 100000;

extern void setClearColor(Vector3 color);
extern std::vector<Alkuotus> ropeotukset;
extern bool alkuotuksetResetCamera;

void Meduusa::draw()
{
	setClearColor(Vector3(-1, 0, 0));
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.07f;
	const float fadeoutstart = 0.99f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

	alkuotuksetResetCamera = false;

	renderScene(pos, alpha);
}


inline Vector3 tentacleTurbulence1(Vector3 &pos, float time)
{
    const float speed = 0.1f;
    const float thickness = 0.3f;
    float x = 0.3f*sinf(pos.x * 5 * thickness + pos.y * 8 * thickness + time * 4 * speed);
    float y = -0.2f * (0.5f + 0.5f*sinf(pos.y * 4 * thickness + pos.z * 6 * thickness + time * 5.4f * speed));
    float z = 1.0f*sinf(pos.z * 7 * thickness + pos.x * 2 * thickness + time * 5 * speed);

    return Vector3(x, y, z);
}
inline Vector3 tentacleTurbulence2(Vector3 &pos, float time)
{
    const float speed = 0.1f;
    const float thickness = 0.3f;
    float x = 0.6f*sinf(pos.x * 6 * thickness + pos.y * 3 * thickness + time * 9 * speed);
    float y = -0.3f * (0.5f + 0.5f*sinf(pos.y * 6 * thickness + pos.z * 7 * thickness + time * 3.4f * speed));
    float z = 0.4f*sinf(pos.z * 5 * thickness + pos.x * 6 * thickness + time * 3 * speed);

    return Vector3(x, y, z);
}
inline Vector3 tentacleTurbulence3(Vector3 &pos, float time)
{
    const float speed = 0.15f;
    const float thickness = 0.35f;
    float x = 0.2f*sinf(pos.x * 6 * thickness + pos.y * 3 * thickness + time * 9 * speed);
    float y = -0.15f * (0.5f + 0.5f*sinf(pos.y * 6 * thickness + pos.z * 7 * thickness + time * 3.4f * speed));
    float z = 0.8f*sinf(pos.z * 5 * thickness + pos.x * 6 * thickness + time * 3 * speed);

    return Vector3(x, y, z);
}
inline Vector3 tentacleTurbulence4(Vector3 &pos, float time)
{
    const float speed = 0.13f;
    const float thickness = 0.4f;
    float x = 0.3f*sinf(pos.x * 5 * thickness + pos.y * 5 * thickness + time * 3 * speed);
    float y = -0.6f * (0.5f + 0.5f*sinf(pos.y * 6 * thickness + pos.z * 7 * thickness + time * 3.4f * speed));
    float z = 0.5f*sinf(pos.z * 7 * thickness + pos.x * 4 * thickness + time * 6 * speed);

    return Vector3(x, y, z);
}



/////////////////////////////////////////////////// MEDUUSAT ///////////////////////////////////////////////////////////

Tentacle::Tentacle()
{
}

Tentacle::~Tentacle()
{
}

void Tentacle::init(Vector3 &startpos)
{
    int tentaclevertices = 11 + rand()%6;
    this->spline = new CatmullRom();
    this->spline->startCreation();

    this->function = rand()%4;

    Vector3 p = startpos + Math::randVectSphere()*Math::randFloat()*1.3f ;
    Vector3 direction = Vector3(0, -1, 0) * 0.2f;

    for (int i = 0; i < tentaclevertices; i++)
    {
        this->spline->addPoint(p);
        p+= direction;
        direction += Math::randVectSphere() * 0.1f;
        if (direction.y > -0.1f)
        {
            direction.y = -0.1f;
        }
    }

    this->phase = Math::randFloat();

    this->spline->endCreation();
//    this->spline->arcLengthParametrize();

}
void Tentacle::free()
{
}


void Tentacle::update(float time)
{
    int i = 0;
    int count = this->spline->getPointCount();
    Vector3 *points = this->spline->getPoints();

    Vector3 centerpos = Vector3(0, 0, 0);
    Vector3 centerposnew = Vector3(0, 0, 0);

    Vector3 (*turbulence)(Vector3&, float) = NULL;

    switch(this->function)
    {
        case 0:
            turbulence = tentacleTurbulence1;
            break;
        case 1:
            turbulence = tentacleTurbulence2;
            break;
        case 2:
            turbulence = tentacleTurbulence3;
            break;
        case 3:
            turbulence = tentacleTurbulence4;
            break;

    };


    //liike
    for (i = 1; i < count; i++)
    {
        const float t = i * 0.2f;
        const float multiplier = (t > 1.0f ? 1.0f : t) * 0.006f;

        centerpos += points[i];
        points[i] += turbulence(points[i], time) * multiplier * t;
    }
    
    //rajoite
    for (i = 0; i < count - 1; i++)
    {
        //oletetaan, ett points[i] on kohdallaan. Eka verteksi ei liiku mik on hyv

        Vector3 &p1 = points[i];
        Vector3 &p2 = points[i+1];

        float dx = p2.x - p1.x;
        float dy = p2.y - p1.y;
        float dz = p2.z - p1.z;

        const float maxd = 0.325f;
        const float mind = 0.10f;

        float dist2 = dx*dx + dy*dy + dz*dz;
        const float maxdist2 = (maxd * maxd);
        const float mindist2 = (mind * mind);

        const float maxmovement = 0.1f;
        //liian etll toisistaan
        if (dist2 > maxdist2)
        {
            float force = (dist2 - maxdist2);
            Vector3 direction = p1 - p2; //kohti alkuperist
            p2 += direction * force * maxmovement;
        } //liian lhell toisiaan
        else if (dist2 < mindist2)
        {
            float force = mindist2 - dist2;//(dist2 - maxdist2);
            Vector3 direction = p2 - p1; //kohti alkuperist
            p2 += direction * force * maxmovement;
        }
    }
    for (i = 0; i < count; i++)
    {
        centerposnew += points[i];
    }

    centerpos *= 1.0f / count;
    centerposnew *= 1.0f / count;

    Vector3 delta = centerposnew - centerpos;

    for (i = 0; i < count; i++)
    {
        points[i] -= delta;
    }
}

void Tentacle::draw(float time, Vector3 &color, float alpha)
{
    int i = 0;
    const int strips = 30;
    glPushMatrix();
    glTranslatef(0, 0.5f, 0);

    glBegin(GL_LINE_STRIP);
    for (i = 0; i < strips; i++)
    {
        const float t = i / (float)strips;
        float temp = t*8;
        const float alkufade = temp > 1.0f ? 1.0f : temp;

        const float a = (0.5f + 0.5f * sinf(t * 3 - time * 0.4f + this->phase * 2*3.141592f))*alkufade;

        Vector3 p = this->spline->getValue(t);
        glColor4f(color.x, color.y, color.z, alpha*a);
        glVertex3fv((float *)&p);
    }
    glEnd();
    glPopMatrix();
}


Jellyfish::Jellyfish()
{
}

Jellyfish::~Jellyfish()
{
}
void Jellyfish::init(bool first, Vector3 &startpos)
{
    int i = 0;
    const int JELLYFISH_START = JELLYT_ILMESTYY;
    const int JELLYFISH_END   = 116000;

    this->position = startpos;
    this->appear = 0.0f;
    this->st = 1.0f * JELLYFISH_START + (rand() % (JELLYFISH_END - JELLYFISH_START));
    if (first)
        this->st = JELLYFISH_START;
    this->et = this->st + 4000.0f;

    this->special = Math::randFloat() > 0.75f;

    switch(rand()%4)
    {
        case 0: //turkoosi
        case 1:
            this->color = Vector3(0.9f, 0.7f, 0.4f);
            this->color2 = Vector3(0.9f, 0.7f, 0.4f);
            break;
        case 2:
            this->color = Vector3(0.4f, 0.7f, 0.9f);
            this->color2 = Vector3(0.4f, 0.7f, 0.9f);
            break;
        case 3: 
            this->color = Vector3(0.4f, 0.7f, 0.9f);
            this->color2 = Vector3(0.6f, 0.3f, 0.3f);
            break;
    }

    switch(rand()%4)
    {
        case 0: //turkoosi
        case 1:
            this->color3 = Vector3(0.9f, 0.7f, 0.4f);
            this->color4 = Vector3(0.9f, 0.7f, 0.4f);
            break;
        case 2:
            this->color3 = Vector3(0.4f, 0.7f, 0.9f);
            this->color4 = Vector3(0.4f, 0.7f, 0.9f);
            break;
        case 3: 
            this->color3 = Vector3(0.4f, 0.7f, 0.9f);
            this->color4 = Vector3(0.6f, 0.3f, 0.3f);
            break;
    }

    this->size = Math::randBetween(0.4f, 0.8f);

    if (Math::randFloat() < 0.25f)
    {
        this->size *= 0.5f;

    }

    this->stripcount = 16;
    this->pointcount = 30;
    this->points = new Vector3*[this->stripcount];
    this->texcoords = new Vector3*[this->stripcount];
    this->alareuna = new Vector3[this->stripcount];

    for (i = 0; i < this->stripcount; i++)
    {
        this->points[i] = new Vector3[this->pointcount];
        this->texcoords[i] = new Vector3[this->pointcount];
        this->alareuna[i] = Math::randVectSphere() * 0.04f;
    }


    this->phase = Math::randFloat();
    this->speed = Math::randBetween(0.03f, 0.1f);
    this->time = 0.0f;

    const float vino = 0.075f;
    this->a = Math::randBetween(-vino, vino); 
    this->b = Math::randBetween(-vino, vino) * 0.5f;

    this->velocity = Math::randVectSphere();

    int tentaclecount = 15 + rand()%10;
    for (i = 0; i < tentaclecount; i++)
    {
        Vector3 tentaclepos = Vector3(0, 0.5f, 0) + Math::randVectSphere() * 0.1f;//Vector3(0, 0, 0);
        Tentacle t;
        t.init(tentaclepos);
        this->tentacles.push_back(t);
    }
}

void Jellyfish::draw(float alpha, float pos, float colorsync)
{
    int i = 0, j = 0;
    if (this->appear < 0.00001f)
        return;

    glPushMatrix();
    glTranslatef(this->position.x, this->position.y, this->position.z);
    glScalef(this->size, this->size, this->size);
    glRotatef(360 * this->orientation.x, 1, 0, 0);
    glRotatef(360 * this->orientation.y, 0, 1, 0);
    glRotatef(360 * this->orientation.z, 0, 0, 1);

    float fade = this->appear * alpha;

    glEnable(GL_TEXTURE_2D);

    float texturefade = 0.0f;
	// Haetaan vastaava tekstuuri
    if (this->special)
    {
        // Caustic numero
        int n = int(pos*32*20*1.5f)%32 + 1;
	
	    char buf[75];
	    sprintf(buf, "cau_0%02d.jpg", n);
	    Texture *texture = dmsGetTexture(buf);
        glBindTexture(GL_TEXTURE_2D, texture->getID());
        texturefade = 1.4f;
    }
    else
    {
        glBindTexture(GL_TEXTURE_2D, dmsGetTexture("deeptxt2.jpg")->getID());
        texturefade = 0.5f;
    }

    texturefade *= (0.7f + 0.3f * sinf(this->time+this->phase*3.141592f*2));
    const int layers = 5;

    Vector3 col = this->color * (1 - colorsync) + this->color3 * colorsync;
    glColor4f(col.x, col.y, col.z, fade*texturefade*(1.0f / layers));

    for (int k = 0; k < layers; k++)
    {
        const float kt = k / (float)layers;
        const float s = 1.0f - kt * 0.3f;
        glPushMatrix();
        glScalef(s, s, s);
        for (j = 0; j < this->stripcount; j++)
        {
            glBegin(GL_TRIANGLE_STRIP);
            for (i = 0; i < this->pointcount; i++)
            {
                glTexCoord2fv((float *)&this->texcoords[j][i]);
                glVertex3fv((float *)&this->points[j][i]);
                glTexCoord2fv((float *)&this->texcoords[(j+1) % this->stripcount][i]);
                glVertex3fv((float *)&this->points[(j+1) % this->stripcount][i]);
            }
            glEnd();
        }
        glPopMatrix();
    }
    glDisable(GL_TEXTURE_2D);
    glPopMatrix();
    
}


void Jellyfish::drawGlowyBits(float alpha, float colorsync)
{
    int i = 0, j = 0;
    if (this->appear < 0.00001f)
        return;

    glPushMatrix();
    glTranslatef(this->position.x, this->position.y, this->position.z);
    glScalef(this->size, this->size, this->size);
    glRotatef(360 * this->orientation.x, 1, 0, 0);
    glRotatef(360 * this->orientation.y, 0, 1, 0);
    glRotatef(360 * this->orientation.z, 0, 0, 1);

    float fade = this->appear * alpha;

    Vector3 col = this->color2 * (1 - colorsync) + this->color4 * colorsync;
    glColor4f(col.x, col.y, col.z, fade*0.4f);
//    glColor4f(this->color2.x, this->color2.y, this->color2.z, fade*0.4f);

    //"selkranka"
    glLineWidth(2.0f);
    for (j = 0; j < this->stripcount; j++)
    {
        glBegin(GL_LINE_STRIP);
        for (i = 0; i < this->pointcount; i++)
        { 
            float f = i / (float)this->pointcount;
            glColor4f(col.x, col.y, col.z, fade*0.4f*(1-f));
            glVertex3fv((float *)&this->points[j][i]);
        }
        glEnd();
    }
    glColor4f(col.x, col.y, col.z, fade*0.4f);

    //pohjarengas
    glBegin(GL_LINE_LOOP);
    for (j = 0; j < stripcount; j++)
    {
        glVertex3fv((float *)&this->points[j][this->pointcount - 1]);
    }
    glEnd();

    //lonkerot
    std::vector<Tentacle>::iterator it;

    glLineWidth(2.0f);
    for (it = this->tentacles.begin(); it != this->tentacles.end(); it++)
    {
        (*it).draw(this->time, col, fade);
    }

    glPopMatrix();
    
}

void Jellyfish::update(int currentTime)
{
    int i = 0;

    this->appear = Math::calcPosFloat(currentTime * 1.0f, this->st, this->et);
    if (this->appear < 0.00001f)
        return;

    this->time += this->speed;

    this->orientation = Math::sphereToCartesian(1, this->b, this->a );
    this->position += this->velocity * 0.001f;
//    this->position += this->orientation * 0.01f;


//    for (i = 0; i < this->stripcount; i++)
//    {
//        this->alareuna[i] = Math::randVectSphere() * 0.1f;
//    }

    for (int j = 0; j < this->stripcount; j++)
    {
        float jt = j / (float)this->stripcount; 

        Matrix rot;
        rot.makeRotation(0, jt * 2 * 3.141592f, 0);

        const float height = 1.0f + 0.2f*sinf(this->time * 0.3f);
        const float heightmod = 0.12f*(0.75f+0.25f*sinf(jt*11 + this->time * 0.7f));

        for (i = 0; i < this->pointcount; i++)
        {
            //t kasvaa alaspin
            float t = i / (float)this->pointcount;

            //y = [0, 1]
            float y = t;
            float s = 0.1f*(0.5f + 0.5f * sinf(this->time));

            float displace = 0.5f + 0.5f*sinf(t * 7 + this->time);

            float sisaanpain = (powf(t, 4))*0.3f;// * (0.5f + 0.5f * sinf(this->time*5));
            float x = powf(y, 0.5f - s) + 0.1f*displace*t - sisaanpain;

            this->points[j][i] = Vector3(x, (1 - y) * height, 0) * rot;
            this->texcoords[j][i] = Vector3(jt, t, 0);
            if (i == this->pointcount - 1)
            {
                this->points[j][i].y -= heightmod;
            }
        }
    }



    //lonkerot
    std::vector<Tentacle>::iterator it;

    for (it = this->tentacles.begin(); it != this->tentacles.end(); it++)
    {
        (*it).update(this->time);
    }

/*
    //pyrhdyskappale
    for (int j = 1; j < this->stripcount; j++)
    {
        float t = j / (float)this->stripcount;
        Matrix rot;
        rot.makeRotation(0, t*2*3.141592f, 0);

        for (int i = 0; i < this->pointcount; i++)
        {
            Vector3 delta = ((i == this->pointcount - 1) ? this->alareuna[j] : Vector3(0, 0, 0));
            this->points[j][i] = (this->points[0][i] + delta) * rot;
        }
    }
*/


}

/////////////////////////////////////////////////// PARTICLET ///////////////////////////////////////////////////////////

MedusaParticle::MedusaParticle()
{
}

MedusaParticle::~MedusaParticle()
{
}

void MedusaParticle::update()
{
    this->energy -= 0.001f;
    this->time += this->timespeed;


    Vector3 (*turbulence)(Vector3&, float) = NULL;

    switch(this->func)
    {
        case 0:
            turbulence = tentacleTurbulence1;
            break;
        case 1:
            turbulence = tentacleTurbulence2;
            break;
        case 2:
            turbulence = tentacleTurbulence3;
            break;
        case 3:
            turbulence = tentacleTurbulence4;
            break;

    };

    Vector3 dir = turbulence(this->pos, this->time);
    this->pos += dir * 0.01f;
    this->pos.y += 0.01f;
}

void MedusaParticle::draw(float alpha)
{
    //?
}
bool MedusaParticle::isDead()
{
    return energy < 0.0f;
}

MedusaEmitter::MedusaEmitter()
{
}

MedusaEmitter::~MedusaEmitter()
{
}

void MedusaEmitter::update()
{
    std::list<MedusaParticle>::iterator i;

    for (i = this->particles.begin(); i != this->particles.end(); )
    {
        MedusaParticle &p = *i;
        p.update();

        if (p.isDead())
        {
            i = this->particles.erase(i);
        }
        else
        {
            i++;
        }

    }
    if (Math::randFloat() > 0.5f)
    {
        MedusaParticle p;
        p.pos = this->pos;
        p.energy = Math::randBetween(0.7f, 1.3f);
        p.maxenergy = p.energy; 
        p.size = Math::randBetween(0.03f, 0.06f);
        p.time = 0.0f;
        p.func = rand()%4;
        p.timespeed = Math::randBetween(0.01f, 0.02f);
        this->particles.push_back(p);
    }
}

void MedusaEmitter::init()
{
    float a = Math::randBetween(0, 2*3.141592f);
    float r = 15 * Math::randFloat();
    float y = -Math::randBetween(5.0f, 10.0f);

    this->pos = Vector(cosf(a) * r, y, sinf(a) * r);
}
void MedusaEmitter::draw(float alpha)
{
    std::list<MedusaParticle>::iterator i;

    Vector3 xr, yr, zr;
    Math::antiRotate(&xr, &yr, &zr);

    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glDisable(GL_DEPTH_TEST);
    glDepthMask(0);

    glBindTexture(GL_TEXTURE_2D, this->texture->getID());//dmsGetTexture("bubble1.png")->getID());
    glBegin(GL_QUADS);

    Vector3 color = Vector3(1, 1, 1);
    for (i = this->particles.begin(); i != this->particles.end(); i++)
    {
        MedusaParticle &p = *i;
        float t = p.energy / p.maxenergy;
        const float size = p.size;
        const float fade = (1-powf(t, 15)) * 1.0f * t;

        Vector3 v1 = p.pos + xr * -size + yr * -size;
        Vector3 v2 = p.pos + xr *  size + yr * -size;
        Vector3 v3 = p.pos + xr *  size + yr *  size;
        Vector3 v4 = p.pos + xr * -size + yr *  size;

        glColor4f(color.x , color.y, color.z, alpha * fade);
        glTexCoord2f(0, 1);
        glVertex3fv((float *)&v1);
        glTexCoord2f(1, 1);
        glVertex3fv((float *)&v2);
        glTexCoord2f(1, 0);
        glVertex3fv((float *)&v3);
        glTexCoord2f(0, 0);
        glVertex3fv((float *)&v4);
    }
    glEnd();
    glDisable(GL_TEXTURE_2D);
    glDepthMask(1);
}


/////////////////////////////////////////////////// EFEKTI ///////////////////////////////////////////////////////////


template <class T>
float lerp(T a, T b, float t)
{
    return a + (b-a) * t;
}

void Meduusa::renderScene(float pos, float alpha)
{
    this->frametimer->update();

    int currentTime = dmsGetModulePosition();
    std::vector<Jellyfish>::iterator it;
    std::vector<MedusaEmitter>::iterator it2;

    Vector3 jellykeskus = Vector3(0, 0, 0);
    while (this->frametimer->stepsLeft())
    {
		static int id;
		// -
		if(id==0)
		{
			std::vector<Alkuotus>::iterator it;
			for (it = ropeotukset.begin(); it < ropeotukset.end(); it++)
			{
	            (*it).update();
			}
		}
		id++;
		if(id>3) id=0;
		// -

        for (it = this->meduusat.begin(); it != this->meduusat.end(); it++)
        {
            Jellyfish &m = *it;
            m.update(currentTime);
            jellykeskus += m.position;
        }

        for (it2 = this->emitterit.begin(); it2 != this->emitterit.end(); it2++)
        {
            MedusaEmitter &e = *it2;
            e.update();
            //horrible hack;
            e.init();
        }

        this->frametimer->endStep();
    }

    jellykeskus = jellykeskus * 1.0f / ((int)this->meduusat.size());

    static float anal_cum = 0.0f;
    float analval = 0.2f*anal->get();

    anal_cum = anal_cum * 0.8f + analval * 0.2f;
    analval = anal_cum;

    glLoadIdentity();
	Vector3 cam = campos->getValue(pos);
	Vector3 tgt = camtgt->getValue(pos);
	//tgt.y += sinf(Math::calcPosFloat(dmsGetModulePosition(), 114000, 124000)*3.14f)*38.0f*tool->getValue("slider2");
	Vector3 up = Vector3(0,1,0);

    gluLookAt(cam.x, cam.y, cam.z,
              tgt.x, tgt.y, tgt.z,
               up.x,  up.y,  up.z);


	int modtime = dmsGetModulePosition();
	if(modtime < JELLYT_ILMESTYY)
	{

		float a = 1.0f - Math::calcPosFloat(modtime, JELLYT_ILMESTYY-1500, JELLYT_ILMESTYY);
		a *= alpha * 0.5f;
		glPointSize(3.0f);
		glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
		glEnable(GL_POINT_SMOOTH);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);

		glDisable(GL_TEXTURE_2D);
		glBegin(GL_POINTS);
		std::vector<Alkuotus>::iterator it;
		for (it = ropeotukset.begin(); it < ropeotukset.end(); it++)
		{
			(*it).drawLine(a);
		}
		glEnd();
		glDisable(GL_POINT_SMOOTH);
		glDisable(GL_LINE_SMOOTH);

	}
// ---




    const float viewdist = 7.0f;
    const float foglength = 3.0f;

    const float medusaTrigu = medusatrigut->get(dmsGetModulePosition());
    static int indeksi = 0;
    if (medusatrigut->getChanged())
    {
        indeksi = rand() % (int)this->meduusat.size();
    }

    glDisable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_LINE_SMOOTH);
    glHint(GL_LINE_SMOOTH_HINT, GL_NICEST);
    glDisable(GL_DEPTH_TEST);

    const float jellycolorsync = Math::calcPosFloat(dmsGetModulePosition(), 133500.0f, 134000.0f);

    int iter = 0;
    for (it = this->meduusat.begin(); it != this->meduusat.end(); it++)
    {
        Jellyfish &m = *it;
//        float proportion = (iter == indeksi) ? 0.7f : 0.2f;
//        m.draw(alpha*(1-proportion) - medusaTrigu*proportion, pos);
        m.draw(alpha, pos, jellycolorsync);
        iter++;
    }

    for (it2 = this->emitterit.begin(); it2 != this->emitterit.end(); it2++)
    {
        MedusaEmitter &e = *it2;
        e.draw(alpha*(0.5f+0.5f*analval));
    }


    filter.init();
    for (it = this->meduusat.begin(); it != this->meduusat.end(); it++)
    {
        Jellyfish &m = *it;
        m.drawGlowyBits(alpha, jellycolorsync);
    }

    glDisable(GL_LINE_SMOOTH);
	float glowAmount = 0.91f;


	glowAmount -= (sinf(3.14f*medusaTrigu))*0.005f;
    filter.glow(6, 0.007f, 0.007f, glowAmount, -1.0f, 1.0f);
	
	glDisable(GL_DEPTH_TEST);
	glDepthMask(0);

	const int PARTICLET_IN = JELLYT_ILMESTYY-250.0f;
	const int PARTICLET_OUT = JELLYT_ILMESTYY + 1500;
	if(currentTime < PARTICLET_OUT)
	{
		Vector3 xr, yr, zr;
		Math::antiRotate(&xr, &yr, &zr);

		//float syncbig = sinf(3.14f*trigut2->get(currentTime));
		float sync = trigut->get(currentTime);
		float sync2 = sync*sync;
		float size = 0.065f + 0.06f * sync;// + syncbig * tool->getValue("slider2");
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, dmsGetTexture("plank_shell.jpg")->getID());
		Vector3 p;

		float fadeshell = 1.0f-Math::calcPosFloat(currentTime, PARTICLET_IN, PARTICLET_OUT);
		fadeshell *= powf(Math::calcPosFloat(pos, 0, 0.005f),3);
		glColor4f(0.3f*fadeshell, 0.6f*fadeshell, 0.7f*fadeshell, 1.0f);
		glEnable(GL_BLEND);
		glBlendFunc(GL_ONE, GL_ONE);

        Shader *sindist = shaders->getShader("sindistort");
		Shader *blur = shaders->getShader("blur2y");
		
		if(currentTime > 97500)
		{
			size +=  sinf(3.1415926f*sync) * 0.079f;//tool->getValue("slider2");
			sindist->bind();
			int num = trigut->getLastNumber();
			glUniform1fARB(glGetUniformLocationARB(sindist->program, "xfreq"), 3.0f*sync2*(1.0f+(1+num%3)));  
			glUniform1fARB(glGetUniformLocationARB(sindist->program, "yfreq"), 4.0f*sync2*(1.0f+((num+1)%3)));  
			glUniform1fARB(glGetUniformLocationARB(sindist->program, "xphase"), 0);  
			glUniform1fARB(glGetUniformLocationARB(sindist->program, "yphase"), 0);
			glUniform1fARB(glGetUniformLocationARB(sindist->program, "xamp"), 0.1f);  
			glUniform1fARB(glGetUniformLocationARB(sindist->program, "yamp"), 0.1f);  
			glUniform1i(glGetUniformLocationARB(sindist->program, "tex"), 0);
			glUniform1fARB(glGetUniformLocationARB(sindist->program, "alpha"), fadeshell);
		}
		else
		{
			blur->bind();
			glUniform1i(glGetUniformLocationARB(blur->program, "tex"), 0);
			glUniform1fARB(glGetUniformLocationARB(blur->program, "alpha"), fadeshell);
			glUniform1fARB(glGetUniformLocationARB(blur->program, "yoff"), sync*0.075f);
		}

		const int texcoords[] = 
		{
			0,0,
			1,0,
			1,1,
			0,1
		};

		// rotate
		glBegin(GL_QUADS);
		int i;
		int halfcount = obuCount/2;
		int coord;
		for(i=0; i<obuCount; i++)
		{

			if(currentTime > 97500)
			{
				glEnd();
				glUniform1fARB(glGetUniformLocationARB(sindist->program, "xfreq"), 3.0f*sync2*(i%5));
				glUniform1fARB(glGetUniformLocationARB(sindist->program, "yfreq"), 4.0f*sync2*(i%3));  
				glBegin(GL_QUADS);
			}



			coord = (i&3)<<1;
			if(i==halfcount)
			{
				glEnd();
				glBindTexture(GL_TEXTURE_2D, dmsGetTexture("plank_shell2.jpg")->getID());
				glBegin(GL_QUADS);
			}

			p = obut[i].pos + (obut[i].endpos - obut[i].pos)*pos;

			Vector3 sizexr = xr * size;
			Vector3 sizeyr = yr * size;
			Vector3 v1 = p - sizexr - sizeyr;
			Vector3 v2 = p + sizexr - sizeyr;
			Vector3 v3 = p + sizexr + sizeyr;
			Vector3 v4 = p - sizexr + sizeyr;
			
			glTexCoord2f(texcoords[coord], texcoords[coord+1]);
			glVertex3fv((float *)&v1);
			coord+=2; if(coord>7) coord = 0;
			glTexCoord2f(texcoords[coord], texcoords[coord+1]);
			glVertex3fv((float *)&v2);
			coord+=2; if(coord>7) coord = 0;
			glTexCoord2f(texcoords[coord], texcoords[coord+1]);
			glVertex3fv((float *)&v3);
			coord+=2; if(coord>7) coord = 0;
			glTexCoord2f(texcoords[coord], texcoords[coord+1]);
			glVertex3fv((float *)&v4);
    
		}
		glEnd();

		if(currentTime > 97500)
		{
			sindist->unbind();
		}
		else
		{
			blur->unbind();
		}
	}
	glEnable(GL_DEPTH_TEST);
	glDepthMask(1);

    filter.drawNoiseOverlay(alpha*0.03f);

}

Meduusa::Meduusa()
{
    int i = 0;
    this->frametimer = new FrameTimer(1000 / 60, 5);


}

Meduusa::~Meduusa()
{
}

bool Meduusa::init(unsigned long s, unsigned long e)
{
	obuCount = 100;
	obut = new PlankShell[obuCount];

	int i;
    //merenpohja
	/*
    const int groundX = 50;
    const int groundY = 50;
    const float size2 = 14.0f;
    this->merenpohja = new GroundPlane(groundX, groundY, size2, 4.0f);
    this->merenpohja->makeCircularFade(1.0f, 1.0f);
	*/

    //meduusat
    srand(971457);//409510);

#ifdef NOT_FINAL_MEDUSA
	meduusat.clear();
#endif

	Vector3 meduusapositio = Vector3(0, 0, 0);
//    dmsMsg("meduusapositio = %f %f %f\n", meduusapositio.x, meduusapositio.y, meduusapositio.z);
//    Vector3 meduusadelta = Vector3(1, -1, 1);
    for (i = 0; i < 13 ; i++)
    {
        float a = Math::randBetween(0, 2*3.141592f);
        float r = 6 * Math::randFloat();
        const float YTYOTIPY = 2.7f;
        float y = Math::randBetween(-YTYOTIPY , YTYOTIPY);

        Vector3 position = Vector(cosf(a) * r, y, sinf(a) * r);
        position *= 1.3f;
		if(i==0) position = meduusapositio;
        Jellyfish j;
        j.init(i == 0, position + Vector3(0, -1, 0));// + meduusadelta);
         this->meduusat.push_back(j);
    }
#ifdef NOT_FINAL_MEDUSA
	emitterit.clear();
#endif
    for (i = 0; i < 4; i++)
    {
        MedusaEmitter e;
        e.init();
        Texture *texture;
        switch(i%2)
        {
            case 0:
                texture = dmsGetTexture("bubble1.png"); break;
            case 1:
                texture = dmsGetTexture("bubble2.png"); break;
        }
        e.texture = texture;
        this->emitterit.push_back(e);		
    }

	srand(13);
	float worldScale = 9.0f;
	Vector3 p;
	
	for(i=0; i<obuCount; i++)
	{
		p = Math::randVector() * worldScale;
		//if(p.y < 0) p.y = -p.y;
		obut[i].pos = p;
		obut[i].endpos = p + Math::randVectSphere()*Math::randFloat()*7.5f;
	}


	trigut = new TriggerSystem();
	trigut->add(90481, 91031);
	trigut->add(91714, 92264);
	trigut->add(92664, 93214);
	trigut->add(94790, 95240);
	trigut->add(96909, 97359);
	trigut->add(98887, 99037);
	trigut->add(98541, 98691);
	trigut->add(98681, 98831);
	trigut->add(99027, 99177);
	trigut->add(99190, 99340);
	trigut->add(99306, 99456);
	trigut->add(99399, 13900);

	// ste size
	trigut2 = new TriggerSystem();
	trigut2->add(984487, 104037); 

	// medusa time trigut
	medusatrigut = new TriggerSystem();
	medusatrigut->add(101052, 102102);
	medusatrigut->add(103200, 104250);
	medusatrigut->add(105248, 106298);
	medusatrigut->add(107249, 108299);
	medusatrigut->add(109432, 110482);
	medusatrigut->add(111499, 112549);
	medusatrigut->add(113404, 114454);
	medusatrigut->add(115684, 116734);
	medusatrigut->add(117688, 118738);
	medusatrigut->add(119739, 120789);
	medusatrigut->add(121778, 122828);
	medusatrigut->add(123994, 125044);
	medusatrigut->add(125911, 126961);
	medusatrigut->add(128002, 129052);
	medusatrigut->add(130120, 131170);


	// toolval 0.31 ~ok
	//srand(tool->getValue("slider3")*1000.0f);
	srand(0.90f*1000.0f);

	campos = new CatmullRom();
	for(i=0; i<6; i++)
	{
		Vector3 v = Math::randVectSphere() * (16.0f - 2.5f*(i+2%3)/3.0f);
		if(i==0 || i== 1) v *= 0.5f;
		if(i==2) v *= 0.45f;
		if(i==3) v *= 0.75f;
		while(v.y < 3.5) v.y+=3.5f;
		while(v.y > 3.5) v.y-=3.5f;
		campos->addPoint(v);
	}
	campos->endCreation();

	//srand(tool->getValue("slider4")*1000.0f);
	srand(0.05f*1000.0f);
	// pari alkumestaa niin ett kamera targetoi ekaa jelly
	camtgt = new CatmullRom();
	camtgt->addPoint(meduusapositio);
	camtgt->addPoint(meduusapositio);
	for(i=0; i<5; i++) 
	{
		Vector3 b = Math::randVectSphere()*0.7f;
		camtgt->addPoint(b);	
	}
	camtgt->endCreation();

	startTime = s;
	endTime = e;
    anal = new Analyzer(3);

    return true;
}

