#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Maailma.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Maailma::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}


MaailmaItem::MaailmaItem()
{
}
MaailmaItem::~MaailmaItem()
{
}
void MaailmaItem::init()
{
    float a = Math::randBetween(0, 2*3.141592f);
    float r = 2 * Math::randFloat();
    float y = Math::randBetween(1.0f, 5.0f);

    this->position = Vector3(sinf(a) * r, y, cosf(a) * r);

    this->direction = Math::randVectSphere()*0.001f;
    this->direction.y = fabsf(this->direction.y);
    this->animation = 0.0f;
    this->animationspeed = Math::randBetween(0.0002f, 0.0006f);
    this->scale = Math::randBetween(0.1f, 0.3f);
    this->fade = Math::randBetween(0.5f, 0.6f);
    
}
void MaailmaItem::update()
{
    this->position += this->direction;
    this->animation += this->animationspeed;
}

void MaailmaItem::draw(float alpha)
{
    glPushMatrix();
    glTranslatef(this->position.x, this->position.y, this->position.z);
    glColor4f(1,1,1,alpha);

    // Caustic numero
    int n = int(this->animation*32*20)%32 + 1;

	char buf[75];
	sprintf(buf, "cau_0%02d.jpg", n);
	Texture *texture = dmsGetTexture(buf);
    glBindTexture(GL_TEXTURE_2D, texture->getID());

    const int count = 2;
    glColor4f(1,1,1,alpha * this->fade);
    for (int i = 0; i < count; i++)
    {
        float t = i / (float)count;
        glPushMatrix();
        const float s = (i+0.2f) *0.5f* this->scale;
        glScalef(s, s, s);
        this->mesh->renderVBO();
        glPopMatrix();
    }
    glPopMatrix();

}



void Maailma::renderScene(float pos, float alpha)
{

    std::vector<MaailmaItem>::iterator it;
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
        for (it = this->items.begin(); it < this->items.end(); it++)
        {
            (*it).update();
        }
        this->frametimer->endStep();
    }

    glLoadIdentity();
    cameras->useCamera(0);
	this->merenpohja->renderWithNormalMaps(dmsGetTexture("deeptxt3.jpg"), dmsGetTexture("normal_map_deep3.jpg"), Vector3(1,1,1), alpha*0.3f);
    glDisable(GL_DEPTH_TEST);
    glEnable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    glEnable(GL_TEXTURE_2D);

    for (it = this->items.begin(); it < this->items.end(); it++)
    {
        (*it).draw(alpha);
    }

    
}




Maailma::Maailma()
{	
    this->frametimer = new FrameTimer(1000 / 60, 5);

    const int groundX = 50;
    const int groundY = 50;
    this->merenpohja = new GroundPlane(groundX, groundY, 13, 6.0f);
    this->merenpohja->makeCircularFade(1.0f, 1.0f);
    
    this->mesh = TMeshFactory::importT3D("sp.t3d");
    this->mesh->scale(1.0f);
    this->mesh->center();
    this->mesh->createVBO();

    for (int i = 0; i < 30; i++)
    {
        MaailmaItem item;
        item.init();
        item.setMesh(this->mesh);
        this->items.push_back(item);
    }
}

Maailma::~Maailma()
{
}


bool Maailma::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;
	return true;
}

