#ifndef _Huttu_HPP_
#define _Huttu_HPP_

#include <stdio.h>
#include "../externs.hpp"
#include "../bpm.hpp"

class Grid3d
{
	public:
		Grid3d(int tsize);
		~Grid3d();
		void initVectorField();
		Vector3 getSpeedForVector(Vector3 &p);
		Vector3 getSpeedForVector(int fx, int fy, int fz);
		void drawDebug();
		
		int boundx, boundx2;
		int boundy, boundy2;
		int boundz, boundz2;

		int GRID_SHIFT;
		int GRID_MASK;
		int GRID_ONE;
	
	private:
		Vector3 speedOutSide;
		int size;
		int totalsize;
		Vector3 *spd;	
};

class Huttu : public Base
{
	public:
		Huttu();
		~Huttu();

		bool init(unsigned long s, unsigned long e);
		void draw();
		

	private: 
        FrameTimer *frametimer;
		void renderScene(float pos, float alpha);
		
		Grid3d *grid;

		Vector3 *obut;
		int obucount;

};

#endif

 