#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Huttu.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

//#define min(x,y) (x<y?x:y)
//#define max(x,y) (x>y?x:y)

void Huttu::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.1f;
	const float fadeoutstart = 0.90f;   
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

//    filter.init(true);
	renderScene(pos, alpha);
//    filter.glow(8, 0.005f, 0.005f, 0.92f, -1.0f, 1.0f);
}

void Huttu::renderScene(float pos, float alpha)
{
 
	int cx = (grid->boundx2 - grid->boundx)>>1; 
	int cy = (grid->boundy2 - grid->boundy)>>1;
	int cz = (grid->boundz2 - grid->boundz)>>1;

    Vector3 cam = Vector3(cx, cy, cz-1250);
    Vector3 tgt = Vector3(cx, cy, cz);
    Vector3 upw = Vector3(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);


	//glRotatef(0, 1,1,1);

	float dt = frametimer->getDeltaTime() * 0.0000001;//00001f;

	glColor3f(1,1,1);
	
	glDisable(GL_TEXTURE_2D);
	glPointSize(3);
	glBegin(GL_POINTS);
	for(int i=0; i<obucount; i++)
	{
		obut[i] += grid->getSpeedForVector(obut[i]) * dt;
		glVertex3fv((float*)&(obut[i]));
	}
	glEnd();
	

	//grid->drawDebug();
}




Huttu::Huttu()
{	
    this->frametimer = new FrameTimer(1000 / 60, 5);
}

Huttu::~Huttu()
{
}


bool Huttu::init(unsigned long s, unsigned long e)
{

	grid = new Grid3d(40);
	grid->initVectorField();

	obucount = 1000;
	obut = new Vector3[obucount];
	for(int i=0; i<obucount; i++)
	{
		obut[i] = Math::randVector2() * (grid->boundx2-grid->boundx);
	}


	startTime = s;
	endTime = e;
	return true;
}


Grid3d::Grid3d(int tsize)
{
	size = tsize;
	totalsize = tsize*tsize*tsize;
	spd = new Vector3[totalsize];

	GRID_SHIFT = 4;
	GRID_ONE = 1 << GRID_SHIFT;
	GRID_MASK = GRID_ONE - 1;
	speedOutSide = Vector3();

	boundx = 0;
	boundy = 0;
	boundz = 0;
	boundx2 = size << GRID_SHIFT;
	boundy2 = size << GRID_SHIFT;
	boundz2 = size << GRID_SHIFT;
}

void Grid3d::initVectorField()
{
	for(int x=0; x<size; x++)
	for(int y=0; y<size; y++)
	for(int z=0; z<size; z++)
	{
		int n = x*size*size + y*size + z;
		//spd[n] = Vector3(sin(x), cos(y), 0);//atan(x*x*z*y));
		spd[n] = Vector3((boundx2>>1)-x, (boundy2>>1)-y, (boundz2>>1)-z);//atan(x*x*z*y));
		spd[n] = spd[n].normalize();
	}
}

Vector3 Grid3d::getSpeedForVector(int fx, int fy, int fz)
{
	int x = fx & GRID_MASK;
	int y = fy & GRID_MASK;
	int z = fz & GRID_MASK;

	int d = size-1;
	x = min(max(0, x), d);
	y = min(max(0, y), d);
	z = min(max(0, z), d);
	//if(x < 0 || x >= size || y < 0 || y >= size || z < 0 || z >= size) return speedOutSide;

	return spd[(x*size*size+y*size+z)];
}


Vector3 Grid3d::getSpeedForVector(Vector3 &p)
{
	return getSpeedForVector(p.x, p.y, p.z);
}

void Grid3d::drawDebug()
{

	glColor3f(0,1,0);
	glDisable(GL_TEXTURE_2D);
	glLineWidth(1);
	glBegin(GL_LINES);
	for(int x=0; x<size; x++)
	for(int y=0; y<size; y++)
	for(int z=0; z<size; z++)
	{
		Vector3 s = Vector3(x<<GRID_SHIFT, y<<GRID_SHIFT, z<<GRID_SHIFT);
		glVertex3fv((float*)&(s));
		glVertex3fv((float*)&(s+(spd[x*size*size+y*size+z]*(GRID_ONE>>2))));
		
	}
	glEnd();
}