#ifdef _DEBUG
	#include <stdlib.h>
//	#include "../mmgr.h"
#endif

#include <math.h>

#include "Credits.h"
#include "../mathematics.hpp"
#include "../primitives.hpp"

void Credits::draw()
{
	const float pos = (time - startTime) / (endTime - startTime);
	float alpha = 1.0f;

	const float fadeinstart = 0.0f;
	const float fadeinstop = 0.25f;
	const float fadeoutstart = 0.85f;
	const float fadeoutstop = 1.0f;

	if (pos >= fadeinstart && pos <= fadeinstop)
		alpha *= (pos-fadeinstart) / (fadeinstop-fadeinstart);
	if (pos >= fadeoutstart && pos <= fadeoutstop)
		alpha *= 1-(pos-fadeoutstart) / (fadeoutstop-fadeoutstart);

    filter.init(true);
	renderScene(pos, alpha);
    filter.glow(4, 0.005f, 0.005f, 0.92f*0.94f, -1.0f, 1.0f);
}

void Credits::renderScene(float pos, float alpha)
{
 
	bool imageUpdated=false;
    this->frametimer->update();
    while (this->frametimer->stepsLeft())
    {
		for(int n=0; n<3; n++)
		{
			int x = rand()%watereffu->size;
			int y = rand()%watereffu->size;
			watereffu->buffer2[(x)*watereffu->size+y] = 255;
		}
	
		watereffu->updateBuffers();
		imageUpdated = true;
        this->frametimer->endStep();
    }

	if(imageUpdated) 
	{
		watereffu->uploadNormalMap(1.0f);
		watereffu->uploadDxDy();
	}

    Vector3 cam = Vector3(0, 0, -7);
    Vector3 tgt = Vector3(0, 0, 0);
    Vector3 upw = Vector3(0, 1, 0);

    glLoadIdentity();
    gluLookAt(cam.x, cam.y, cam.z, tgt.x, tgt.y, tgt.z, upw.x, upw.y, upw.z);

	Shader *ss;

if(!Config::nv7)
{	
	ss = shaders->getShader("greetwater");
	ss->bind(); 

	ss->setUniform1i("water", 0);  
	ss->setUniform1i("tex", 1);
	 glActiveTextureARB(GL_TEXTURE0_ARB);
	 glEnable(GL_TEXTURE_2D);
	 glBindTexture(GL_TEXTURE_2D, watereffu->normalMapTexture);
	 glActiveTextureARB(GL_TEXTURE1_ARB);
	 glEnable(GL_TEXTURE_2D);
}

	glBindTexture(GL_TEXTURE_2D, dmsGetTexture("credits.png")->getID());

if(!Config::nv7)
{	
	ss->setUniform1f("distortmodi", alpha*0.20f);
	ss->setUniform4f("vari", 1,1,1, alpha);
}
else
{
	glColor4f(1,1,1, alpha);
}
	//Primitives::flatTausta(alpha,alpha,alpha,alpha);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);


	glDisable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);

	dmsPerspective2D(1,1);
	glLoadIdentity();

	float x0 = 0;
	float x1 = 1;
	float y0 = 1;
	float y1 = 0;

	float size = 0.20 - pos * 0.06f;

	glBegin(GL_QUADS);

	glTexCoord2f(x0, y0);
	glVertex2f(0.5f-size, 0.5f-size);
	glTexCoord2f(x1, y0);
	glVertex2f(0.5f+size, 0.5f-size);
	glTexCoord2f(x1, y1);
	glVertex2f(0.5f+size, 0.5f+size);
	glTexCoord2f(x0, y1);
	glVertex2f(0.5f-size, 0.5f+size);

	glEnd();

	dmsPerspective3D();
	glLoadIdentity();

if(!Config::nv7)
{	

	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE1_ARB);
	glDisable(GL_TEXTURE_2D);
	ss->unbind();
}
	glDisable(GL_TEXTURE_2D);
	glActiveTextureARB(GL_TEXTURE0_ARB);
	glDisable(GL_TEXTURE_2D);



}




Credits::Credits()
{	
    this->frametimer = new FrameTimer(1000 / 20, 5);
}

Credits::~Credits()
{
}


bool Credits::init(unsigned long s, unsigned long e)
{
	startTime = s;
	endTime = e;

	watereffu = new WaterEffect();
	watereffu->init(256);
	
	return true;
}

