#ifndef _CONFIGTOOL_HPP_
#define _CONFIGTOOL_HPP_

#include "externs.hpp"

#include "GUI/tinyxml/tinyxml.h"

#include "GUI/GUIHolder.h"
#include "GUI/GUIFont.h"
#include "GUI/GUIHolder.h"
#include "GUI/GUIButton.h"
#include "GUI/GUIToggleButton.h"
#include "GUI/GUISlider.h"
#include "GUI/GUITextField.h"
#include "GUI/GUILabel.h"
#include <string>

//std::string getNamebyID(int n);
//int getIDbyName(std::string name);

//extern class ConfigTool *tool;

class ConfigTool
{
public:
	ConfigTool(float scrw, float scrh); 
	~ConfigTool();

	GUIHolder *holder;	// gui widget holder
	float arvo;

	void load();
	void save();
	void load_and_dump();
	void dumpXml(TiXmlNode * pParent, unsigned int indent = 0);
	const char * getIndent( unsigned int numIndents );
	void ConfigTool::loadElement(TiXmlElement * pParent);

	bool initialized;
	void init();
	void deinit();
	bool update(MSG msg);	
	bool visible;

	// getters 
	float getValue(const char *text);
	Vector3 getColor(const char *text);
	Vector3 setColor(const char *text);

private:

	Vector3 getPosition(int index);
	float getX();
	float getY();

	float screenWidth, screenHeight;
};

#endif