.286

SEG_A   SEGMENT
        
                ASSUME CS:SEG_A, DS:SEG_A, ES:SEG_A

                ORG     100h

PTAV                    EQU     5
SUGAR                   EQU     59

COMALAP PROC FAR

START:
                JMP     INIT
                DB      'Copyright (C) The Cat 1991.  All rights reserved.',10,13,1AH

STA:
                MOV     AX,13H
                INT     10H

                CLI
                CLD
                MOV     SP,OFFSET VEREM
VEREM:
                MOV     SI,OFFSET KEP
                MOV     CX,256*3
                XOR     AL,AL
                MOV     DX,3C8H
                OUT     DX,AL
                INC     DX
        REP     OUTSB

                MOV     AL,0FCH
                OUT     21H,AL
                MOV     AX,80
                OUT     40H,AL
                MOV     AL,AH
                OUT     40H,AL                  
                XOR     AX,AX
                MOV     ES,AX
                MOV     AX,ES:[20H]
                MOV     TIMER1,AX
                MOV     AX,ES:[22H]
                MOV     TIMER2,AX
                MOV     AX,ES:[24H]
                MOV     TIMER3,AX
                MOV     AX,ES:[26H]
                MOV     TIMER4,AX
                MOV     AX,OFFSET IRQ
                MOV     ES:[20H],AX
                MOV     AX,OFFSET BIRQ
                MOV     ES:[24H],AX
                MOV     ES:[22H],CS
                MOV     ES:[26H],CS

                CALL    IXOROL

                MOV     AX,0A000H
                MOV     ES,AX
                XOR     DI,DI
                MOV     SI,OFFSET KEP+768

                CALL    RASTER

                LODSB
                MOV     BX,SI
                ADD     SI,25

                ROL     BYTE PTR [BX],1
                JNC     V7

                PUSH    BX
                MOV     BX,SI
                ADD     SI,40
                MOV     CH,40
V3:             MOV     CL,8
V4:             ROL     BYTE PTR [BX],1
                JC      V5
                STOSB
                JMP     SHORT V6
V5:             MOVSB
V6:             DEC     CL
                JNZ     V4
                INC     BX
                DEC     CH
                JNZ     V3
                POP     BX
                JMP     SHORT V8

V7:             MOV     AH,AL
                MOV     CX,160
        REP     STOSW

V8:

                MOV     CL,7
VS2:            ROL     BYTE PTR [BX],1
                JNC     VS7

                PUSH    CX
                PUSH    BX
                MOV     BX,SI
                ADD     SI,40
                MOV     CH,40
VS3:            MOV     CL,8
VS4:            ROL     BYTE PTR [BX],1
                JC      VS5
                MOV     AL,ES:[DI-320]
                STOSB
                JMP     SHORT VS6
VS5:            MOVSB
VS6:            DEC     CL
                JNZ     VS4
                INC     BX
                DEC     CH
                JNZ     VS3
                POP     BX
                POP     CX
                JMP     SHORT VS8

VS7:            PUSH    CX
                MOV     CX,160
UJC1:           MOV     AX,ES:[DI-320]
                STOSW
                LOOP    UJC1
                POP     CX

VS8:            DEC     CL
                JNZ     VS2
                INC     BX

                MOV     CH,24
VSZ1:           MOV     CL,8
VSZ2:           ROL     BYTE PTR [BX],1
                JNC     VSZ7

                PUSH    CX
                PUSH    BX
                MOV     BX,SI
                ADD     SI,40
                MOV     CH,40
VSZ3:           MOV     CL,8
VSZ4:           ROL     BYTE PTR [BX],1
                JC      VSZ5
                MOV     AL,ES:[DI-320]
                STOSB
                JMP     SHORT VSZ6
VSZ5:           MOVSB
VSZ6:           DEC     CL
                JNZ     VSZ4
                INC     BX
                DEC     CH
                JNZ     VSZ3
                POP     BX
                POP     CX
                JMP     SHORT VSZ8

VSZ7:                   PUSH    CX
                                MOV     CX,160
UJC2:                   MOV     AX,ES:[DI-320]
                                STOSW
                                LOOP    UJC2
                                POP     CX

VSZ8:                   DEC     CL
                                JNZ     VSZ2
                                INC     BX
                                DEC     CH
                                JNZ     VSZ1

                                STI
                                MOV     CX,56400
VAR:                    HLT
                                HLT
                                HLT
                                HLT
                                LOOP    VAR

                                CALL    RASTER

                                MOV     CX,32000
                                XOR     AX,AX
                                MOV     DI,AX
                REP     STOSW

                                MOV     SI,OFFSET SINTAB
                                MOV     DI,OFFSET STEXT
                                MOV     BP,OFFSET SEGTER2
KEZD:
                                CALL    RASTER

                                MOV     DH,255;-4*8
CIK:                    
                                MOV     BX,OFFSET JEL+1
                                MOV     AL,FAZIS
                                AND     AL,3
                                MOV     AH,DH
                                AND     AH,3
                                CMP     AL,AH
                                JZ      BEHA
                                MOV     BYTE PTR [BX],1
                                MOV     BYTE PTR VIZSG,0F8H
                                DEC     AL
                                AND     AL,3
                                CMP     AL,AH
                                JZ      BEHA2
                                JMP     KIHA
BEHA:                   MOV     BYTE PTR [BX],0
                                MOV     BYTE PTR VIZSG,0F9H
BEHA2:
                                MOV     DL,8
CIKLUS:
                                PUSH    DX
                                XOR     BH,BH
                                MOV     BL,DH
                                MOV     AL,PTAV
                                MUL     DL
                                ADD     AL,SUGAR
                                PUSH    AX
                                MOV     AH,[SI+BX]
                                AND     AH,127
                                MUL     AH
                                SHL     AX,1
                                ADD     AX,128
                                MOV     AL,[SI+BX]
                                SHL     AH,1
                                SHL     AL,1
                                RCR     AH,1
                                MOV     CL,AH
                                POP     AX
                                ADD     BL,64
                                MOV     AH,[SI+BX]
                                AND     AH,127
                                MUL     AH
                                SHL     AX,1
                                ADD     AX,128
                                MOV     AL,[SI+BX]
                                SHL     AH,1
                                SHL     AL,1
                                RCR     AH,1

                                MOV     BL,CL
                                MOV     CL,AH
                                XOR     AL,AL
FELE:                   JMP     SHORT POZ
                                MOV     AL,FAZIS
JEL:                    SUB     AL,0
                                MOV     BH,AL
                                AND     AX,0111111100001111B
                                TEST    BH,16
                                JZ      FOR
                                SUB     AL,15
                                NEG     AL
FOR:                    MUL     AH
                                SHR     AX,1
                                SHR     AX,1
                                SHR     AX,1
                                SHR     AX,1
                                OR      CL,CL
                                JNS     POZO
                                NOT     AL
POZO:                   AND     BH,32
                                JZ              POZ
                                NOT     AL
POZ:                    MOV     CH,156
                                ADD     CH,AL
                                CALL    CORD2D
                                CALL    VIZSG
                                CALL    PONTKI
                                POP     DX
                                DEC     DL
                                JZ      KIHA
                                JMP     CIKLUS
KIHA:                   DEC     DH
                                JZ      NOCIK
                                JMP     CIK

NOCIK:
                                INC     FAZIS
                                MOV     AH,FAZIS
                                AND     AH,31
                                JNZ     VIZS
VISSZ:
                                MOV     BL,[DI]
                                OR      BL,BL
                                JNZ     NEND
                                MOV     DI,OFFSET TEXT
                                MOV     BX,OFFSET FELE
                                MOV     [BX],9090H
                                JMP     SHORT VISSZ
NEND:
                                XOR     BH,BH
                                SHL     BX,1
                                SHL     BX,1
                                SHL     BX,1
                                ADD     BX,OFFSET CHRSET-256
                                MOV     AL,[BX]
                                MOV     [BP+8],AL
                                MOV     AL,[BX+1]
                                MOV     [BP+8+9],AL
                                MOV     AL,[BX+1*2]
                                MOV     [BP+8+9*2],AL
                                MOV     AL,[BX+1*3]
                                MOV     [BP+8+9*3],AL
                                MOV     AL,[BX+1*4]
                                MOV     [BP+8+9*4],AL
                                MOV     AL,[BX+1*5]
                                MOV     [BP+8+9*5],AL
                                MOV     AL,[BX+1*6]
                                MOV     [BP+8+9*6],AL
                                MOV     AL,[BX+1*7]
                                MOV     [BP+8+9*7],AL
                                INC     DI
VIZS:
                                AND     AH,3
                                JZ      VIZS1
                                JMP     VIZS2
VIZS1:
                                RCL     BYTE PTR [BP+71],1
                                RCL     BYTE PTR [BP+70],1
                                RCL     BYTE PTR [BP+69],1
                                RCL     BYTE PTR [BP+68],1
                                RCL     BYTE PTR [BP+67],1
                                RCL     BYTE PTR [BP+66],1
                                RCL     BYTE PTR [BP+65],1
                                RCL     BYTE PTR [BP+64],1
                                RCL     BYTE PTR [BP+63],1
                                RCL     BYTE PTR [BP+62],1
                                RCL     BYTE PTR [BP+61],1
                                RCL     BYTE PTR [BP+60],1
                                RCL     BYTE PTR [BP+59],1
                                RCL     BYTE PTR [BP+58],1
                                RCL     BYTE PTR [BP+57],1
                                RCL     BYTE PTR [BP+56],1
                                RCL     BYTE PTR [BP+55],1
                                RCL     BYTE PTR [BP+54],1
                                RCL     BYTE PTR [BP+53],1
                                RCL     BYTE PTR [BP+52],1
                                RCL     BYTE PTR [BP+51],1
                                RCL     BYTE PTR [BP+50],1
                                RCL     BYTE PTR [BP+49],1
                                RCL     BYTE PTR [BP+48],1
                                RCL     BYTE PTR [BP+47],1
                                RCL     BYTE PTR [BP+46],1
                                RCL     BYTE PTR [BP+45],1
                                RCL     BYTE PTR [BP+44],1
                                RCL     BYTE PTR [BP+43],1
                                RCL     BYTE PTR [BP+42],1
                                RCL     BYTE PTR [BP+41],1
                                RCL     BYTE PTR [BP+40],1
                                RCL     BYTE PTR [BP+39],1
                                RCL     BYTE PTR [BP+38],1
                                RCL     BYTE PTR [BP+37],1
                                RCL     BYTE PTR [BP+36],1
                                RCL     BYTE PTR [BP+35],1
                                RCL     BYTE PTR [BP+34],1
                                RCL     BYTE PTR [BP+33],1
                                RCL     BYTE PTR [BP+32],1
                                RCL     BYTE PTR [BP+31],1
                                RCL     BYTE PTR [BP+30],1
                                RCL     BYTE PTR [BP+29],1
                                RCL     BYTE PTR [BP+28],1
                                RCL     BYTE PTR [BP+27],1
                                RCL     BYTE PTR [BP+26],1
                                RCL     BYTE PTR [BP+25],1
                                RCL     BYTE PTR [BP+24],1
                                RCL     BYTE PTR [BP+23],1
                                RCL     BYTE PTR [BP+22],1
                                RCL     BYTE PTR [BP+21],1
                                RCL     BYTE PTR [BP+20],1
                                RCL     BYTE PTR [BP+19],1
                                RCL     BYTE PTR [BP+18],1
                                RCL     BYTE PTR [BP+17],1
                                RCL     BYTE PTR [BP+16],1
                                RCL     BYTE PTR [BP+15],1
                                RCL     BYTE PTR [BP+14],1
                                RCL     BYTE PTR [BP+13],1
                                RCL     BYTE PTR [BP+12],1
                                RCL     BYTE PTR [BP+11],1
                                RCL     BYTE PTR [BP+10],1
                                RCL     BYTE PTR [BP+9],1
                                RCL     BYTE PTR [BP+8],1
                                RCL     BYTE PTR [BP+7],1
                                RCL     BYTE PTR [BP+6],1
                                RCL     BYTE PTR [BP+5],1
                                RCL     BYTE PTR [BP+4],1
                                RCL     BYTE PTR [BP+3],1
                                RCL     BYTE PTR [BP+2],1
                                RCL     BYTE PTR [BP+1],1
                                RCL     BYTE PTR [BP],1

VIZS2:
                                MOV     BX,BP
                                MOV     CX,9*4
MAS:                    MOV     AX,[BX]
                                MOV     [BX-72],AX
                                ADD     BX,2
                                LOOP    MAS
                                
                                JMP     KEZD

VEGE:           CLI
                XOR     AX,AX
                MOV     ES,AX
                MOV     AX,TIMER1
                MOV     ES:[20H],AX
                MOV     AX,TIMER2
                MOV     ES:[22H],AX
                MOV     AX,TIMER3
                MOV     ES:[24H],AX
                MOV     AX,TIMER4
                MOV     ES:[26H],AX
                MOV     AL,20H
                OUT     61H,AL
                XOR     AL,AL
                OUT     40H,AL
                OUT     40H,AL
                MOV     AL,0B8H
                OUT     21H,AL
                MOV     AX,3
                INT     10H
                INT     20h

;----------------------------------------------------------

VIZSG:
                                CLC
                                JNC     ATUG

                                PUSH    BX
                                XOR     BH,BH
                                MOV     AH,8
                                SUB     AH,DL
                                MOV     BL,AH
                                SHL     BL,1
                                SHL     BL,1
                                SHL     BL,1
                                ADD     BL,AH
                                ADD     BX,OFFSET SEGTER
                                RCL     BYTE PTR [BX+8],1
                                RCL     BYTE PTR [BX+7],1
                                RCL     BYTE PTR [BX+6],1
                                RCL     BYTE PTR [BX+5],1
                                RCL     BYTE PTR [BX+4],1
                                RCL     BYTE PTR [BX+3],1
                                RCL     BYTE PTR [BX+2],1
                                RCL     BYTE PTR [BX+1],1
                                RCL     BYTE PTR [BX],1
                                POP     BX
                                JNC     ATUG
                                MOV     DL,CH
                                SHR     DL,1
                                SHR     DL,1
                                SHR     DL,1
                                SHR     DL,1
                                NEG     DL
                                AND     DL,15
                                ADD     DL,32 ;*
                                JMP     SHORT ATUG2
ATUG:
                                XOR     DL,DL
ATUG2:
                                RETN

;----------------------------------------------------------

BIRQ:
                IN      AL,60H
                MOV     BP,SP
                MOV     [BP],OFFSET VEGE
                MOV     AL,20H
                OUT     20H,AL
                IRET

;----------------------------------------------------------

CORD2D:
                                MOV     AH,CH                                           ;       BL=XCORD
                                MOV     AL,BL                                           ;       CL=YCORD
                                AND     AL,127                                  ;       CH=ZCORD
                                MUL     AH                                                      ;       XCORD=BX
                                ADD     AX,128                                  ;       YCORD=AL

                                MOV     AL,128
                                SHL     BL,1
                                JC      NEGATIV

                                ADD     AL,AH
                                JMP     SHORT XTOV
NEGATIV:                SUB     AL,AH
XTOV:
                                XOR     AH,AH
                                MOV     BX,AX
                                ADD     BX,32

                                MOV     AH,CH
                                MOV     AL,CL
                                AND     AL,127
                                MUL     AH
                                ADD     AX,128
                                MOV     AL,100
                                OR      CL,CL
                                JS      NEGATI2

                                ADD     AL,AH
                                JMP     SHORT YTOV
NEGATI2:                SUB     AL,AH
YTOV:
                                RETN

;----------------------------------------------------------

RASTER:
                                MOV     DX,3DAH
RAST0:          IN      AL,DX
                                AND     AL,1
                                JNZ     RAST0
RAST1:          CBW
RAST2:          IN      AL,DX
                                INC     AH
                                CMP     AH,10
                                JNZ     RAST3
                                RETN
RAST3:          AND     AL,1
                                JNZ     RAST2
                                JMP     SHORT RAST1

;----------------------------------------------------------

PONTKI:         PUSH    BX
                                XOR     AH,AH                                           ;       BX=XCORD
                                SHL     AX,1                                            ;       AL=YCORD
                                SHL     AX,1                                            ;       DL=COLOR
                                SHL     AX,1
                                SHL     AX,1
                                SHL     AX,1
                                MOV     BX,AX
                                SHL     AX,1
                                SHL     AX,1
                                ADD     AX,BX
                                SHL     AX,1
                                POP     BX
                                ADD     BX,AX
                                MOV     BYTE PTR ES:[BX],DL
                                RETN

;----------------------------------------------------------

IXOROL:         MOV     SI,OFFSET HELP
TXOROL:         XOR     BYTE PTR [SI],123
                                INC     SI
                                CMP     SI,OFFSET HELPEND
                                JNZ     TXOROL
                                RETN

;----------------------------------------------------------

HELP:
TEXT                    DB      '  C1991 THE CAT  SCROLL BY TOMCAT  MUSIC BY DAVE  '
                                DB      'WATCH THIS SUPER SCROLLY AND ENJOY THE MUZAK  ',0
STEXT                   DB      'YEAH      ',0
HELPEND:

SEGTER          DB      8*9 DUP (0)
SEGTER2         DB      8*9 DUP (0)

TIMER1          DW      0
TIMER2          DW      0
TIMER3          DW      0
TIMER4          DW      0

FAZIS                   DB      0

SINTAB:         DB      0,3,6,9,12,16,19,22,25,28,31,34,37,40,43,46,49,51,54,57,60
                                DB      63,65,68,71,73,76,78,81,83,85,88,90,92,94,96,98,100,102,104
                                DB      106,107,109,111,112,113,115,116,117,118,120,121,122,122,123
                                DB      124,125,125,126,126,126,127,127,127,127,127,127,127,126,126
                                DB      126,125,125,124,123,122,122,121,120,118,117,116,115,113,112
                                DB      111,109,107,106,104,102,100,98,96,94,92,90,88,85,83,81,78,76
                                DB      73,71,68,65,63,60,57,54,51,49,46,43,40,37,34,31,28,25,22,19
                                DB      16,12,9,6,3,128,131,134,137,140,144,147,150,153,156,159,162
                                DB      165,168,171,174,177,179,182,185,188,191,193,196,199,201,204
                                DB      206,209,211,213,216,218,220,222,224,226,228,230,232,234,235
                                DB      237,239,240,241,243,244,245,246,248,249,250,250,251,252,253
                                DB      253,254,254,254,255,255,255,255,255,255,255,254,254,254,253
                                DB      253,252,251,250,250,249,248,246,245,244,243,241,240,239,237
                                DB      235,234,232,230,228,226,224,222,220,218,216,213,211,209,206
                                DB      204,201,199,196,193,191,188,185,182,179,177,174,171,168,165
                                DB      162,159,156,153,150,147,144,140,137,134,131

CHRSET:         DB      512 DUP (0)

;----------------------------------------------------------

IRQ:                    PUSH    AX
                                PUSH    BX
                                PUSH    DS
                                MOV     AX,CS
                                MOV     DS,AX
                                CMP     DRHO,0
                                JZ      IRQ0
                                DEC     DRHO
                                DEC     DRCLL
                                JNZ     IRQ0
                                MOV     AX,DRCLS
                                MOV     DRCLL,AX
                                MOV     BX,DRJMP
                                CALL    BX
IRQ0:                   DEC     S1LEN
                                JNZ     IRQ5
                                MOV     BX,S1PNT1
IRQS1B:         MOV     AL,[BX]
                                CMP     AL,80H
                                JNZ     IRQ2
                                MOV     BX,S1PNT2
                                MOV     AX,[BX]
                                OR      AX,AX
                                JNZ     IRQ1
                                MOV     BX,[BX+2]
                                MOV     AX,[BX]
IRQ1:                   INC     BX
                                INC     BX
                                MOV     S1PNT2,BX
                                MOV     BX,AX
                                MOV     AL,[BX]
IRQ2:                   INC     BX
                                MOV     S1PNT1,BX
                                TEST    AL,80H
                                JNZ     IRQ3
                                ADD     AL,FRQAD1
                                MOV     BX,OFFSET FRQTBL
                                XLAT
                                MOV     S1FRQ,AL
                                MOV     S1FRQS,AL
                                XOR     AH,AH
                                MOV     BX,AX
                                SHL     AX,1
                                SHL     AX,1
                                ADD     AX,BX
                                MOV     S1SQ,AX
                                MOV     AX,S1LENS
                                MOV     S1LEN,AX
                                MOV     AX,S1DECS
                                MOV     S1DEC,AX
                                JMP     SHORT IRQ5
IRQ3:                   SHL     AL,1
                                XOR     AH,AH
                                MOV     BX,OFFSET JPTBL1-2
                                ADD     BX,AX
                                JMP     [BX]
IRQS1B2:
IRQ5:                   DEC     S1FRQ
                                JNZ     IRQ6
                                MOV     AL,S1FRQS
                                OR      AL,AL
                                JZ      IRQ6
                                MOV     S1FRQ,AL
                                MOV     AL,0B0H
                                OUT     43H,AL
                                MOV     AX,S1SQ
                                OUT     42H,AL
                                MOV     AL,AH
                                OUT     42H,AL
                                MOV     AL,23H
                                OUT     61H,AL
IRQ6:                   DEC     S1DEC
                                JNZ     IRQ7
                                MOV     AX,S1DECS
                                MOV     S1DEC,AX
                                DEC     S1SQ
                                JNZ     IRQ7
                                INC     S1SQ
IRQ7:                   DEC     S2LEN
                                JNZ     IRQ12
                                MOV     BX,S2PNT1
IRQS2B:         MOV     AL,[BX]
                                CMP     AL,80H
                                JNZ     IRQ9
                                MOV     BX,S2PNT2
                                MOV     AX,[BX]
                                OR      AX,AX
                                JNZ     IRQ8
                                MOV     BX,[BX+2]
                                MOV     AX,[BX]
IRQ8:                   INC     BX
                                INC     BX
                                MOV     S2PNT2,BX
                                MOV     BX,AX
                                MOV     AL,[BX]
IRQ9:                   INC     BX
                                MOV     S2PNT1,BX
                                TEST    AL,80H
                                JNZ     IRQ10
                                ADD     AL,FRQAD2
                                MOV     BX,OFFSET FRQTBL
                                XLAT
                                MOV     S2FRQ,AL
                                MOV     S2FRQS,AL
                                XOR     AH,AH
                                SHL     AX,1
                                SHL     AX,1
                                MOV     BX,AX
                                SHL     AX,1
                                SHL     AX,1
                                ADD     BX,AX
                                MOV     S2SQ,AX
                                MOV     AX,S2LENS
                                MOV     S2LEN,AX
                                MOV     AX,S2DECS
                                MOV     S2DEC,AX
                                JMP     SHORT IRQ12
IRQ10:          SHL     AL,1
                                XOR     AH,AH
                                MOV     BX,OFFSET JPTBL2-2
                                ADD     BX,AX
                                JMP     [BX]
IRQS2B2:
IRQ12:          DEC     S2FRQ
                                JNZ     IRQ13
                                MOV     AL,S2FRQS
                                OR      AL,AL
                                JZ      IRQ13
                                MOV     S2FRQ,AL
                                MOV     AL,0B0H
                                OUT     43H,AL
                                MOV     AX,S2SQ
                                OUT     42H,AL
                                MOV     AL,AH
                                OUT     42H,AL
                                MOV     AL,23H
                                OUT     61H,AL
IRQ13:          DEC     S2DEC
                                JNZ     IRQ14
                                MOV     AX,S2DECS
                                MOV     S2DEC,AX
                                DEC     S2SQ
                                JNZ     IRQ14
                                INC     S2SQ
IRQ14:          DEC     DRLEN
                                JNZ     IRQDRB2
                                MOV     BX,DRPNT1
IRQDRB1:                MOV     AX,DRLENS
                                MOV     DRLEN,AX
                                MOV     AL,[BX]
                                CMP     AL,80H
                                JNZ     IRQ16
                                MOV     BX,DRPNT2
                                MOV     AX,[BX]
                                OR      AX,AX
                                JNZ     IRQ15
                                MOV     BX,[BX+2]
                                MOV     AX,[BX]
IRQ15:          INC     BX
                                INC     BX
                                MOV     DRPNT2,BX
                                MOV     BX,AX
                                MOV     AL,[BX]
IRQ16:          INC     BX
                                MOV     DRPNT1,BX
                                SHL     AL,1
                                XOR     AH,AH
                                MOV     BX,OFFSET DRJPT
                                ADD     BX,AX
                                JMP     [BX]
IRQDRB2:                POP     DS
                                POP     BX
                                MOV     AL,20H
                                OUT     20H,AL
                                POP     AX
                                IRET

S1R1:                   MOV     S1FRQS,0
                                MOV     AX,S1LENS
                                MOV     S1LEN,AX
                                JMP     IRQS1B2

S1R2:                   MOV     BX,S1PNT1
                                MOV     AL,[BX]
                                XOR     AH,AH
                                SHL     AX,1
                                SHL     AX,1
                                SHL     AX,1
                                MOV     S1DECS,AX
                                INC     BX
                                JMP     IRQS1B

S1R3:                   MOV     BX,S1PNT1
                                MOV     AL,[BX]
                                MOV     AH,220
                                MUL     AH
                                SHL     AX,1
                                SHL     AX,1
                                MOV     S1LENS,AX
                                INC     BX
                                JMP     IRQS1B

S1R4:                   MOV     BX,S1PNT1
                                MOV     AL,[BX]
                                MOV     FRQAD1,AL
                                INC     BX
                                JMP     IRQS1B

S2R1:                   MOV     S2FRQS,0
                                MOV     AX,S2LENS
                                MOV     S2LEN,AX
                                JMP     IRQS2B2

S2R2:                   MOV     BX,S2PNT1
                                MOV     AL,[BX]
                                XOR     AH,AH
                                SHL     AX,1
                                SHL     AX,1
                                SHL     AX,1
                                MOV     S2DECS,AX
                                INC     BX
                                JMP     IRQS2B

S2R3:                   MOV     BX,S2PNT1
                                MOV     AL,[BX]
                                MOV     AH,220
                                MUL     AH
                                SHL     AX,1
                                SHL     AX,1
                                MOV     S2LENS,AX
                                INC     BX
                                JMP     IRQS2B

S2R4:                   MOV     BX,S2PNT1
                                MOV     AL,[BX]
                                MOV     FRQAD2,AL
                                INC     BX
                                JMP     IRQS2B

DRR1:                   MOV     BX,DRPNT1
                                MOV     AL,[BX]
                                MOV     AH,220
                                MUL     AH
                                SHL     AX,1
                                SHL     AX,1
                                MOV     DRLENS,AX
                                INC     BX
                                JMP     IRQDRB1

DRR2:                   JMP     IRQDRB2

DRR3:                   MOV     AX,DRD1LN
                                MOV     DRHO,AX
                                MOV     AX,DRD1CL
                                MOV     DRCLL,AX
                                MOV     DRCLS,AX
                                MOV     AX,OFFSET DRM1
                                MOV     DRJMP,AX
                                JMP     IRQDRB2

DRR4:                   MOV     AX,DRD2LN
                                MOV     DRHO,AX
                                MOV     AX,DRD2CL
                                MOV     DRCLL,AX
                                MOV     DRCLS,AX
                                MOV     AX,100H
                                MOV     DRRCN,AX
                                MOV     AX,OFFSET DRM2
                                MOV     DRJMP,AX
                                JMP     IRQDRB2

DRR5:                   MOV     AX,DRD3LN
                                MOV     DRHO,AX
                                MOV     AX,DRD3CL
                                MOV     DRCLL,AX
                                MOV     DRCLS,AX
                                MOV     AX,100H
                                MOV     DRRCN,AX
                                MOV     AX,OFFSET DRM3
                                MOV     DRJMP,AX
                                JMP     IRQDRB2

DRM1:                   DEC     DRCLS
                                JNZ     DRM1A
                                INC     DRCLS
DRM1A:          MOV     AL,0B0H
                                OUT     43H,AL
                                MOV     AL,BYTE PTR DRCLS
                                XOR     AH,AH
                                SHL     AX,1
                                SHL     AX,1
                                SHL     AX,1
                                MOV     BX,AX
                                SHL     AX,1
                                SHL     AX,1
                                ADD     AX,BX
                                OUT     42H,AL
                                MOV     AL,AH
                                OUT     42H,AL
                                MOV     AL,23H
                                OUT     61H,AL
                                RETN

DRM2:                   MOV     AL,0B0H
                                OUT     43H,AL
                                MOV     BX,DRRCN
                                INC     DRRCN
                                MOV     AX,[BX]
                                AND     AX,1FFH
                                OUT     42H,AL
                                MOV     AL,AH
                                OUT     42H,AL
                                MOV     AL,23H
                                OUT     61H,AL
                                RETN

DRM3:                   MOV     AL,0B0H
                                OUT     43H,AL
                                MOV     BX,DRRCN
                                INC     DRRCN
                                MOV     AX,[BX]
                                AND     AX,0FFH
                                OUT     42H,AL
                                MOV     AL,AH
                                OUT     42H,AL
                                MOV     AL,23H
                                OUT     61H,AL
                                RETN


S1FRQ                   DB      0
S1FRQS          DB      0
S1SQ                    DW      0
S1LEN                   DW      1
S1LENS          DW      0
S1PNT1          DW      OFFSET DB128
S1PNT2          DW      OFFSET SND1
S1DEC                   DW      0
S1DECS          DW      0

S2FRQ           DB      0
S2FRQS          DB      0
S2SQ                    DW      0
S2LEN                   DW      1
S2LENS          DW      0
S2PNT1          DW      OFFSET DB128
S2PNT2          DW      OFFSET SND2
S2DEC                   DW      0
S2DECS          DW      0

DRLEN                   DW      1
DRLENS          DW      0
DRPNT1          DW      OFFSET DB128
DRPNT2          DW      OFFSET DRUMS
DRJMP                   DW      0
DRRCN                   DW      0
DRHO                    DW      0
DRCLL                   DW      0
DRCLS                   DW      0

DRD1LN          DW      180
DRD1CL          DW      18
DRD2LN          DW      130
DRD2CL          DW      1
DRD3LN          DW      100
DRD3CL          DW      6

JPTBL1:         DW      OFFSET S1R1,OFFSET S1R2,OFFSET S1R3,OFFSET S1R4
JPTBL2:         DW      OFFSET S2R1,OFFSET S2R2,OFFSET S2R3,OFFSET S2R4
DRJPT:          DW      OFFSET DRR1,OFFSET DRR2,OFFSET DRR3,OFFSET DRR4,OFFSET DRR5

FRQAD1          DB      0
FRQAD2          DB      0
FRQTBL:         DB      0EEH,0E1H,0D4H,0C8H,0BDH,0B2H,0A8H,09FH
                                DB      096H,08EH,086H,07EH,077H,070H,06AH,064H
                                DB      05EH,059H,054H,04FH,04BH,047H,043H,03FH
                                DB      03BH,038H,035H,032H,02FH,02CH,02AH,027H
                                DB      025H,023H,021H,01FH,01DH,01CH,01AH,019H
                                DB      017H,016H,015H,013H,012H,011H,010H,00FH
                                DB      00EH,00EH,00DH,00CH,00BH,00BH,00AH,009H
                                DB      009H,008H,008H,007H

DB128:          DB      80H

SND1:                   DW      OFFSET S1T1,OFFSET S1T2,OFFSET S1T3,OFFSET S1T3
                                DW      OFFSET S1T4,OFFSET S1T4,OFFSET S1T3,OFFSET S1T3
                                DW      OFFSET S1T4,OFFSET S1T4,OFFSET S1T3,OFFSET S1T3
                                DW      OFFSET S1T4,OFFSET S1T4,OFFSET S1T3,OFFSET S1T3
                                DW      OFFSET S1T4,OFFSET S1T4,OFFSET S1T5,OFFSET S1T5
                                DW      OFFSET S1T6,OFFSET S1T6,OFFSET S1T5,OFFSET S1T5
                                DW      OFFSET S1T6,OFFSET S1T6,OFFSET S1T7,OFFSET S1T5
                                DW      OFFSET S1T5,OFFSET S1T6,OFFSET S1T6,OFFSET S1T5
                                DW      OFFSET S1T5,OFFSET S1T6,OFFSET S1T6,OFFSET S1T8
                                DW      OFFSET S1T5,OFFSET S1T5,OFFSET S1T6,OFFSET S1T6
                                DW      OFFSET S1T5,OFFSET S1T5,OFFSET S1T6,OFFSET S1T6
                                DW      OFFSET S1T7,OFFSET S1T6,OFFSET S1T6,OFFSET S1T9
                                DW      OFFSET S1T9,OFFSET S1T6,OFFSET S1T6,OFFSET S1T9
                                DW      OFFSET S1T9,OFFSET S1T6,OFFSET S1T6,OFFSET S1T9
                                DW      OFFSET S1T9,OFFSET S1T6,OFFSET S1T6,OFFSET S1T9
                                DW      OFFSET S1T9,0,OFFSET SND1

SND2:                   DW      OFFSET S2T1,OFFSET S2T1,OFFSET S2T2,OFFSET S2T2
                                DW      OFFSET S2T3,OFFSET S2T4,OFFSET S2T4,OFFSET S2T6
                                DW      OFFSET S2T6,OFFSET S2T6,OFFSET S2T6,OFFSET S2T7
                                DW      OFFSET S2T6,OFFSET S2T6,OFFSET S2T6,OFFSET S2T6
                                DW      OFFSET S2T8,OFFSET S2T9,OFFSET S2T9,OFFSET S2T7
                                DW      OFFSET S2T10,OFFSET S2T8,0,OFFSET SND2

DRUMS:          DW      OFFSET DRT1,OFFSET DRT2,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,OFFSET DRT3,OFFSET DRT3
                                DW      OFFSET DRT3,OFFSET DRT3,0,OFFSET DRUMS

;SND1:
;SND2:                  DW      OFFSET STP,0,OFFSET SND1
;STP:                   DB      83H,40H,81H,81H,81H,81H,80H

S1T1:                   DB      82H,6,83H,40H,9,9,9,9,80H
S2T3:
S1T2:                   DB      83H,8,81H,80H
S1T3:                   DB      82H,1,83H,2,9,83H,1,18H,81H,1CH,81H,18H,81H,83H,2
                                DB      9,83H,1,18H,81H,1CH,81H,18H,81H,83H,2,9,83H,1,18H
                                DB      81H,1CH,81H,18H,81H,83H,2,13H,83H,1,18H,81H,1CH,81H,18H
                                DB      81H,80H
S1T4:                   DB      82H,1,83H,2,0,83H,1,1CH,81H,1FH,81H,1CH,81H,83H
                                DB      2,0,83H,1,1CH,81H,1FH,81H,1CH,81H,83H,2,0,83H
                                DB      1,1CH,81H,1FH,81H,1CH,81H,83H,2,17H,83H,1,1CH,81H
                                DB      1FH,81H,1CH,81H,80H
S1T5:                   DB      82H,1,83H,1,9,81H,9,81H,9,81H,9,81H,9,81H
                                DB      9,81H,9,81H,9,81H,9,81H,9,81H,9,81H,9,81H
                                DB      9,81H,9,81H,9,81H,7,81H,80H
S1T6:                   DB      82H,1,83H,1,0,81H,0,81H,0,81H,0,81H,0,81H
                                DB      0,81H,0,81H,0,81H,0,81H,0,81H,0,81H,0,81H
                                DB      0,81H,0,81H,0,81H,0BH,81H,80H
S2T7:
S1T7:                   DB      84H,01H,80H
S2T8:
S1T8:                   DB      84H,0,80H
S1T9:                   DB      82H,1,83H,1,5,81H,5,81H,5,81H,5,81H,5,81H
                                DB      5,81H,5,81H,5,81H,5,81H,5,81H,5,81H,5,81H
                                DB      5,81H,5,81H,5,81H,4,81H,80H

S2T1:                   DB      82H,1,83H,1,18H,81H,18H,81H,15H,81H,15H,81H,10H,81H
                                DB      10H,81H,18H,81H,18H,81H,15H,81H,15H,81H,10H,81H,10H,81H
                                DB      17H,81H,17H,81H,13H,81H,13H,81H,0EH,81H,0EH,81H,17H,81H
                                DB      17H,81H,13H,81H,13H,81H,0EH,81H,0EH,81H,15H,81H,15H,81H
                                DB      11H,81H,11H,81H,0CH,81H,0CH,81H,11H,81H,11H,81H,80H
S2T2:                   DB      0CH,81H,0CH,81H,9,81H,9,81H,4,81H,4,81H,0CH,81H
                                DB      0CH,81H,9,81H,9,81H,4,81H,4,81H,0BH,81H,0BH,81H
                                DB      7,81H,7,81H,2,81H,2,81H,0BH,81H,0BH,81H,7,81H
                                DB      7,81H,2,81H,2,81H,9,81H,9,81H,5,81H,5,81H
                                DB      0,81H,0,81H,5,81H,5,81H,80H
S2T4:                   DB      82H,2,83H,1CH,4,83H,4,7,83H,1CH
                                DB      9,83H,4,0BH,83H,1AH,0CH,83H,1,0DH,0EH
                                DB      0FH,10H,11H,12H,83H,20H,13H,82H,3,83H,1CH
                                DB      18H,83H,4,17H,83H,1CH,13H,83H,4,15H,83H
                                DB      34H,10H,83H,1,0FH,0EH,0DH,0CH,0BH,0AH,09H,08H
                                DB      07H,06H,05H,04H,80H
S2T6:                   DB      82H,1,83H,0BH,10H,83H,1,81H,83H,7
                                DB      9,83H,1,81H,83H,3,9,83H,1,81H,83H
                                DB      0BH,10H,83H,1,81H,83H,7,9,83H,1
                                DB      81H,83H,7,9,83H,1,81H,83H,3,9,83H,1,81H,83H,3,0CH,83H
                                DB      1,81H,83H,3,0EH,83H,1,81H,80H
S2T9:                   DB      82H,1,83H,1,15H,81H,15H,81H,15H,81H,15H,81H,15H
                                DB      81H,15H,81H,13H,81H,13H,81H,13H,81H,13H,81H,13H,81H,13H
                                DB      81H,15H,81H,15H,81H,15H,81H,15H,81H,15H,81H,15H,81H,13H
                                DB      81H,13H,81H,13H,81H,13H,81H,15H,81H,15H,81H,15H,81H,15H
                                DB      81H,13H,81H,13H,81H,15H,81H,15H,81H,16H,81H,16H,81H,15H
                                DB      81H,15H,81H,15H,81H,15H,81H,15H,81H,15H,81H,13H
                                DB      81H,13H,81H,13H,81H,13H,81H,13H,81H,13H,81H,15H,81H,15H
                                DB      81H,15H,81H,15H,81H,15H,81H,15H,81H,13H,81H,13H,81H,13H
                                DB      81H,13H,81H,15H,81H,15H,81H,15H,81H,15H,81H,13H
                                DB      81H,13H,81H,15H,81H,15H,81H,16H,81H,16H,81H,80H
S2T10:          DB      82H,5,83H,3CH,13H,83H,4,14H,83H,3CH
                                DB      15H,83H,4,14H,83H,3CH,13H,83H,4,14H,83H
                                DB      3CH,15H,83H,4,14H,83H,3CH,13H,83H,4
                                DB      12H,83H,3CH,11H,83H,4,12H,83H,3CH,13H,83H
                                DB      4,12H,83H,3CH,11H,83H,4,12H,80H

DRT1:                   DB      0,40H,1,1,1,1,80H
DRT2:                   DB      0,8,1,0,4,80H
DRT3:                   DB      2,3,4,2,3,4,3,4,80H

;----------------------------------------------------------

KEP:                    DB      17489 DUP (0)

;----------------------------------------------------------

INIT:
                                MOV     DX,OFFSET FCIM2
                                MOV     AX,3D00H
                                INT     21H
                                MOV     BX,AX
                                MOV     DX,OFFSET CHRSET
                                MOV     CX,512
                                MOV     AH,3FH
                                INT     21H
                                MOV     AH,3EH
                                INT     21H

                                MOV     DX,OFFSET FCIM3
                                MOV     AX,3D00H
                                INT     21H
                                MOV     BX,AX
                                MOV     DX,OFFSET KEP
                                MOV     CX,17489
                                MOV     AH,3FH
                                INT     21H
                                MOV     AH,3EH
                                INT     21H

                                CALL    IXOROL
                                
                                MOV     DI,100H
                                MOV     [DI],35EBH
                                MOV     BYTE PTR [DI+2],13

                                MOV     AH,3CH
                                MOV     DX,OFFSET FCIM0
                                XOR     CX,CX
                                INT     21H
                                MOV     BX,AX
                                MOV     AH,40H
                                MOV     DX,100H
                                MOV     CX,OFFSET INIT-256
                                INT     21H
                                MOV     AH,3EH
                                INT     21H

                                INT     20H

FCIM0:          DB      'MDPART3.COM',0
FCIM2:          DB      'ARKANOID.FNT',0
FCIM3:          DB      'CREDIT.SUP',0

COMALAP ENDP

SEG_A           ENDS

END START
