#define _O3D_C

#include "o3d.h"

#define MAX_NBVERTS	1000
#define MAX_NBOBJS	50
#define MAX_PRIMS	1024

LINE_F2		prim_lf2[MAX_PRIMS];
LINE_F3		prim_lf3[MAX_PRIMS];
LINE_F4		prim_lf4[MAX_PRIMS];
LINE_G2		prim_lg2[MAX_PRIMS];
LINE_G3		prim_lg3[MAX_PRIMS];
LINE_G4		prim_lg4[MAX_PRIMS];
POLY_F3		prim_f3 [MAX_PRIMS];
POLY_F4		prim_f4 [MAX_PRIMS];
POLY_G3		prim_g3 [MAX_PRIMS];
POLY_G4		prim_g4 [MAX_PRIMS];
POLY_FT3	prim_ft3[MAX_PRIMS];
POLY_FT4	prim_ft4[MAX_PRIMS];
POLY_GT3	prim_gt3[MAX_PRIMS];
POLY_GT4	prim_gt4[MAX_PRIMS];

u_short	nb_lf2,nb_lf3,nb_lf4;
u_short nb_lg2,nb_lg3,nb_lg4;
u_short nb_f3,nb_f4,nb_g3,nb_g4;
u_short nb_ft3,nb_ft4,nb_gt3,nb_gt4;

#define MAX_BLUR 256
#define LEVEL_BLUR 3

LINE_F2		blur_lf2[LEVEL_BLUR][MAX_BLUR];
LINE_F3		blur_lf3[LEVEL_BLUR][MAX_BLUR];
LINE_F4		blur_lf4[LEVEL_BLUR][MAX_BLUR];
LINE_G2		blur_lg2[LEVEL_BLUR][MAX_BLUR];
LINE_G3		blur_lg3[LEVEL_BLUR][MAX_BLUR];
LINE_G4		blur_lg4[LEVEL_BLUR][MAX_BLUR];
POLY_F3		blur_f3 [LEVEL_BLUR][MAX_BLUR];
POLY_F4		blur_f4 [LEVEL_BLUR][MAX_BLUR];
POLY_G3		blur_g3 [LEVEL_BLUR][MAX_BLUR];
POLY_G4		blur_g4 [LEVEL_BLUR][MAX_BLUR];
POLY_FT3	blur_ft3[LEVEL_BLUR][MAX_BLUR];
POLY_FT4	blur_ft4[LEVEL_BLUR][MAX_BLUR];
POLY_GT3	blur_gt3[LEVEL_BLUR][MAX_BLUR];
POLY_GT4	blur_gt4[LEVEL_BLUR][MAX_BLUR];

u_short	blur_lf2_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_lf3_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_lf4_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_lg2_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_lg3_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_lg4_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_f3_idx [LEVEL_BLUR][MAX_BLUR];
u_short	blur_f4_idx [LEVEL_BLUR][MAX_BLUR];
u_short	blur_g3_idx [LEVEL_BLUR][MAX_BLUR];
u_short	blur_g4_idx [LEVEL_BLUR][MAX_BLUR];
u_short	blur_ft3_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_ft4_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_gt3_idx[LEVEL_BLUR][MAX_BLUR];
u_short	blur_gt4_idx[LEVEL_BLUR][MAX_BLUR];

u_short	mb_lf2[LEVEL_BLUR],mb_lf3[LEVEL_BLUR],mb_lf4[LEVEL_BLUR];
u_short mb_lg2[LEVEL_BLUR],mb_lg3[LEVEL_BLUR],mb_lg4[LEVEL_BLUR];
u_short mb_f3[LEVEL_BLUR],mb_f4[LEVEL_BLUR],mb_g3[LEVEL_BLUR],mb_g4[LEVEL_BLUR];
u_short mb_ft3[LEVEL_BLUR],mb_ft4[LEVEL_BLUR],mb_gt3[LEVEL_BLUR],mb_gt4[LEVEL_BLUR];
u_short mb_idx = 0;

u_short	ztex;

int min=5000;
u_char used[OTSIZE];
int max=-1;

void InitMBCount() {
	mb_lf2[mb_idx] = mb_lf3[mb_idx] = mb_lf4[mb_idx] = 0;
	mb_lg2[mb_idx] = mb_lg3[mb_idx] = mb_lg4[mb_idx] = 0;
	mb_f3[mb_idx] = mb_f4[mb_idx] = mb_g3[mb_idx] = mb_g4[mb_idx] =0;
	mb_ft3[mb_idx] = mb_ft4[mb_idx] = mb_gt3[mb_idx] = mb_gt4[mb_idx] =0;
}

void Init3DPrims() {
	int i,j;
	for (i=0;i<MAX_PRIMS;i++) {
		SetLineF2(&prim_lf2[i]);
		SetLineF3(&prim_lf3[i]);
		SetLineF4(&prim_lf4[i]);
		SetLineG2(&prim_lg2[i]);
		SetLineG3(&prim_lg3[i]);
		SetLineG4(&prim_lg4[i]);
		SetPolyF3(&prim_f3[i]);
		SetPolyF4(&prim_f4[i]);
		SetPolyG3(&prim_g3[i]);
		SetPolyG4(&prim_g4[i]);
		SetPolyFT3(&prim_ft3[i]);
		SetPolyFT4(&prim_ft4[i]);
		SetPolyGT3(&prim_gt3[i]);
		SetPolyGT4(&prim_gt4[i]);
	}
	for (j=0;j<LEVEL_BLUR;j++) {
		for (i=0;i<MAX_BLUR;i++) {
			SetLineF2(&blur_lf2[j][i]);
			SetLineF3(&blur_lf3[j][i]);
			SetLineF4(&blur_lf4[j][i]);
			SetLineG2(&blur_lg2[j][i]);
			SetLineG3(&blur_lg3[j][i]);
			SetLineG4(&blur_lg4[j][i]);
			SetPolyF3(&blur_f3[j][i]);
			SetPolyF4(&blur_f4[j][i]);
			SetPolyG3(&blur_g3[j][i]);
			SetPolyG4(&blur_g4[j][i]);
			SetPolyFT3(&blur_ft3[j][i]);
			SetPolyFT4(&blur_ft4[j][i]);
			SetPolyGT3(&blur_gt3[j][i]);
			SetPolyGT4(&blur_gt4[j][i]);
		}
		mb_lf2[j] = mb_lf3[j] = mb_lf4[j] = 0;
		mb_lg2[j] = mb_lg3[j] = mb_lg4[j] = 0;
		mb_f3[j] = mb_f4[j] = mb_g3[j] = mb_g4[j] =0;
		mb_ft3[j] = mb_ft4[j] = mb_gt3[j] = mb_gt4[j] =0;
	}
	ztex = 0;
	InitMBCount();
}

void InitUV(SObject *sobj,int d,TPolyData *data) {
	RECT r;
	int id = sobj->texID[data->texID],i;
	regRect(id,&r);
	for (i=0;i<d;i++) {
		data->u[i] += (r.x%64)/regMode(id);
		data->v[i] += r.y%256;
	}
}

void ChangeTex(SObject *sobj,int f,int tex) {
	RECT rold,rnew;
	TPolyData *data = (TPolyData*)sobj->data[f];
	int d = sobj->pdim[f],i;
	int id1 = sobj->texID[data->texID];
	int id2 = sobj->texID[tex];
	regRect(id1,&rold);
	regRect(id2,&rnew);
	for (i=0;i<d;i++) {
		data->u[i] = data->u[i] - ((rold.x%64)/regMode(id1)) + ((rnew.x%64)/regMode(id2));
		data->v[i] = data->v[i] - (rold.y%256) + (rnew.y%256);
	}
	data->texID = tex;
}

void InitObjPos(ObjPos *pos,Object3D *obj,long x,long y,long z,short ax,short ay,short az,long sc) {
	pos->obj = obj;
	pos->pos.vx = x;
	pos->pos.vy = y;
	pos->pos.vz = z;
	pos->ang.vx = ax;
	pos->ang.vy = ay;
	pos->ang.vz = az;
	pos->scale.vx = pos->scale.vy = pos->scale.vz = sc;
}

void InitSObject(Object3D *obj) {
	int i,a,b,c;
	VECTOR v;
	long s;
	SObject *sobj = obj->o.single;

	for (i=0;i<sobj->nbv;i++) {
		sobj->v_normals[i].vx = 0;
		sobj->v_normals[i].vy = 0;
		sobj->v_normals[i].vz = 0;
	}

	for (i=0;i<sobj->nbt;i++) sobj->texID[i] = regTex(sobj->tex[i]);

	obj->flags = 0;
	for (i=0;i<sobj->nbp;i++) {
		if (sobj->pdim[i]<3) continue;
		if (((sobj->ptype[i]&0x07) == TYPE_FT) || ((sobj->ptype[i]&0x07) == TYPE_GT))
			InitUV(sobj,sobj->pdim[i],(TPolyData*)sobj->data[i]);
		obj->flags |= sobj->ptype[i]&FLAG_L;
		a = sobj->polys[i][0];
		b = sobj->polys[i][1];
		c = sobj->polys[i][2];
		v.vx = ((sobj->vert[c].vy-sobj->vert[b].vy)*(sobj->vert[b].vz-sobj->vert[a].vz))-((sobj->vert[c].vz-sobj->vert[b].vz)*(sobj->vert[b].vy-sobj->vert[a].vy));
		v.vy = ((sobj->vert[c].vz-sobj->vert[b].vz)*(sobj->vert[b].vx-sobj->vert[a].vx))-((sobj->vert[c].vx-sobj->vert[b].vx)*(sobj->vert[b].vz-sobj->vert[a].vz));
		v.vz = ((sobj->vert[c].vx-sobj->vert[b].vx)*(sobj->vert[b].vy-sobj->vert[a].vy))-((sobj->vert[c].vy-sobj->vert[b].vy)*(sobj->vert[b].vx-sobj->vert[a].vx));
		s = SquareRoot0(v.vx*v.vx+v.vy*v.vy+v.vz*v.vz);
		if (s==0) s=1;
		sobj->f_normals[i].vx = (590*v.vx)/s;
		sobj->f_normals[i].vy = (590*v.vy)/s;
		sobj->f_normals[i].vz = (590*v.vz)/s;

		sobj->v_normals[a].vx += sobj->f_normals[i].vx;
		sobj->v_normals[a].vy += sobj->f_normals[i].vy;
		sobj->v_normals[a].vz += sobj->f_normals[i].vz;

		sobj->v_normals[b].vx += sobj->f_normals[i].vx;
		sobj->v_normals[b].vy += sobj->f_normals[i].vy;
		sobj->v_normals[b].vz += sobj->f_normals[i].vz;

		sobj->v_normals[c].vx += sobj->f_normals[i].vx;
		sobj->v_normals[c].vy += sobj->f_normals[i].vy;
		sobj->v_normals[c].vz += sobj->f_normals[i].vz;

		if (sobj->pdim[i]<4) continue;

		a = sobj->polys[i][3];
		sobj->v_normals[a].vx += sobj->f_normals[i].vx;
		sobj->v_normals[a].vy += sobj->f_normals[i].vy;
		sobj->v_normals[a].vz += sobj->f_normals[i].vz;
	}
	for (i=0;i<sobj->nbv;i++) {
		s = SquareRoot0(sobj->v_normals[i].vx*sobj->v_normals[i].vx+sobj->v_normals[i].vy*sobj->v_normals[i].vy+sobj->v_normals[i].vz*sobj->v_normals[i].vz);
		if (s==0) s=1;
		sobj->v_normals[i].vx = (590*sobj->v_normals[i].vx)/s;
		sobj->v_normals[i].vy = (590*sobj->v_normals[i].vy)/s;
		sobj->v_normals[i].vz = (590*sobj->v_normals[i].vz)/s;
	}
}

long PrepareLight(VECTOR *light,VECTOR *norm) {
	VECTOR v;
	v.vx = norm->vx+light->vx;
	v.vy = norm->vy+light->vy;
	v.vz = norm->vz+light->vz;
	return SquareRoot0(v.vx*v.vx+v.vy*v.vy+v.vz*v.vz)>>1;
}

void CalcLight(long s,Color *col,Color *ret) {
	long r,g,b;
	r = (s*col->r)>>10;
	g = (s*col->g)>>10;
	b = (s*col->b)>>10;
	ret->r = r > 255 ? 255 : r;
	ret->g = g > 255 ? 255 : g;
	ret->b = b > 255 ? 255 : b;
}

void CalcFlatLight(VECTOR *light,VECTOR *norm,Color *col,Color *ret) {
	long s,r,g,b;
	static VECTOR v;
	v.vx = norm->vx+light->vx;
	v.vy = norm->vy+light->vy;
	v.vz = norm->vz+light->vz;
	s = SquareRoot0(v.vx*v.vx+v.vy*v.vy+v.vz*v.vz)>>1;
	r = (s*col->r)>>10;
	g = (s*col->g)>>10;
	b = (s*col->b)>>10;
	ret->r = r > 255 ? 255 : r;
	ret->g = g > 255 ? 255 : g;
	ret->b = b > 255 ? 255 : b;
}


void InitCount() {
	nb_lf2 = nb_lf3 = nb_lf4 = 0;
	nb_lg2 = nb_lg3 = nb_lg4 = 0;
	nb_f3 = nb_f4 = nb_g3 = nb_g4 =0;
	nb_ft3 = nb_ft4 = nb_gt3 = nb_gt4 =0;
}

DVECTOR	Mesh[MAX_NBVERTS];
VECTOR	trans;
VECTOR	vnorm[MAX_NBVERTS];
long	slight[MAX_NBVERTS];
VECTOR	llight;
Color	white = {127,127,127};

void InitLineF2(LINE_F2 *icell,short x0,short y0,short x1,short y1,u_char r0,u_char g0,u_char b0) {
	setXY2(icell,x0,y0,x1,y1);
	setRGB0(icell,r0,g0,b0);
}

void InitLineF3(LINE_F3 *icell,short x0,short y0,short x1,short y1,short x2,short y2,u_char r0,u_char g0,u_char b0) {
	setXY3(icell,x0,y0,x1,y1,x2,y2);
	setRGB0(icell,r0,g0,b0);
}

void InitLineF4(LINE_F4 *icell,short x0,short y0,short x1,short y1,short x2,short y2,short x3,short y3,u_char r0,u_char g0,u_char b0) {
	setXY4(icell,x0,y0,x1,y1,x2,y2,x3,y3);
	setRGB0(icell,r0,g0,b0);
}

void InitLineG2(LINE_G2 *icell,short x0,short y0,short x1,short y1,u_char r0,u_char g0,u_char b0,u_char r1,u_char g1,u_char b1) {
	setXY2(icell,x0,y0,x1,y1);
	setRGB0(icell,r0,g0,b0);
	setRGB1(icell,r1,g1,b1);
}

void InitLineG3(LINE_G3 *icell,short x0,short y0,short x1,short y1,short x2,short y2,u_char r0,u_char g0,u_char b0,u_char r1,u_char g1,u_char b1,u_char r2,u_char g2,u_char b2) {
	setXY3(icell,x0,y0,x1,y1,x2,y2);
	setRGB0(icell,r0,g0,b0);
	setRGB1(icell,r1,g1,b1);
	setRGB2(icell,r2,g2,b2);
}

void InitLineG4(LINE_G4 *icell,short x0,short y0,short x1,short y1,short x2,short y2,short x3,short y3,u_char r0,u_char g0,u_char b0,u_char r1,u_char g1,u_char b1,u_char r2,u_char g2,u_char b2,u_char r3,u_char g3,u_char b3) {
	setXY4(icell,x0,y0,x1,y1,x2,y2,x3,y3);
	setRGB0(icell,r0,g0,b0);
	setRGB1(icell,r1,g1,b1);
	setRGB2(icell,r2,g2,b2);
	setRGB3(icell,r3,g3,b3);
}

void InitPolyF3(POLY_F3 *icell,short x0,short y0,short x1,short y1,short x2,short y2,u_char r0,u_char g0,u_char b0) {
	setXY3(icell,x0,y0,x1,y1,x2,y2);
	setRGB0(icell,r0,g0,b0);
}

void InitPolyF4(POLY_F4 *icell,short x0,short y0,short x1,short y1,short x2,short y2,short x3,short y3,u_char r0,u_char g0,u_char b0) {
	setXY4(icell,x0,y0,x1,y1,x2,y2,x3,y3);
	setRGB0(icell,r0,g0,b0);
}

void InitPolyG3(POLY_G3 *icell,short x0,short y0,short x1,short y1,short x2,short y2,u_char r0,u_char g0,u_char b0,u_char r1,u_char g1,u_char b1,u_char r2,u_char g2,u_char b2) {
	setXY3(icell,x0,y0,x1,y1,x2,y2);
	setRGB0(icell,r0,g0,b0);
	setRGB1(icell,r1,g1,b1);
	setRGB2(icell,r2,g2,b2);
}

void InitPolyG4(POLY_G4 *icell,short x0,short y0,short x1,short y1,short x2,short y2,short x3,short y3,u_char r0,u_char g0,u_char b0,u_char r1,u_char g1,u_char b1,u_char r2,u_char g2,u_char b2,u_char r3,u_char g3,u_char b3) {
	setXY4(icell,x0,y0,x1,y1,x2,y2,x3,y3);
	setRGB0(icell,r0,g0,b0);
	setRGB1(icell,r1,g1,b1);
	setRGB2(icell,r2,g2,b2);
	setRGB3(icell,r3,g3,b3);
}

void InitPolyFT3(POLY_FT3 *icell,short x0,short y0,short x1,short y1,short x2,short y2,u_char r0,u_char g0,u_char b0,u_char u0,u_char v0,u_char u1,u_char v1,u_char u2,u_char v2,u_short tpage,u_short clut,u_char rtl) {
	setXY3(icell,x0,y0,x1,y1,x2,y2);
	setRGB0(icell,r0,g0,b0);
	setUV3(icell,u0,v0,u1,v1,u2,v2);
	icell->tpage = tpage;
	icell->clut = clut;
	SetShadeTex(icell, !rtl);
}

void InitPolyFT4(POLY_FT4 *icell,short x0,short y0,short x1,short y1,short x2,short y2,short x3,short y3,u_char r0,u_char g0,u_char b0,u_char u0,u_char v0,u_char u1,u_char v1,u_char u2,u_char v2,u_char u3,u_char v3,u_short tpage,u_short clut,u_char rtl) {
	setXY4(icell,x0,y0,x1,y1,x2,y2,x3,y3);
	setRGB0(icell,r0,g0,b0);
	setUV4(icell,u0,v0,u1,v1,u2,v2,u3,v3);
	icell->tpage = tpage;
	icell->clut = clut;
	SetShadeTex(icell, !rtl);
}

void InitPolyGT3(POLY_GT3 *icell,short x0,short y0,short x1,short y1,short x2,short y2,u_char r0,u_char g0,u_char b0,u_char r1,u_char g1,u_char b1,u_char r2,u_char g2,u_char b2,u_char u0,u_char v0,u_char u1,u_char v1,u_char u2,u_char v2,u_short tpage,u_short clut) {
	setXY3(icell,x0,y0,x1,y1,x2,y2);
	setRGB0(icell,r0,g0,b0);
	setRGB1(icell,r1,g1,b1);
	setRGB2(icell,r2,g2,b2);
	setUV3(icell,u0,v0,u1,v1,u2,v2);
	icell->tpage = tpage;
	icell->clut = clut;
}

void InitPolyGT4(POLY_GT4 *icell,short x0,short y0,short x1,short y1,short x2,short y2,short x3,short y3,u_char r0,u_char g0,u_char b0,u_char r1,u_char g1,u_char b1,u_char r2,u_char g2,u_char b2,u_char r3,u_char g3,u_char b3,u_char u0,u_char v0,u_char u1,u_char v1,u_char u2,u_char v2,u_char u3,u_char v3,u_short tpage,u_short clut) {
	setXY4(icell,x0,y0,x1,y1,x2,y2,x3,y3);
	setRGB0(icell,r0,g0,b0);
	setRGB1(icell,r1,g1,b1);
	setRGB2(icell,r2,g2,b2);
	setRGB3(icell,r3,g3,b3);
	setUV4(icell,u0,v0,u1,v1,u2,v2,u3,v3);
	icell->tpage = tpage;
	icell->clut = clut;
}

void SetPrim(u_short idx,u_long *ot,int f,SObject *obj,int semi,int mb) {
	void *prim;

	u_short *poly = obj->polys[f];
	u_short dim = obj->pdim[f];
	u_char	type  = obj->ptype[f];
	u_char	rtl = (type & FLAG_L)!=0;
	u_char	st = (type & FLAG_S)!=0 || semi;
	type = type & 0x7;

	if (idx<min) min=idx;
	//while (idx>0 && used[idx]>8) idx--;
	//while (used[idx]>8) idx++;
	used[idx]=1;
	if (idx>max) max=idx;

	switch(type) {
		case TYPE_LINE_F: {
			Color *data = (Color*)obj->data[f];
			if (dim==2) {
				LINE_F2 *icell = prim = &prim_lf2[nb_lf2++];
				InitLineF2(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   data->r, data->g, data->b);
				if (mb) {
					InitLineF2(&blur_lf2[mb_idx][mb_lf2[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->r0,icell->g0,icell->b0);
					SetSemiTrans(&blur_lf2[mb_idx][mb_lf2[mb_idx]],1);
					blur_lf2_idx[mb_idx][mb_lf2[mb_idx]++] = idx;
				}
			} else if (dim==3) {
				LINE_F3 *icell = prim = &prim_lf3[nb_lf3++];
				InitLineF3(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
					   data->r, data->g, data->b);
				if (mb) {
					InitLineF3(&blur_lf3[mb_idx][mb_lf3[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->x2,icell->y2,
						   icell->r0,icell->g0,icell->b0);
					SetSemiTrans(&blur_lf3[mb_idx][mb_lf3[mb_idx]],1);
					blur_lf3_idx[mb_idx][mb_lf3[mb_idx]++] = idx;
				}
			} else { // 4
				LINE_F4 *icell = prim = &prim_lf4[nb_lf4++];
				InitLineF4(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
					   Mesh[poly[3]].vx, Mesh[poly[3]].vy,
					   data->r, data->g, data->b);
				if (mb) {
					InitLineF4(&blur_lf4[mb_idx][mb_lf4[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->x2,icell->y2,
						   icell->x3,icell->y3,
						   icell->r0,icell->g0,icell->b0);
					SetSemiTrans(&blur_lf4[mb_idx][mb_lf4[mb_idx]],1);
					blur_lf4_idx[mb_idx][mb_lf4[mb_idx]++] = idx;
				}
			}
			} break;

		case TYPE_LINE_G: {
			Color **data = (Color**)obj->data[f];
			if (dim==2) {
				LINE_G2 *icell = prim = &prim_lg2[nb_lg2++];
				InitLineG2(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   data[0]->r, data[0]->g, data[0]->b,
					   data[1]->r, data[1]->g, data[1]->b);
				if (mb) {
					InitLineG2(&blur_lg2[mb_idx][mb_lg2[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->r0,icell->g0,icell->b0,
						   icell->r1,icell->g1,icell->b1);
					SetSemiTrans(&blur_lg2[mb_idx][mb_lg2[mb_idx]],1);
					blur_lg2_idx[mb_idx][mb_lg2[mb_idx]++] = idx;
				}
			} else if (dim==3) {
				LINE_G3 *icell = prim = &prim_lg3[nb_lg3++];
				InitLineG3(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
					   data[0]->r, data[0]->g, data[0]->b,
					   data[1]->r, data[1]->g, data[1]->b,
					   data[2]->r, data[2]->g, data[2]->b);
				if (mb) {
					InitLineG3(&blur_lg3[mb_idx][mb_lg3[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->x2,icell->y2,
						   icell->r0,icell->g0,icell->b0,
						   icell->r1,icell->g1,icell->b1,
						   icell->r2,icell->g2,icell->b2);
					SetSemiTrans(&blur_lg3[mb_idx][mb_lg3[mb_idx]],1);
					blur_lg3_idx[mb_idx][mb_lg3[mb_idx]++] = idx;
				}
			} else { // 4
				LINE_G4 *icell = prim = &prim_lg4[nb_lg4++];
				InitLineG4(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
					   Mesh[poly[3]].vx, Mesh[poly[3]].vy,
					   data[0]->r, data[0]->g, data[0]->b,
					   data[1]->r, data[1]->g, data[1]->b,
					   data[2]->r, data[2]->g, data[2]->b,
					   data[3]->r, data[3]->g, data[3]->b);
				if (mb) {
					InitLineG4(&blur_lg4[mb_idx][mb_lg4[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->x2,icell->y2,
						   icell->x3,icell->y3,
						   icell->r0,icell->g0,icell->b0,
						   icell->r1,icell->g1,icell->b1,
						   icell->r2,icell->g2,icell->b2,
						   icell->r3,icell->g3,icell->b3);
					SetSemiTrans(&blur_lg4[mb_idx][mb_lg4[mb_idx]],1);
					blur_lg4_idx[mb_idx][mb_lg4[mb_idx]++] = idx;
				}
			}
			} break;

		case TYPE_F: {
			Color *data = (Color*)obj->data[f];
			Color col;
			if (rtl)
			{
				CalcFlatLight(&llight,&trans,data,&col);
				data = &col;
			}
			if (dim==3) {
				POLY_F3 *icell = prim = &prim_f3[nb_f3++];
				InitPolyF3(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
					   data->r, data->g, data->b);
				if (mb) {
					InitPolyF3(&blur_f3[mb_idx][mb_f3[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->x2,icell->y2,
						   icell->r0,icell->g0,icell->b0);
					SetSemiTrans(&blur_f3[mb_idx][mb_f3[mb_idx]],1);
					blur_f3_idx[mb_idx][mb_f3[mb_idx]++] = idx;
				}
			} else { // Quadrangle
				POLY_F4 *icell = prim = &prim_f4[nb_f4++];
				InitPolyF4(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
					   Mesh[poly[3]].vx, Mesh[poly[3]].vy,
					   data->r, data->g, data->b);
				if (mb) {
					InitPolyF4(&blur_f4[mb_idx][mb_f4[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->x2,icell->y2,
						   icell->x3,icell->y3,
						   icell->r0,icell->g0,icell->b0);
					SetSemiTrans(&blur_f4[mb_idx][mb_f4[mb_idx]],1);
					blur_f4_idx[mb_idx][mb_f4[mb_idx]++] = idx;
				}
			}
			} break;

		case TYPE_G: {
			Color *data = (Color*)obj->data[f];
			Color col[4];
			if (rtl) {
				int i;
				for (i=0;i<dim;i++)
					CalcLight(slight[poly[i]],&data[i],&col[i]);
				data = col;
			}
			if (dim==3) {
				POLY_G3 *icell = prim = &prim_g3[nb_g3++];
				InitPolyG3(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
					   data[0].r, data[0].g, data[0].b,
					   data[1].r, data[1].g, data[1].b,
					   data[2].r, data[2].g, data[2].b);
				if (mb) {
					InitPolyG3(&blur_g3[mb_idx][mb_g3[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->x2,icell->y2,
						   icell->r0,icell->g0,icell->b0,
						   icell->r1,icell->g1,icell->b1,
						   icell->r2,icell->g2,icell->b2);
					SetSemiTrans(&blur_g3[mb_idx][mb_g3[mb_idx]],1);
					blur_g3_idx[mb_idx][mb_g3[mb_idx]++] = idx;
				}
			} else { // Quadrangle
				POLY_G4 *icell = prim = &prim_g4[nb_g4++];
				InitPolyG4(icell,
					   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
					   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
					   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
					   Mesh[poly[3]].vx, Mesh[poly[3]].vy,
					   data[0].r, data[0].g, data[0].b,
					   data[1].r, data[1].g, data[1].b,
					   data[2].r, data[2].g, data[2].b,
					   data[3].r, data[3].g, data[3].b);
				if (mb) {
					InitPolyG4(&blur_g4[mb_idx][mb_g4[mb_idx]],
						   icell->x0,icell->y0,
						   icell->x1,icell->y1,
						   icell->x2,icell->y2,
						   icell->x3,icell->y3,
						   icell->r0,icell->g0,icell->b0,
						   icell->r1,icell->g1,icell->b1,
						   icell->r2,icell->g2,icell->b2,
						   icell->r3,icell->g3,icell->b3);
					SetSemiTrans(&blur_g4[mb_idx][mb_g4[mb_idx]],1);
					blur_g4_idx[mb_idx][mb_g4[mb_idx]++] = idx;
				}
			}
			} break;

		case TYPE_FT: {
			TPolyData *data = (TPolyData*)obj->data[f];
			static Color col;
			Color *color = data->color;
			if (rtl)
			{
				CalcFlatLight(&llight,&trans,(idx > ztex ? &white : color),&col);
				color = &col;
			}
			if (dim==3) {
				if (idx > ztex) {
					POLY_FT3 *icell = prim = &prim_ft3[nb_ft3++];
					InitPolyFT3(icell,
						   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
						   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
						   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
						   color->r, color->g, color->b,
						   data->u[0],data->v[0],
						   data->u[1],data->v[1],
						   data->u[2],data->v[2],
						   regTPage(obj->texID[data->texID]),
						   regClut(obj->texID[data->texID]),
						   !rtl);
					if (mb) {
						InitPolyFT3(&blur_ft3[mb_idx][mb_ft3[mb_idx]],
							    icell->x0,icell->y0,
							    icell->x1,icell->y1,
							    icell->x2,icell->y2,
							    icell->r0,icell->g0,icell->b0,
							    icell->u0,icell->v0,
							    icell->u1,icell->v1,
							    icell->u2,icell->v2,
							    icell->tpage,icell->clut,!rtl);
						SetSemiTrans(&blur_ft3[mb_idx][mb_ft3[mb_idx]],1);
						blur_ft3_idx[mb_idx][mb_ft3[mb_idx]++] = idx;
					}
				} else {
					POLY_F3 *icell = prim = &prim_f3[nb_f3++];
					InitPolyF3(icell,
						   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
						   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
						   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
						   color->r, color->g, color->b);
					if (mb) {
						InitPolyF3(&blur_f3[mb_idx][mb_f3[mb_idx]],
							   icell->x0,icell->y0,
							   icell->x1,icell->y1,
							   icell->x2,icell->y2,
							   icell->r0,icell->g0,icell->b0);
						SetSemiTrans(&blur_f3[mb_idx][mb_f3[mb_idx]],1);
						blur_f3_idx[mb_idx][mb_f3[mb_idx]++] = idx;
					}
				}
			} else { // Quadrangle
				if (idx > ztex) {
					POLY_FT4 *icell = &prim_ft4[nb_ft4++];
					setXY4(	icell,
						Mesh[poly[0]].vx, Mesh[poly[0]].vy,
						Mesh[poly[1]].vx, Mesh[poly[1]].vy,
						Mesh[poly[2]].vx, Mesh[poly[2]].vy,
						Mesh[poly[3]].vx, Mesh[poly[3]].vy);
					setUV4(	icell,
						data->u[0],data->v[0],
						data->u[1],data->v[1],
						data->u[2],data->v[2],
						data->u[3],data->v[3]);
					setRGB0(icell, color->r, color->g, color->b);
					icell->tpage = regTPage(obj->texID[data->texID]);
					icell->clut = regClut(obj->texID[data->texID]);
					SetShadeTex(icell, !rtl);
					prim=icell;
					if (mb) {
						InitPolyFT4(&blur_ft4[mb_idx][mb_ft4[mb_idx]],
							    icell->x0,icell->y0,
							    icell->x1,icell->y1,
							    icell->x2,icell->y2,
							    icell->x3,icell->y3,
							    icell->r0,icell->g0,icell->b0,
							    icell->u0,icell->v0,
							    icell->u1,icell->v1,
							    icell->u2,icell->v2,
							    icell->u3,icell->v3,
							    icell->tpage,icell->clut,!rtl);
						SetSemiTrans(&blur_ft4[mb_idx][mb_ft4[mb_idx]],1);
						blur_ft4_idx[mb_idx][mb_ft4[mb_idx]++] = idx;
					}
				} else {
					POLY_F4 *icell = prim = &prim_f4[nb_f4++];
					InitPolyF4(icell,
						   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
						   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
						   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
						   Mesh[poly[3]].vx, Mesh[poly[3]].vy,
						   color->r, color->g, color->b);
					if (mb) {
						InitPolyF4(&blur_f4[mb_idx][mb_f4[mb_idx]],
							   icell->x0,icell->y0,
							   icell->x1,icell->y1,
							   icell->x2,icell->y2,
							   icell->x3,icell->y3,
							   icell->r0,icell->g0,icell->b0);
						SetSemiTrans(&blur_f4[mb_idx][mb_f4[mb_idx]],1);
						blur_f4_idx[mb_idx][mb_f4[mb_idx]++] = idx;
					}
				}
			}
			} break;

		case TYPE_GT: {
			TPolyData *data = (TPolyData*)obj->data[f];
			static Color col[4];
			Color *color = data->color;
			if (rtl) {
				int i;
				for (i=0;i<dim;i++)
					CalcLight(slight[poly[i]],(idx > ztex ? &white : &color[i]),&col[i]);
				color = col;
			}
			if (dim==3) {
				if (idx > ztex) {
					POLY_GT3 *icell = prim = &prim_gt3[nb_gt3++];
					InitPolyGT3(icell,
						    Mesh[poly[0]].vx, Mesh[poly[0]].vy,
						    Mesh[poly[1]].vx, Mesh[poly[1]].vy,
						    Mesh[poly[2]].vx, Mesh[poly[2]].vy,
						    color[0].r, color[0].g, color[0].b,
						    color[1].r, color[1].g, color[1].b,
						    color[2].r, color[2].g, color[2].b,
						    data->u[0],data->v[0],
						    data->u[1],data->v[1],
						    data->u[2],data->v[2],
						    regTPage(obj->texID[data->texID]),
						    regClut(obj->texID[data->texID]));
					if (mb) {
						InitPolyGT3(&blur_gt3[mb_idx][mb_gt3[mb_idx]],
							    icell->x0,icell->y0,
							    icell->x1,icell->y1,
							    icell->x2,icell->y2,
							    icell->r0,icell->g0,icell->b0,
							    icell->r1,icell->g1,icell->b1,
							    icell->r2,icell->g2,icell->b2,
							    icell->u0,icell->v0,
							    icell->u1,icell->v1,
							    icell->u2,icell->v2,
							    icell->tpage,icell->clut);
						SetSemiTrans(&blur_gt3[mb_idx][mb_gt3[mb_idx]],1);
						blur_gt3_idx[mb_idx][mb_gt3[mb_idx]++] = idx;
					}
				} else {
					POLY_G3 *icell = prim = &prim_g3[nb_g3++];
					InitPolyG3(icell,
						   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
						   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
						   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
						   color[0].r, color[0].g, color[0].b,
						   color[1].r, color[1].g, color[1].b,
						   color[2].r, color[2].g, color[2].b);
					if (mb) {
						InitPolyG3(&blur_g3[mb_idx][mb_g3[mb_idx]],
							   icell->x0,icell->y0,
							   icell->x1,icell->y1,
							   icell->x2,icell->y2,
							   icell->r0,icell->g0,icell->b0,
							   icell->r1,icell->g1,icell->b1,
							   icell->r2,icell->g2,icell->b2);
						SetSemiTrans(&blur_g3[mb_idx][mb_g3[mb_idx]],1);
						blur_g3_idx[mb_idx][mb_g3[mb_idx]++] = idx;
					}
				}
			} else { // Quadrangle
				if (idx > ztex) {
					POLY_GT4 *icell = prim = &prim_gt4[nb_gt4++];
					InitPolyGT4(icell,
						    Mesh[poly[0]].vx, Mesh[poly[0]].vy,
						    Mesh[poly[1]].vx, Mesh[poly[1]].vy,
						    Mesh[poly[2]].vx, Mesh[poly[2]].vy,
						    Mesh[poly[3]].vx, Mesh[poly[3]].vy,
						    color[0].r, color[0].g, color[0].b,
						    color[1].r, color[1].g, color[1].b,
						    color[2].r, color[2].g, color[2].b,
						    color[3].r, color[3].g, color[3].b,
						    data->u[0],data->v[0],
						    data->u[1],data->v[1],
						    data->u[2],data->v[2],
						    data->u[3],data->v[3],
						    regTPage(obj->texID[data->texID]),
						    regClut(obj->texID[data->texID]));
					if (mb) {
						InitPolyGT4(&blur_gt4[mb_idx][mb_gt4[mb_idx]],
							    icell->x0,icell->y0,
							    icell->x1,icell->y1,
							    icell->x2,icell->y2,
							    icell->x3,icell->y3,
							    icell->r0,icell->g0,icell->b0,
							    icell->r1,icell->g1,icell->b1,
							    icell->r2,icell->g2,icell->b2,
							    icell->r3,icell->g3,icell->b3,
							    icell->u0,icell->v0,
							    icell->u1,icell->v1,
							    icell->u2,icell->v2,
							    icell->u3,icell->v3,
							    icell->tpage,icell->clut);
						SetSemiTrans(&blur_gt4[mb_idx][mb_gt4[mb_idx]],1);
						blur_gt4_idx[mb_idx][mb_gt4[mb_idx]++] = idx;
					}
				} else {
					POLY_G4 *icell = prim = &prim_g4[nb_g4++];
					InitPolyG4(icell,
						   Mesh[poly[0]].vx, Mesh[poly[0]].vy,
						   Mesh[poly[1]].vx, Mesh[poly[1]].vy,
						   Mesh[poly[2]].vx, Mesh[poly[2]].vy,
						   Mesh[poly[3]].vx, Mesh[poly[3]].vy,
						   color[0].r, color[0].g, color[0].b,
						   color[1].r, color[1].g, color[1].b,
						   color[2].r, color[2].g, color[2].b,
						   color[3].r, color[3].g, color[3].b);
					if (mb) {
						InitPolyG4(&blur_g4[mb_idx][mb_g4[mb_idx]],
							   icell->x0,icell->y0,
							   icell->x1,icell->y1,
							   icell->x2,icell->y2,
							   icell->x3,icell->y3,
							   icell->r0,icell->g0,icell->b0,
							   icell->r1,icell->g1,icell->b1,
							   icell->r2,icell->g2,icell->b2,
							   icell->r3,icell->g3,icell->b3);
						SetSemiTrans(&blur_g4[mb_idx][mb_g4[mb_idx]],1);
						blur_g4_idx[mb_idx][mb_g4[mb_idx]++] = idx;
					}
				}
			}
			} break;
	}
	SetSemiTrans(prim,st);
	AddPrim(ot+idx, prim);
}

void setZTex(int z) {
	ztex = z;
}

void Draw3D(ObjPos* scene, SVECTOR *light, u_long *ot) {
	static	MATRIX	mo;
	static	long	zvert[MAX_NBVERTS];
	static	Object3D *objs[MAX_NBOBJS];
	static	MATRIX	m[MAX_NBOBJS];
	static	u_char	semi[MAX_NBOBJS];
	static	u_char	mb[MAX_NBOBJS];

	int	i,k,l,z,a;
	long	trash;
	u_short dim,*poly;
	SObject *sobj;
	ObjPos	*p;

	InitCount();

	// Motion blur
	mb_idx = (mb_idx+1)%LEVEL_BLUR;
	InitMBCount();
	// end mb

	RotMatrix_gte(&scene->ang, &m[0]);
	ScaleMatrix(&m[0],&scene->scale);
	TransMatrix(&m[0], &scene->pos);
	objs[0] = (Object3D*)scene->obj;
	semi[0] = objs[0]->flags&FLAG_S;
	mb[0]   = objs[0]->flags&FLAG_MB;

	SetRotMatrix(&m[0]);
	SetTransMatrix(&m[0]);
	ApplyRotMatrix(light,&llight);

	i=1;
	for (a=0;a<i;a++) {
		for (l=0;l<objs[a]->type;l++) {
			p = &objs[a]->o.scene[l];
			objs[i] = (Object3D*)p->obj;
			semi[i] = semi[a] | (objs[i]->flags&FLAG_S);
			mb[i] = mb[a] | (objs[i]->flags&FLAG_MB);
			RotMatrix_gte(&p->ang, &mo);
			ScaleMatrix(&mo,&p->scale);
			TransMatrix(&mo, &p->pos);
			CompMatrix(&m[a],&mo,&m[i++]);
		}
	}

	memset(used,0,OTSIZE);

	l = 0;
	while (l<a) {
		while(objs[l]->type) l++;
		sobj = objs[l]->o.single;

		SetRotMatrix(&m[l]);
		SetTransMatrix(&m[l]);

		for (i=0;i<sobj->nbv;i++)
			RotTransPers(&sobj->vert[i],(long*)&Mesh[i],&zvert[i],&trash);

		if (objs[l]->flags&FLAG_L)
			for (i=0;i<sobj->nbv;i++) {
				ApplyRotMatrix(&sobj->v_normals[i],&vnorm[i]);
				slight[i] = PrepareLight(&llight,&vnorm[i]);
			}

        	for (i=0;i<sobj->nbp;i++) {
			u_char type = sobj->ptype[i];
			if ((type&FLAG_L)&&(type!=TYPE_LINE_F)&&(type!=TYPE_LINE_G))
				ApplyRotMatrix(&sobj->f_normals[i],&trans);
			else trans.vz = 0;
			if ((type&FLAG_V) || semi[l] || (type&FLAG_S) || (trans.vz<=0)) {
				dim = sobj->pdim[i];
				poly = sobj->polys[i];
				z = zvert[poly[0]];
				for (k=1;k<dim;k++) z += zvert[poly[k]];
				for (;k<4;k++) z += zvert[poly[0]];
				SetPrim(OTSIZE-1-(z>>OTZ),ot,i,sobj,semi[l]||(type&FLAG_S),mb[l]);
			}
		}

		l++;
	}

	// Motion blur
	a = mb_idx;
	do {
		if (--a<0) a = LEVEL_BLUR-1;
		for (i=0;i<mb_lf2[a];i++) AddPrim(ot+blur_lf2_idx[a][i], &blur_lf2[a][i]);
		for (i=0;i<mb_lf3[a];i++) AddPrim(ot+blur_lf3_idx[a][i], &blur_lf3[a][i]);
		for (i=0;i<mb_lf4[a];i++) AddPrim(ot+blur_lf4_idx[a][i], &blur_lf4[a][i]);
		for (i=0;i<mb_f3[a];i++)  AddPrim(ot+blur_f3_idx[a][i],  &blur_f3[a][i]);
		for (i=0;i<mb_f4[a];i++)  AddPrim(ot+blur_f4_idx[a][i],  &blur_f4[a][i]);
		for (i=0;i<mb_g3[a];i++)  AddPrim(ot+blur_g3_idx[a][i],  &blur_g3[a][i]);
		for (i=0;i<mb_g4[a];i++)  AddPrim(ot+blur_g4_idx[a][i],  &blur_g4[a][i]);
		for (i=0;i<mb_ft3[a];i++) AddPrim(ot+blur_ft3_idx[a][i], &blur_ft3[a][i]);
		for (i=0;i<mb_ft4[a];i++) AddPrim(ot+blur_ft4_idx[a][i], &blur_ft4[a][i]);
		for (i=0;i<mb_gt3[a];i++) AddPrim(ot+blur_gt3_idx[a][i], &blur_gt3[a][i]);
		for (i=0;i<mb_gt4[a];i++) AddPrim(ot+blur_gt4_idx[a][i], &blur_gt4[a][i]);
	} while (a!=mb_idx);
	// end mb
}
