function Forth(canvas) {
  this.data=[];
  this.Forth = '';
  this.maxd='16';
  this.rnd = '';
  this.rnd_use = 'float rand() { return fract(sin(mod(dot(p,vec2(12.9898,78.233)),3.14)) * t); }';
  this.demos = [];
  this.TEST = 1148;
  this.SIZE = 1576;
  this.CODE = 1052;
  this.SIZEPREFIX = 2673;
  this.IMAGEROOT = 1452;
  this.DEMONAME = 3256;
  this.DEMOAUTHOR = 3127;
  this.DEFEXT = 2217;
  this.AUTOCOMPILETIME = 2378;
  this.DICT = 1218;
  this.gl = canvas.getContext('webgl') || canvas.getContext('experimental-webgl');

  if(!this.gl) {
    alert("You need WebGL support!");
    return false;
  }
  this.gl.bindBuffer(this.gl.ARRAY_BUFFER, this.gl.createBuffer());
  this.gl.bufferData(this.gl.ARRAY_BUFFER, new Float32Array([-1,-1,3,-1,-1,3]), this.gl.STATIC_DRAW);
  this.PopPush = '\nvoid  pop(inout float a['+this.maxd+'], inout int k) { ';
  for(var m=0;m<this.maxd-1;m++) { 
    this.PopPush+='a['+m+']=a['+(m+1)+']; ';
  } this.PopPush+='a['+(this.maxd-1)+']=0.0; k--; }\nvoid push(inout float a['+this.maxd+'], inout int k, float num) { ';
  for(var m=this.maxd-1;m>0;m--) { 
    this.PopPush+='a['+m+']=a['+(m-1)+']; ';
  } this.PopPush+='a[0]=num; k++; }\n';

  var p='pop(d,i);'; this.words = words = []; 
  words['x']='push(d,i,x);';
  words['y']='push(d,i,y);';
  words['t']='push(d,i,t);';
  words['pi']='push(d,i,3.14159265358979323846);';
  words['sin']='d[0]=sin(d[0]);';
  words['cos']='d[0]=cos(d[0]);';
  words['tan']='d[0]=tan(d[0]);';
  words['atan2']='d[1]=atan(d[1], d[0]); '+p;
  words['log']='d[0]=log(abs(d[0]));';
  words['exp']='d[0]=exp(d[0]);';
  words['sqrt']='d[0]=sqrt(abs(d[0]));';
  words['floor']='d[0]=floor(d[0]);';
  words['ceil']='d[0]=ceil(d[0]);';
  words['abs']='d[0]=abs(d[0]);';
  words['negate']='d[0]=-d[0];';
  words['dup']='push(d,i,d[0]);';
  words['over']='push(d,i,d[1]);';
  words['2dup']='push(d,i,d[1]); push(d,i,d[1]);';
  words['drop']=p;
  words['swap']='tmp=d[0]; d[0]=d[1]; d[1]=tmp;';
  words['-rot']='tmp=d[0]; d[0]=d[1]; d[1]=d[2]; d[2]=tmp;';
  words['rot']='tmp=d[2]; d[2]=d[1]; d[1]=d[0]; d[0]=tmp;';
  words['=']='d[1]=(d[1]==d[0]?1.0:0.0); '+p;
  words['<>']='d[1]=(d[1]!=d[0]?1.0:0.0); '+p;
  words['<']='d[1]=(d[1]<d[0]?1.0:0.0); '+p;
  words['>']='d[1]=(d[1]>d[0]?1.0:0.0); '+p;
  words['<=']='d[1]=(d[1]<=d[0]?1.0:0.0); '+p;
  words['>=']='d[1]=(d[1]>=d[0]?1.0:0.0); '+p;
  words['and']='d[1]=(d[1]*d[0]!=0.0?1.0:0.0); '+p;
  words['or']='d[1]=(d[1]+d[0]!=0.0?1.0:0.0); '+p;
  words['not']='d[0]=(d[0]==0.0?1.0:0.0);';
  words['min']='d[1]=min(d[1],d[0]); '+p;
  words['max']='d[1]=max(d[1],d[0]); '+p;
  words['+']='d[1]+=d[0]; '+p;
  words['-']='d[1]-=d[0]; '+p;
  words['*']='d[1]*=d[0]; '+p;
  words['/']='d[1]/=d[0]; '+p;
  words['mod']='d[1]=mod(d[1],d[0]); '+p;
  words['pow']='d[1]=pow(abs(d[1]),d[0]); '+p; words['**']=words['pow'];
  words['z+']='d[2]+=d[0]; d[3]+=d[1]; '+p+' '+p;
  words['z*']='tmp=d[3]*d[0]+d[2]*d[1]; d[3]=d[3]*d[1]-d[2]*d[0]; d[2]=tmp; '+p+' '+p;
  words['push']='r[7]=r[6]; r[6]=r[5]; r[5]=r[4]; r[4]=r[3]; r[3]=r[2]; r[2]=r[1]; r[1]=r[0]; r[0]=d[0]; j++; '+p; words['>r']=words['push'];
  words['pop']='push(d,i,r[0]); r[0]=r[1]; r[1]=r[2]; r[2]=r[3]; r[3]=r[4]; r[4]=r[5]; r[5]=r[6]; r[6]=r[7]; r[7]=0.0; j--;'; words['r>']=words['pop'];
}

Forth.prototype.translate = function(Forth) {
  breakTranslation = false;
  document.onkeydown = 'breakTranslation = true;';
  var matches = [];
  while(Forth.match(exp = /:\s+([^\s]+)\s+([^\s]+|[^\s]+\s+[^\s]+)\s+;\s+/)!==null) {
    group = Forth.match(exp);
    Forth=Forth.replace((group=Forth.match(exp))[0], '').replace(j = new RegExp('(\\s+|^)'+group[1]+'(\\s+|$)','g'),'$1'+group[2]+'$2').replace(j,'$1'+group[2]+'$2');
  }
  var func = [], tmp = [], fs2 = [], comment = skip = f = false, name = rnd = '';
  for(i in arr = Forth.toLowerCase().replace(/\^/g, 'STEPEN').replace(/'/g, 'APOSTROPH').replace(/"/g, 'KAVICHKI').replace(/(\s+|^)\(\s+[^\)]+\)(\s+|$)/g, '$1').replace(/(\s+|^)\(\s+[^\)]+\)(\s+|$)/g, '$1').split(/\s/)) {
    word = f?tmp[i]:arr[i];
    if(skip) {
      f = true;
      skip=false;
      tmp = arr;
      arr = func;
      name = tmp[i];
      l = lastL = 0;
      arr[i] = 'void f_' + name + '(inout float d['+this.maxd+'], inout int i, inout float r[8], inout int j, float x, float y, float t, inout float tmp) {';
      tmp[i] = '';
      continue;
    }
    tmp[i] = '';
    if(+word == parseFloat(word)) { arr[i] = 'push(d,i,' + word + (word.match('\\.')?'':'.0') + ');'; continue; }
    if(word == ':' && i<arr.length) { arr[i]=''; skip=true; continue; }
    if(word == ';') { f = false; fs2[name] = true; arr[i] = '}'; func = arr; arr = tmp; continue; }
    if(fs2[word] == true) {
      arr[i] = 'f_' + word + '(d,i,r,j,x,y,t,tmp);';
      continue;
    }
    p='pop(d,i);';
    for(var u in words) {
      if(word == 'random') { arr[i] = 'push(d,i,rand());'; this.rnd = this.rnd_use; break; }
      if(word == u) { arr[i] = words[u]; break; }
    }
    if(breakTranslation) { document.onkeydown=''; return; }
  }
  this.MyShader = '';
  for(var i in arr) {
   var j = arr[i];
    this.MyShader += j;
    if(j!='' && i!=arr.length-1) { this.MyShader += '\n'; }
  }
  this.Functions = func.join('\n');
  document.onkeydown='';
}
Forth.prototype.createShader=function(str, type) {
  var sh = this.gl.createShader(type);
  this.gl.shaderSource(sh, str); this.gl.compileShader(sh);
  return sh;
}
Forth.prototype.update=function(str, demo) {
  this.translate(str);
  this.data.code.value=str;
  if(demo) {
    this.data.demoname.innerText=demo;
    this.data.demoauthor.innerText=this.demos[demo][2];
  }
  this.data.size.innerHTML=this.data.sizeprefix+str.length;
  this.gl.attachShader(program = this.gl.createProgram(), this.createShader('attribute vec2 pos; varying vec2 p;\nvoid main() { p = pos; gl_Position = vec4(pos, 0, 1); }', this.gl.VERTEX_SHADER));
  this.gl.attachShader(program, this.createShader('precision highp float; varying vec2 p; uniform float t;\n' + this.rnd + this.PopPush + this.Functions + '\nvoid main() { float d['+this.maxd+']; int i=0; d[0]=0.0; d[1]=0.0; d[2]=0.0; float r[8]; int j=0; float tmp; float x=(1.0+p.x)/2.0; float y=(1.0+p.y)/2.0;\n' + this.MyShader + '\ngl_FragColor = vec4((i==3?vec3(d[2], d[1], d[0]):(i==2?vec3(d[1], d[0], .0):(i==1?vec3(d[0], .0, .0):vec3(.0)))), 1.0); }', this.gl.FRAGMENT_SHADER));
  this.gl.linkProgram(program); this.gl.useProgram(program);
  program.vertexPosAttrib = this.gl.getAttribLocation(program, 'pos');
  this.gl.enableVertexAttribArray(program.vectrexPosAttrib);
  this.gl.vertexAttribPointer(program.vertexPosAttrib, 2, this.gl.FLOAT, false, 0, 0);
  program.t = this.gl.getUniformLocation(program, 't');
  t=this;
  clearInterval(this.interval); this.interval=setInterval(function () {
    t.gl.uniform1f(program.t, ((dt = new Date()).getHours() * 60 + dt.getMinutes()) * 60 + dt.getSeconds() + dt.getMilliseconds() / 1000.0);
    t.gl.drawArrays(t.gl.TRIANGLES, 0, 3);
  }, (this.Functions.match(/push\(d,i,t\)/)||this.MyShader.match(/push\(d,i,t\)/)||this.rnd)?30:500);
}
Forth.prototype.load=function(demo) {
  this.update(this.demos[demo][0], demo);
}
Forth.prototype.save=function(demo, code, img, author) {
  this.demos[demo]=[code, img, author];
}
Forth.prototype.list=function(list, myName) {
  for(var demo in this.demos) {
    if(demo==this.data.testname) { continue; }
    list.innerHTML+='<img src="'+this.data.imageroot+'/'+this.demos[demo][1]+(this.demos[demo][1].match('\\.')?'':'.'+this.data.defext)+'" title="'+demo+'" onclick="'+myName+'.load(\''+demo+'\')" style="cursor: pointer" width=64 height=64>';
  }
}
Forth.prototype.runTimeout=function(e) {
  if((e.keyCode>47&&e.keyCode<58)||
     (e.keyCode>64&&e.keyCode<91)||
     (e.keyCode>185&&e.keyCode<193)||
     e.keyCode==32||
     e.keyCode==8||
     e.keyCode==46||
     e.keyCode==220||
     e.keyCode==13||
     e.keyCode==222) {
    clearTimeout(this.timeout);
    t=this;
    this.timeout=setTimeout(function() { t.update(t.data.code.value); }, this.data.autocompile);
    return true;
  }
}
Forth.prototype.dict=function() {
  var d=this.data.dict;
  if(d.style.display=='none') {
    d.style.display='';
  } else {
    d.style.display='none';
  }
}
Forth.prototype.set=function(name,value) {
  if(name==this.CODE) { this.data.code=value; return; }
  if(name==this.SIZE) { this.data.size=value; return; }
  if(name==this.IMAGEROOT) { this.data.imageroot=value; return; }
  if(name==this.SIZEPREFIX) { this.data.sizeprefix=value; return; }
  if(name==this.DEMONAME) { this.data.demoname=value; return; }
  if(name==this.DEMOAUTHOR) { this.data.demoauthor=value; return; }
  if(name==this.TESTNAME) { this.data.testname=value; return; }
  if(name==this.DEFEXT) { this.data.defext=value; return; }
  if(name==this.AUTOCOMPILETIME) { this.data.autocompile=value; return; }
  if(name==this.DICT) { this.data.dict=value; return; }
}