
char *vidmem;
char Palet[256][3];


int readPCX(char *filename)
{
register int s1,s2,s3;
char *Buffer;
FILE *PcxFile;
int Readed,FileLength,DecodePos;

struct PCXFileHeader {
       char Manufacturer;                       //0x1
       char Version;                            //0x2
       char Encoding;                           //0x3
       char BitsPerPixel;                       //0x4
       unsigned short int StartX;                             //0x5
       unsigned short int StartY;                             //0x7
       unsigned short int EndX;                               //0x9
       unsigned short int EndY;                               //0xB
       unsigned short int HRes;                               //0xD
       unsigned short int VRes;                               //0xE
       char ColorMap[48];                       //0x10
       char Reserved1;                          //0x40
       char NPlanes;                            //0x41
       unsigned short int BytesPerLine;                       //0x42
       unsigned short int PaletteInfo;                        //0x44
       char Reserved2[58];                      //0x46
       } PCXHeader;

DecodePos = Readed = 0;
/*** Read PCX file to memory! ****/
PcxFile = fopen(filename,"rb");
if (!PcxFile) return -1;                          // file not found!

Readed = fread(&PCXHeader,sizeof(PCXHeader),1,PcxFile);
if (Readed != 1) return -2;             // not readable!

FileLength = filelength(fileno(PcxFile));
FileLength-= sizeof(PCXHeader);

if (PCXHeader.NPlanes == 1) FileLength-=768;

Buffer = (char *)malloc(FileLength);
if (!Buffer) return -3;

memset(Buffer,0,FileLength);

/*** Allocate required memory ****/
vidmem = (char *)malloc(PCXHeader.VRes*PCXHeader.HRes*(PCXHeader.NPlanes)+1512);
if (!vidmem) return -3;                                   //      ^^ guvenlik icin sonra kaldirilacak

PCXHeader.NPlanes--;

Readed = fread(Buffer,FileLength,1,PcxFile);
if (Readed != 1) return -2;          // not readable!

s1 = DecodePos = 0;
/// decode pcx to memory
while (1)
   {
   if (s1 >= FileLength) break;
   if (Buffer[s1] < 192)
      {
      vidmem[DecodePos] = Buffer[s1++];
      DecodePos++;
      } else
      {
      s2 = Buffer[s1++] ^ 192;
      for ( s3 = 0; s3 < s2; s3++)
          {
          vidmem[DecodePos] = Buffer[s1];
          DecodePos++;
          }
      s1++;
      }
   }

/*** Read Palette ****/
if (PCXHeader.NPlanes == 0)         // daha onceden bir azaltilmisti!
   {
//   fseek(PcxFile,sizeof(PCXHeader)+FileLength,SEEK_SET);
   fread(Palet,1,768,PcxFile);
   }
close(PcxFile);
return 0;
}
