﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using OpenTK.Graphics.OpenGL;

namespace Pixels3d
{
    /// <summary>
    /// Aborted attempt at vertex array rendering. Ran of time to get this plugged in and working. Maybe later...
    /// </summary>
    public class RenderBuffer
    {
        public RenderBufferVertexList VertexList = new RenderBufferVertexList();
        public RenderBufferColorList ColorList = new RenderBufferColorList();

        public void Render()
        {
            Vertex[] vertices = VertexList.ToArray();
            VertexColor[] colors = ColorList.ToArray();
            GL.VertexPointer(3, VertexPointerType.Float, 0, vertices);
            //GL.ColorPointer(3, ColorPointerType.Float, 0, );
            //GL.VertexAttribPointer(0, vertices.Length, VertexAttribPointerType.Float, false, sizeof(float)*3, vertices);
            //GL.Color3(1.0f, 1.0f, 1.0f);
            //GL.DrawElements(BeginMode.Quads, vertices.Length, );
            GL.EnableClientState(ArrayCap.VertexArray);
            GL.DrawArrays(BeginMode.Quads, 0, vertices.Length);
            GL.DisableClientState(ArrayCap.VertexArray);
        }

        public void Clear()
        {
            VertexList.Clear();
            ColorList.Clear();
        }

        public void AddVertex(Vertex vertex)
        {
            VertexList.Add(vertex);
        }

        public void AddColor(VertexColor color)
        {
            ColorList.Add(color);
        }

        public void AddColor(PixelColor color)
        {
            AddColor(new VertexColor(color.R, color.G, color.B));
        }
    }

    public class RenderBufferVertexList : List<Vertex>
    {
        
    }

    public class RenderBufferColorList : List<VertexColor>
    {

    }

    public struct VertexColor
    {
        public float R, B, G;

        public VertexColor(float r, float g, float b)
        {
            R = r;
            G = g;
            B = b;
        }
    }

    public struct Vertex
    {
        public float X, Y, Z;

        public Vertex(float x, float y, float z)
        {
            X = x;
            Y = y;
            Z = z;
        }
    }

}
