#include "../msys.h"
#include "../extra/msys_extra.h"
#include "3dHelpers.h"

GLbyte *gltLoadTGA(int resourceId, GLint *iWidth, GLint *iHeight, GLint *iComponents, GLenum *eFormat);
GLbyte *gltLoadPNG(int resourceId, GLint *iWidth, GLint *iHeight, GLint *iComponents, GLenum *eFormat);
GLbyte *gltLoadRGF(int resourceId, GLint *iWidth, GLint *iHeight, GLint *iComponents, GLenum *eFormat);
GLbyte *gltLoadJPG(int resourceId, GLint *iWidth, GLint *iHeight, GLint *iComponents, GLenum *eFormat);

void ViewOrtho(GLdouble width, GLdouble height);
void ViewPerspective();

float ColorByteToFloat(int byteVal);

void _glColor4f(color4f col);
void _glVertex3f(vertex *v);
void _glNormal3f(vertex *v);
void _glTexCoord2f(vertexTexCoord *v);
void _glTri(vertex *v1, vertex *v2, vertex *v3);
void _glTranslatef(vertex *v);
void _glTranslatefNeg(vertex *v);
void _glQuad(vertex *v1, vertex *v2, vertex *v3, vertex *v4);

void RotateVertexX(vertex *pInput, vertex *pOutput, float Angle);
void RotateVertexY(vertex *pInput, vertex *pOutput, float Angle);
void RotateVertexZ(vertex *pInput, vertex *pOutput, float Angle);
void RotateVertexXYZ(vertex *pInput, vertex *pOutput, float AngleX, float AngleY, float AngleZ);
void PerspectiveCorrect(vertex *pInput, int distance, int lens, int xScale, int yScale);
void GetFaceNormal(vertex *normal , vertex *v1, vertex *v2, vertex *v3);
void populateVertex(vertex* v, float x, float y, float z);
void populateVertex4(vertex4* v, float x, float y, float z, float w);
void populateColor3f(color3f* c, float r, float g, float b);
void populateColor4f(color4f* c, float r, float g, float b, float a);
void copyVertex(vertex* vDest, vertex* vSource);
void addVertex(vertex* vDest, vertex* vSource);
void divVertex(vertex* vDest, float amount);
void multVertex(vertex* vDest, float amount);
void blendVertex(vertex* vDest, vertex *v1, vertex *v2, float amount);
float blendValue(float valSource, float valDest, float amount);
void invertVertex(vertex* v);
void LogGlError();
void CrossProduct(vertex* out, vertex* v1, vertex* v2);

void lerpVertex(vertex* startVertex, vertex* endVertex, vertex* out, float percent);
void loadTexturePng(int resourceId, GLuint* textureId);

// errors
void CheckGlError();