uniform sampler2D texture; 
uniform vec2 resolution;
uniform float time; 
uniform int value; 
uniform float deform_value; 

float plasma_angle1=0.11; 
float plasma_angle2=0.05; 
float plasma_angle3=0.09; 
float plasma_angle4=0.13;

float PI=3.14159265358979323846; 
float lens=PI/deform_value; 
  
float v=1.0; 
 
vec2 deform(in vec2 p) 
{ 
	float radius=1.0; 
	float zoom=radius*cos(p.x*PI/lens)+radius*cos(p.y*PI/lens); 
	return vec2(p.x*zoom-0.5,p.y*zoom-0.5); 
} 
 
void main(void) 
	{ 
	vec2 p=-1.0+2.0*gl_TexCoord[0].xy; 
 
	p=deform(p); 
 
	vec3 color; 
	float r,b,c; 

	float timeVal = time;
 
	float plasma_a=p.x*cos(p.x*plasma_angle1+timeVal*0.0625); 
	float plasma_b=p.x*sin(p.x*plasma_angle2+timeVal*0.0250); 
	float plasma_c=p.y*cos(p.y*plasma_angle3+timeVal*0.0375); 
	float plasma_d=p.y*sin(p.y*plasma_angle4+timeVal*0.0500); 
 
	float a_a=p.x*cos(plasma_a+plasma_b+timeVal*(plasma_angle1-plasma_angle2))*0.875; 
	float a_b=p.y*sin(plasma_b+plasma_c+timeVal*(plasma_angle3-plasma_angle4))*0.750; 
	float a_c=p.x*cos(plasma_c+plasma_d+timeVal*(plasma_angle1-plasma_angle3))*1.500; 
	float a_d=p.y*sin(plasma_d+plasma_a+timeVal*(plasma_angle2-plasma_angle4))*0.625; 
	float a_e=(p.x*plasma_angle1*a_a+v)*cos(p.x*plasma_angle2*a_b); 
	float a_f=(p.y*plasma_angle3*a_c+v)*sin(p.y*plasma_angle4*a_d); 
	float a1=0.25*cos(a_a-a_c); 
	float a2=0.25*sin(a_b-a_d); 
	float a3=0.25*cos(a_e); 
	float a4=0.25*sin(a_f); 
 
	r=a1+a2-a3+a4; 
	b=-a1-a2+a3; 
 
	if(value==0) 
	{ 
		color=texture2D(texture,vec2(r,b)*2.0).xyz; 
	}else{ 
		color=texture2D(texture,vec2(r*cos(PI*p.x),b*cos(PI*p.y))).xyz; 
	} 
 
	color=color*color; 
	c=(color.r+color.g+color.b)*2.0; 
	color=vec3(c+r*0.5,c-(r+b)*0.5,c+b*0.5); 
 
	gl_FragColor=vec4(color,1.0); 
	} 
