#include "scroller.h"

char scrolltext [] = 
"hi, this is neriakX on the keys... only 2 months went by and I'm just taking part in making a wonderful demo! "
"I'm really proud of this great and fun cooperation with Raizor and want to thank him and everyone on dbf interactive for being such great guys. "
"the demoscene will never die!                                                    "
"This is Raizor on the keys... This is an attempt at some kind of solar system with a sun and some planets done in OpenGL and GLSL, "
"exploring the phenomena of God Rays (or in this case solar rays). "
"As always I've had a lot of fun putting this together and learnt a lot of cool new tricks! "
"Hopefully you guys like it too... "
"Big thanks for NeriakX for the great tune and the help with putting this together! "
"Now a bit about what's actually going on. "
"Each of the planets is a texture mapped sphere created by tesselating an icosahedron (20 face shape). "
"The sun and planets are drawn as silhouettes to an FBO (Framebuffer object), "
"basically just an off-screen rendering surface with an associated texture. "
"The sun is actually drawn normally (rather than black) and a pixel shader then "
"works some magic to produce a texture with godrays from the sun to the occluding objects "
"(in this case, the planets). The processed texture is then blended with the scene to create the effect. "
" The sun-spots proved to be a bit of a nightmare and didn't quite work out as I'd hoped, they take too "
" much processing at the moment, so I may revisit that in future. "
" Anyway, thanks for watching!     "
"                  "
"Special thanks to Hellfire and Ferris for the tips that helped me get this finished - you guys are a mine of cool OpenGL knowledge! :) "
"\0";

scroller::scroller(bmFont* theFont)
{
	font = theFont;
	numChars =0;

	offset =1000;

	char* t = scrolltext;	

	vertices = new vertexStack(100000);
	texCoords = new texCoordStack(100000);
	indices = new indexStack(100000);
	float xOffset = 0;
	t = scrolltext;	
	GLuint indexCounter = 0;
	while(*t)
	{
		int c=*t;		
		bmFontChar *ch = font->GetCharDetails((char)c);
		vertexTexCoord tc[4];
		tc[0].u = ch->_uBL;
		tc[0].v = ch->_vBL;

		tc[1].u = ch->_uTL;
		tc[1].v = ch->_vTL;

		tc[2].u = ch->_uTR;
		tc[2].v = ch->_vTR;

		tc[3].u = ch->_uBR;
		tc[3].v = ch->_vBR;

		texCoords->push(&tc[0]);
		texCoords->push(&tc[1]);
		texCoords->push(&tc[2]);
		texCoords->push(&tc[3]);

		float scale = 1.0f;

		float y = 0;
		y-=(ch->_Height+ch->_YOffset)*scale;

		float y2 = y+(ch->_Height*scale);
		float z = 0.75f;


		vertex v[4];
		populateVertex(&v[0], xOffset, y2, z);
		populateVertex(&v[1], xOffset, y, z);
		populateVertex(&v[2], xOffset+ch->_Width, y, z);
		populateVertex(&v[3], xOffset+ch->_Width, y2, z);

		for(int i=0; i<4; i++)
		{
			//v[i].y +=(ch->_YOffset);
		}
		
		vertices->push(&v[0]);
		vertices->push(&v[1]);
		vertices->push(&v[2]);
		vertices->push(&v[3]);

		xOffset+=(ch->_XAdvance*1.0f);
		numChars++;
		t++;

		indices->push(indexCounter++);
		indices->push(indexCounter++);
		indices->push(indexCounter++);
		indices->push(indexCounter++);
	}

	oglGenBuffersARB(3, &vboId[0]);

	// upload vertex data to vbo
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, vboId[0]);
	oglBufferDataARB(GL_ARRAY_BUFFER_ARB, vertices->count*sizeof(float)*3, vertices->items, GL_STATIC_DRAW_ARB);
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);

	// upload texcoord data to vbo
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, vboId[1]);
	oglBufferDataARB(GL_ARRAY_BUFFER_ARB, texCoords->count*sizeof(float)*2, texCoords->items, GL_STATIC_DRAW_ARB);
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);
}


void scroller::Draw(float time)
{
	glDisable(GL_DEPTH_TEST);
	glMatrixMode(GL_MODELVIEW);

	GLenum e = glGetError();

	glColor4f(1,1,1,0.5f);

	glPushMatrix();
	{
		glEnable(GL_TEXTURE_2D);
		glEnable(GL_BLEND);
		glBindTexture(GL_TEXTURE_2D, font->Texturemap);
		glLoadIdentity();
		glTranslatef(0,0,-4);
		glTranslatef(offset,-0.6f,0);
		offset=-((time-85)*0.2f);
		
		glDisableClientState(GL_INDEX_ARRAY);
		glDisableClientState(GL_NORMAL_ARRAY);

		glEnableClientState(GL_VERTEX_ARRAY);	
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);

		oglBindBufferARB( GL_ARRAY_BUFFER_ARB, vboId[1] );
		glTexCoordPointer(2, GL_FLOAT, 0, 0);

		oglBindBufferARB( GL_ARRAY_BUFFER_ARB, vboId[0] );
		glVertexPointer(3, GL_FLOAT, 0, 0);	

		GLuint soffset = 0;
		GLuint startIndex=0;
		GLuint endIndex = startIndex+800;
		

		glDrawArrays(GL_QUADS, startIndex, vertices->count);

		glDisableClientState(GL_VERTEX_ARRAY);
		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
	}
	glPopMatrix();

	glColor4f(1,1,1,1.0f);

	glEnable(GL_DEPTH_TEST);

	 e = glGetError();

}

scroller::~scroller(void)
{
}
