#pragma once

#include "../resources/resource.h"
#include "../sys/shaders/Shader.h"
#include "bmFont.h"
#include "bmFontChar.h"
#include "bmFontMaker.h"
#include "../planets/stacks.h"

typedef struct textObj
{
	int length;
	bmFontChar **chars;
	float width;
	vertex posStart;
	vertex posCurrent;
	vertex posPosEnd;
	float scale;
	float startTime;
	float endTime;
	float fadeThreshold;
}textObj;

class introText
{
	int numTextObjects;
	textObj **_textObjs;
	void introText::addTextObj(int index, char* text, float lineHeight, float* startTime, float length, float startTimeInc);
	textObj* introText::makeTextObj(char* txt, float scale);
	void introText::DrawString(char* str, vertex pos);
	void introText::DrawTextObjects(float time);
public:
	introText(bmFont* theFont);
	void introText::DrawTextObject(textObj* obj, float time);
	bmFont* font;
	void introText::Draw(float time);
	~introText(void);
};
