#include "introText.h"

textObj* introText::makeTextObj(char* txt, float scale)
{
	textObj *t = new textObj();
	t->scale = scale;
	t->chars = new bmFontChar*[strlen(txt)];
	int idx = 0;
	float width = 0;
	while(*txt)
	{
		bmFontChar *ch = font->GetCharDetails(*txt);
		t->chars[idx] = ch;
		width+=(ch->_XAdvance*scale);
		txt++;
		idx++;
	}
	t->width = width;
	t->length = idx;
	return t;
}

void introText::addTextObj(int index, char* text, float lineHeight, float* startTime, float length, float startTimeInc)
{
	_textObjs[index] = makeTextObj(text, 10.0f);
	textObj *obj = _textObjs[index];
	obj->startTime = *startTime;
	obj->endTime = *startTime+length;
	obj->fadeThreshold = 0;

	float centerX = -(obj->width/2);
	float centerY = (1.0f-lineHeight);

	populateVertex(&obj->posStart, centerX, 0, -50);
	populateVertex(&obj->posPosEnd, centerX, 0, 10);

	*startTime += startTimeInc;
}

introText::introText(bmFont* theFont)
{
	font = theFont;

	float lineHeight = 120*theFont->PixelHeight;

	_textObjs = new textObj*[100];

	// 0

	int objIndex = 0;

	float startTime = 4;
	float length = 4;
	float startTimeInc = 4;

	addTextObj(objIndex++, "H E R E   C O M E S   T H E   S U N", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "a dbf phenomena challenge entry", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "code: raizor", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "music: neriakX", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "greetings to", lineHeight, &startTime, length, startTimeInc);

	startTimeInc = 0.8f;
	length = 0.7f;

	addTextObj(objIndex++, "shockwave", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "hellfire", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "ferris", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "padman", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "jim", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "rbz", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "benny", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "combatking", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "hotshot", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "littlewhite", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "effecto", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "kirl", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "jace", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "pot noodle", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "dr.death", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "dark coder", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "moroboshisan", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "vain", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "pixel outlaw", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "slinks", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "relsoft", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "clyde", lineHeight, &startTime, length, startTimeInc);
	addTextObj(objIndex++, "zawran", lineHeight, &startTime, length, startTimeInc);
	startTimeInc = 5.0f;
	addTextObj(objIndex++, "... and you ...", lineHeight, &startTime, length, startTimeInc);

	numTextObjects = objIndex;

}

void introText::DrawTextObjects(float time)
{
	for(int i=0; i<numTextObjects; i++)
	{
		textObj *to = _textObjs[i];
		if (time >= to->startTime && time <= to->endTime)
		{
			DrawTextObject(to, time);
		}
	}
}

void introText::DrawTextObject(textObj* obj, float time)
{
	float xOffset = 0;

	float amount = obj->endTime - obj->startTime;
	float amountCurrent = obj->endTime - time;

	float pct = amountCurrent/amount;
	lerpVertex(&obj->posStart, &obj->posPosEnd, &obj->posCurrent, pct);

	glColor4f(1,1,1,pct);

	for(int i=0; i<obj->length; i++)
	{
		bmFontChar *ch = obj->chars[i];
	
		vertexTexCoord tc[4];
		tc[0].u = ch->_uBL;
		tc[0].v = ch->_vBL;

		tc[1].u = ch->_uTL;
		tc[1].v = ch->_vTL;

		tc[2].u = ch->_uTR;
		tc[2].v = ch->_vTR;

		tc[3].u = ch->_uBR;
		tc[3].v = ch->_vBR;

		float y = 0;
		y-=(ch->_Height+ch->_YOffset);

		float y2 = y+(ch->_Height);

		y*=obj->scale;
		y2*=obj->scale;

		vertex v[4];
		populateVertex(&v[0], obj->posCurrent.x+xOffset, y2+obj->posCurrent.y, obj->posCurrent.z);
		populateVertex(&v[1], obj->posCurrent.x+xOffset, y+obj->posCurrent.y, obj->posCurrent.z);
		populateVertex(&v[2], obj->posCurrent.x+xOffset+ch->_Width*obj->scale, y+obj->posCurrent.y, obj->posCurrent.z);
		populateVertex(&v[3], obj->posCurrent.x+xOffset+ch->_Width*obj->scale, y2+obj->posCurrent.y, obj->posCurrent.z);

		xOffset+=(ch->_XAdvance*obj->scale);

		for(int i=0; i<4; i++)
		{
			_glTexCoord2f(&tc[i]);
			_glVertex3f(&v[i]);
		}
	}
	glColor4f(1,1,1,1);
}

void introText::DrawString(char* str, vertex pos)
{
	float xOffset = 0;

	while(*str)
	{
		bmFontChar *ch = font->GetCharDetails(*str);

		vertexTexCoord tc[4];
		tc[0].u = ch->_uBL;
		tc[0].v = ch->_vBL;

		tc[1].u = ch->_uTL;
		tc[1].v = ch->_vTL;

		tc[2].u = ch->_uTR;
		tc[2].v = ch->_vTR;

		tc[3].u = ch->_uBR;
		tc[3].v = ch->_vBR;

		float scale = 1.0f;

		float y = 0;
		y-=(ch->_Height+ch->_YOffset)*scale;

		float y2 = y+(ch->_Height*scale);

		vertex v[4];
		populateVertex(&v[0], pos.x+xOffset, y2+pos.y, pos.z);
		populateVertex(&v[1], pos.x+xOffset, y+pos.y, pos.z);
		populateVertex(&v[2], pos.x+xOffset+ch->_Width, y+pos.y, pos.z);
		populateVertex(&v[3], pos.x+xOffset+ch->_Width, y2+pos.y, pos.z);

		xOffset+=(ch->_XAdvance*1.0f);

		for(int i=0; i<4; i++)
		{
			_glTexCoord2f(&tc[i]);
			_glVertex3f(&v[i]);
		}

		str++;

	}
}

void introText::Draw(float time)
{
	glPushMatrix();
	{
		glLoadIdentity();
		glBindTexture(GL_TEXTURE_2D, font->Texturemap);
		
		glEnable(GL_TEXTURE_2D);
		//glDisable(GL_DEPTH_TEST);
		glDisable(GL_LIGHTING);
		glEnable(GL_BLEND);

		glBegin(GL_QUADS);
		{
			/*
			vertex v;
			populateVertex(&v, 0, 0, -5);
			DrawString("HERE COMES THE SUN", v);	*/
			DrawTextObjects(time);
		}		
		glEnd();
		
		glDisable(GL_BLEND);		
		glEnable(GL_LIGHTING);
		//glEnable(GL_DEPTH_TEST);
		glDisable(GL_TEXTURE_2D);
		

	}
	glPopMatrix();
}

introText::~introText(void)
{
}
