#include "bmFont.h"
#include "../sys/msys.h"
#include "../sys/extra/msys_extra.h"

bmFont::bmFont(int textureResourceId)
{
	font = (bmFontChar*)msys_mallocAlloc(sizeof(bmFontChar) * 256);
	// handle texture
	// create texture from resource
	GLint icomps;
	GLenum eFormat;
	GLbyte *pixels = gltLoadPNG(textureResourceId, &_textureWidth, &_textureHeight, &icomps, &eFormat );
	glGenTextures(1,&Texturemap);
	glBindTexture(GL_TEXTURE_2D,Texturemap);
	glTexImage2D(GL_TEXTURE_2D, 0, icomps, _textureWidth, _textureHeight, 0, eFormat, GL_UNSIGNED_BYTE, pixels );
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER, GL_LINEAR); // Linear Filtering
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER, GL_LINEAR); // Linear Filtering
	msys_mallocFree(pixels);
	PixelWidth = 1.0f / _textureWidth;
	PixelHeight = 1.0f / _textureWidth;
}

void bmFont::AddChar(unsigned char charVal, int x, int y, int width, int height, int xOff, int yOff, int xAdvance)
{
	font[charVal] = bmFontChar(charVal, x, y, width, height, xOff, yOff, xAdvance, _textureWidth, _textureHeight);
}

void bmFont::DrawString(char* str, float x, float y, float scale, float aspectRatio, float time)
{
	x-=time/2;

	glBegin(GL_QUADS);

	int len = strlen(str);
	for(int i=0; i<len; i++)
	{
		bmFontChar *ch = &font[str[i]];
		this->_DrawChar(ch, x, y, scale, aspectRatio, 1.0f);
		x+=(ch->_XAdvance*0.9f)*scale*aspectRatio;
	}
}

bmFontChar* bmFont::GetCharDetails(char charVal)
{
	return &font[charVal];
}

void bmFont::_DrawChar(bmFontChar *ch, float x, float y, float scale, float aspectRatio, float alpha)
{
	float x1, y1;
	float x2, y2;

	//x+=ch->_XOffset;
	//y+=(104/this->_textureWidth)-(ch->_Height);

	//y+=(104/this->_textureWidth)-(ch->_YOffset);


	x+=ch->_XOffset*scale*aspectRatio;
	y-=(ch->_Height+ch->_YOffset)*scale;

	x1 = x;
	y1 = y;
	x2 = x+(ch->_Width*scale*aspectRatio);	
	y2 = y+(ch->_Height*scale);

	//glColor3f(1.0f, 0.0f, 0.0f);
	glTexCoord2f( ch->_uBL,  ch->_vBL);
	glVertex3f  ( x1,  y2,  0.0f);


	//glColor3f(0.0f, 1.0f, 0.0f);
	glTexCoord2f( ch->_uTL,  ch->_vTL);
	glVertex3f  ( x1,  y1,  0.0f);


	//glColor3f(0.0f, 0.0f, 1.0f);
	glTexCoord2f( ch->_uTR,  ch->_vTR);
	glVertex3f  ( x2,  y1,  0.0f);


	//glColor3f(1.0f, 1.0f, 1.0f);
	glTexCoord2f( ch->_uBR,  ch->_vBR);
	glVertex3f  ( x2,  y2,  0.0f);
}

void bmFont::DrawStart()
{
	glMatrixMode( GL_MODELVIEW );
	glPushMatrix();
	glLoadIdentity( );
	glBindTexture(GL_TEXTURE_2D,Texturemap);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	glTranslatef( 0.0, 0.0, -3.0 );
	//glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_BLEND);
	//glBlendFunc(GL_SRC1_ALPHA, GL_ONE_MINUS_CONSTANT_ALPHA);
	glEnable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);
}

void bmFont::DrawEnd()
{
	glEnd();
	glDisable(GL_TEXTURE_2D);
	glPopMatrix();
}

void bmFont::DrawChar(char charVal, float x, float y, float scale, float aspectRatio, float alpha)
{
	bmFontChar *ch = &font[charVal];
	_DrawChar(ch, x, y, scale, aspectRatio, alpha);

}

void bmFont::Test()
{
	
	glMatrixMode( GL_MODELVIEW );
	glPushMatrix();
	glLoadIdentity( );
	glBindTexture(GL_TEXTURE_2D,Texturemap);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	glTranslatef( 0.0, 0.0, -2.0 );
	//glTexEnvi(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_BLEND);
	//glBlendFunc(GL_SRC1_ALPHA, GL_ONE_MINUS_CONSTANT_ALPHA);
	glEnable(GL_TEXTURE_2D);
	glColor3f(1.0f, 1.0f, 1.0f);
	glBegin(GL_QUADS);

		//glColor3f(1.0f, 0.0f, 0.0f);
		glTexCoord2f( 0.0f,  0.0f);
		glVertex3f  ( 0.0f,  1.0f,  0.0f);
		

		//glColor3f(0.0f, 1.0f, 0.0f);
		glTexCoord2f( 0.0f,  1.0f);
		glVertex3f  ( 0.0f,  0.0f,  0.0f);
		

		//glColor3f(0.0f, 0.0f, 1.0f);
		glTexCoord2f( 1.0f,  1.0f);
		glVertex3f  ( 1.0f,  0.0f,  0.0f);
		

		//glColor3f(1.0f, 1.0f, 1.0f);
		glTexCoord2f( 1.0f,  0.0f);
		glVertex3f  ( 1.0f,  1.0f,  0.0f);
		
		

	glEnd();

	glBegin(GL_LINES);
		glColor3f(1.0f, 1.0f, 1.0f);
		glVertex3f(0.0f, 1.0f, 0.0f);
		glVertex3f(1.0f, 0.0f, 0.0f);
	glEnd();

	glDisable(GL_TEXTURE_2D);
	glPopMatrix();
}

bmFont::~bmFont(void)
{
}
