#pragma once
#include "../sys/msys.h"
#include "../sys/extra/msys_extra.h"
#include "stacks.h"

class tesSphere
{
private:
	GLuint vboId[3];
	int numVertices;
	vertexStack *vertices, *normals;
	texCoordStack *texCoords;
	indexStack *indices;
	float _radius;
	int _depth;
	void tesSphere::normalizev(vertex* v);
	void tesSphere::addTriangle(tesSphere *tSphere, vertex* V1, vertex* V2, vertex* V3);
	void tesSphere::calcTexCoord(vertex *P, vertexTexCoord *tc);
	void tesSphere::subDivide(tesSphere *tSphere, vertex* v1, vertex* v2, vertex* v3, int depth);
public:
	tesSphere(float radius, int depth);
	void tesSphere::Draw();
	~tesSphere(void);
};
