#pragma once

#include "../sys/msys.h"
#include "../sys/extra/msys_extra.h"
#include "tesSphere.h"
#include "../sys/shaders/Shader.h"
#include <GL/glu.h>

class planet
{
private:
	// distance from sun
	float _rotationSpeed;
	tesSphere* _tsphere;
	float _distanceFromParent;
	int _textureResourceId;
	int _numSats;
	bool _isSun;
	GLuint _textureMap;
	GLuint vboId[3];
	vertex* vertices;
	vertex* normals;
	GLuint *indices;
	GLfloat _radius;
	GLint _slices;
	GLint _stacks;
	void planet::HandleTexture();

	bool enabledSunspots;
	bool sunspotsFadingUp;
	float startTimeSunspots;
	
	float sunSpotsAlpha;

	// sun specific stuff
	GLuint textureSunspot1, textureSunspot2, textureFireGradient;
	GLint shaderSunspotsPass1, shaderSunspotsPass2, shaderSunspotsPass3, shaderSunspotsPass4a, shaderSunspotsPass4, shaderSunspotsPass5, shaderBloom;
	void planet::initSunspotTextures();
	void planet::initFboSun();
	void planet::HandleSunRotation(float time);
	void planet::DrawRenderedSunspots();

	bool enabledEffect;
	bool effectFadingUp;
	float startTimeEffect;

public:
	float distanceModifier;
	GLuint fboSunspotsPass1, depthTextureSunspotsPass1, fboTextureSunspotsPass1; // rotated 1
	GLuint fboSunspotsPass2, depthTextureSunspotsPass2, fboTextureSunspotsPass2; // rotated 2
	GLuint fboSunspotsPass3, depthTextureSunspotsPass3, fboTextureSunspotsPass3; // 1 + 2 (+ fire coloured)
	void planet::EnableSunSpots(float time);
	void planet::BlendAndBlur();
	void planet::InitSun();
	planet(GLfloat radius, GLint slices, GLint stacks, bool isSun, float distanceFromParent, int numSats, int textureResourceId, float rotationSpeed);
	planet **satellites;
	void DrawSunSpots(float time);
	void Draw(float time, bool onlyShadows);
	void createSolidSphere(GLdouble radius, GLint slices, GLint stacks);
	vertex planet::ScreenSpacePosition();
	~planet(void);
	void EnableEffect(float time);
};
