 // SUNSPOT PASS 3 FS
 // applies fire gradient texture to sunspot mask
 
 uniform sampler2D fireTexture;
 uniform sampler2D secondPassFboTexture;
 uniform float surfaceWidth;
 uniform float surfaceHeight;
 
 void main()
 {	
	vec2 screenXY = vec2(gl_FragCoord.s / surfaceWidth, gl_FragCoord.t / surfaceHeight);
	vec4 pixelSecondPass = texture2D(secondPassFboTexture, screenXY);
	vec4 colorVal = vec4(pixelSecondPass.rgba);
	
	if (colorVal.r > 0.0)
	{
		vec2 firePos = vec2(pixelSecondPass.r*0.99, 0.0);
		vec4 fireColor = texture2D(fireTexture , firePos);
		gl_FragColor = fireColor*2.0;	
	}
 }
 