#include "xscrollerChar.h"

xscrollerChar::xscrollerChar(xfontChar* xchar, char charValue, xfader* fader, int* table, int index1, int index2)
{
	thisCharValue = charValue;
	this->_xchar = xchar;
	this->_fader = fader;
	this->_colorIndex = fader->getRandomIndex();
	this->_sinTab = table;
	this->_sindex1 = index1;
	this->_sindex2 = index2;
}

void xscrollerChar::RenderPixelCube(int pixelNumber)
{
	col c = _fader->nextColorForIndex(this->_colorIndex);
	this->_colorIndex+=1250+pixelNumber;
	glBegin(GL_QUADS);
        glColor3f(c.r*.25f,c.g*.25f,c.b*.25f);
		glVertex3f( .5f, .5f,-.5f);
		glVertex3f(-.5f, .5f,-.5f);
		glVertex3f(-.5f, .5f, .5f);
		glVertex3f( .5f, .5f, .5f);

		glVertex3f( .5f,-.5f, .5f);
		glVertex3f(-.5f,-.5f, .5f);
		glVertex3f(-.5f,-.5f,-.5f);
		glVertex3f( .5f,-.5f,-.5f);

		glVertex3f( .5f, .5f, .5f);
		glVertex3f(-.5f, .5f, .5f);
		glVertex3f(-.5f,-.5f, .5f);
		glVertex3f( .5f,-.5f, .5f);

		glVertex3f( .5f,-.5f,-.5f);
		glVertex3f(-.5f,-.5f,-.5f);
		glVertex3f(-.5f, .5f,-.5f);
		glVertex3f( .5f, .5f,-.5f);

		glVertex3f(-.5f, .5f, .5f);
		glVertex3f(-.5f, .5f,-.5f);
		glVertex3f(-.5f,-.5f,-.5f);
		glVertex3f(-.5f,-.5f, .5f);

		glVertex3f( .5f, .5f,-.5f);
		glVertex3f( .5f, .5f, .5f);
		glVertex3f( .5f,-.5f, .5f);
		glVertex3f( .5f,-.5f,-.5f);
   glEnd();
   
   glBegin(GL_LINES);
		glColor3f(c.r,c.g,c.b);

		// front face
		glVertex3f(-0.5f, -0.5f,  0.5f);
		glVertex3f( 0.5f, -0.5f,  0.5f);
		glVertex3f(-0.5f,  0.5f,  0.5f);
		glVertex3f( 0.5f,  0.5f,  0.5f);		
		glVertex3f(-0.5f, -0.5f,  0.5f);
		glVertex3f(-0.5f,  0.5f,  0.5f);
		glVertex3f( 0.5f, -0.5f,  0.5f);
		glVertex3f( 0.5f,  0.5f,  0.5f);

		// back face
		glVertex3f(-0.5f, -0.5f, -0.5f);
		glVertex3f( 0.5f, -0.5f, -0.5f);
		glVertex3f(-0.5f,  0.5f, -0.5f);
		glVertex3f( 0.5f,  0.5f, -0.5f);		
		glVertex3f(-0.5f, -0.5f, -0.5f);
		glVertex3f(-0.5f,  0.5f, -0.5f);
		glVertex3f( 0.5f, -0.5f, -0.5f);
		glVertex3f( 0.5f,  0.5f, -0.5f);

		// connecting lines
		glVertex3f(-0.5f, -0.5f, -0.5f);
		glVertex3f(-0.5f, -0.5f,  0.5f);
		glVertex3f(-0.5f,  0.5f, -0.5f);
		glVertex3f(-0.5f,  0.5f,  0.5f);
	    glVertex3f( 0.5f,  0.5f, -0.5f);
		glVertex3f( 0.5f,  0.5f,  0.5f);
		glVertex3f( 0.5f, -0.5f, -0.5f);
		glVertex3f( 0.5f, -0.5f,  0.5f);
   glEnd();    
}

void xscrollerChar::Render(float offset, float ypos, float scale)
{
	bool doRender = true;
	if (offset > 50.0f || offset < -50.0f)
	{
		doRender = false;
	}
	for(int y=0; y<_xchar->height; y++)
	{
		for (int x=0; x<_xchar->width; x++)
		{
			int itemOffset = (x*_xchar->height) + y;
			if (doRender)
			{
				float sinVal = (float)(_sinTab[_sindex1] + _sinTab[_sindex2])/1.75f;
				float siny = sinVal / 80.0f;
				bool pixelFilled = _xchar->pixels[itemOffset];
				if (pixelFilled)
				{
					glPushMatrix();
					float zv = (sinVal) / 20.0f;
					glTranslatef(0.0f+x+offset, 0.0f+y-3.5f+ypos, zv);
					RenderPixelCube(itemOffset);
					glPopMatrix();
				}else{
					int x = 1;
				}
			}
		}

		_sindex2++;
		_sindex2 = _sindex2 % 511;
	}
	
	_sindex1++;
	_sindex1 = _sindex1 % 511;
}

int xscrollerChar::width()
{
	return _xchar->width;
}
	
xscrollerChar::~xscrollerChar(void)
{
}