//  ---------------------------------------------------------------------------
//  This file is part of Scenetone, a music player aimed for playing old
//  music tracker modules and C64 tunes.
//
//  Copyright (C) 2006  Jani Vaarala <flame@pygmyprojects.com>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//  --------------------------------------------------------------------------


// INCLUDE FILES
#include <coemain.h>
#include "ScenetoneAppView.h"
#include "scenetone3d.h"

#include <GULBORDR.H>
#include <GULUTIL.H>

#include <EIKENV.H>

#include <akndef.h>

// ============================ MEMBER FUNCTIONS ===============================

// -----------------------------------------------------------------------------
// CScenetoneAppView::NewL()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CScenetoneAppView* CScenetoneAppView::NewL( const TRect& aRect )
    {
    CScenetoneAppView* self = CScenetoneAppView::NewLC( aRect );
    CleanupStack::Pop( self );
    return self;
    }

// -----------------------------------------------------------------------------
// CScenetoneAppView::NewLC()
// Two-phased constructor.
// -----------------------------------------------------------------------------
//
CScenetoneAppView* CScenetoneAppView::NewLC( const TRect& aRect )
    {
    CScenetoneAppView* self = new ( ELeave ) CScenetoneAppView;
    CleanupStack::PushL( self );
    self->ConstructL( aRect );
    return self;
    }



// -----------------------------------------------------------------------------
// CScenetoneAppView::ConstructL()
// Symbian 2nd phase constructor can leave.
// -----------------------------------------------------------------------------
//

void CScenetoneAppView::ConstructL( const TRect& aRect )
{
    iScenetone3D = new CScenetone3D;

	iPlayText.Format(_L(" "));
    // Create a window for this application view
    CreateWindowL();

    // Set the windows size
   	SetRect( aRect );
	
    // Activate the window, which makes it ready to be drawn
    ActivateL();

    iScenetone3D->Construct(Window());
	iScenetone3D->UpdateViewport( Size().iWidth, Size().iHeight );
}

// -----------------------------------------------------------------------------
// CScenetoneAppView::CScenetoneAppView()
// C++ default constructor can NOT contain any code, that might leave.
// -----------------------------------------------------------------------------
//
CScenetoneAppView::CScenetoneAppView()
    {
    // No implementation required
    }


// -----------------------------------------------------------------------------
// CScenetoneAppView::~CScenetoneAppView()
// Destructor.
// -----------------------------------------------------------------------------
//
CScenetoneAppView::~CScenetoneAppView()
    {
    // No implementation required
    }


// -----------------------------------------------------------------------------
// CScenetoneAppView::Draw()
// Draws the display.
// -----------------------------------------------------------------------------
//
void CScenetoneAppView::Draw( const TRect& aRect ) const
    {
    // Get the standard graphics context
#if !defined(SCENETONE_INCLUDE_VISUALIZER)
    CWindowGc& gc = SystemGc();
    gc.SetPenStyle( CGraphicsContext::ENullPen );
    gc.SetBrushColor( TRgb(120,120,120) );
    gc.SetBrushStyle( CGraphicsContext::ESolidBrush );

    // Clears the screen
    gc.Clear( aRect );
    
    gc.UseFont( CEikonEnv::Static()->DenseFont() );
	gc.SetPenColor(KRgbWhite);
	
    // Draws the "currently playing" string
    gc.DrawText( iPlayText,  TPoint(10,20) );
#endif
}

// -----------------------------------------------------------------------------
// CScenetoneAppView::SizeChanged()
// Called by framework when the view size is changed.
// -----------------------------------------------------------------------------
//
void CScenetoneAppView::SizeChanged()
    {
#if defined(SCENETONE_INCLUDE_VISUALIZER)
    	iScenetone3D->UpdateViewport( Size().iWidth, Size().iHeight );
#else
	DrawNow();   
#endif
 }

TInt CScenetoneAppView::CountComponentControls() const
    {
	return 0;
    }

CCoeControl* CScenetoneAppView::ComponentControl( TInt aIndex ) const
    {
	//if( aIndex == 0)    return iProgress;
	//else                return NULL;
	return NULL;
    }

void CScenetoneAppView::HandleResourceChange(TInt aType)
{
	//if( aType == KEikDynamicLayoutVariantSwitch )
     //  	SetExtentToWholeScreen();
}
    
