#ifndef _DEMO1_H
#define _DEMO1_H
#ifdef __cplusplus
extern "C" {
#endif

extern unsigned char ycols[200];

extern SLONG midastime;
extern SLONG FrameTime;

extern UBYTE linecol;

extern unsigned char fontstr[];//="?!{}()-:;@+'abcdefghijklmnopqrstuvwxyz0123456789";
#define NUMCHARS (75-27) // (sizeof(fontstr)-1)
#define FONTWID 2400
#define FONTHGT 64
#define BLUREXTRA 16
#define AVGWID (128-BLUREXTRA*2)

extern unsigned char fontmap[256];
extern unsigned char *fontbmp;
typedef int CUMLET[FONTHGT+BLUREXTRA*2][AVGWID+BLUREXTRA*2];
extern CUMLET *cumlet;
extern unsigned char *fontptr[256];
extern int fontwid[256];

extern int currow;
extern int curord;
extern int curpat;
extern int curpos;
extern void CALLBACK UpdateInfo(void);

extern void line(int x1,int y1,int x2, int y2);


extern unsigned char cliptab128[256];
extern unsigned char cliptab[512];

extern void rotocopy(unsigned char *dest, unsigned char *src1, unsigned char *src2);	// src1blurred

struct P3D
{
	FVector p,rp;
	int px,py;

};

struct T3D
{
	int u,v,c;
	FVector n;	// normal
};

struct TRI
{
	P3D *a,*b,*c;
	T3D *ta,*tb,*tc;
	FVector n;
	int c1,c2,c3;	// colours
	TRI *next;
};

struct CAM
{
	FVector posn;
	FMatrix axes;
};


extern void spherepart();
extern void cubespart();

extern void init3d();
extern void close3d();
extern void startframe3d();

extern void loadfont();


extern void setpal(void *p);

extern void hblur(SLONG bmapwid, SLONG blurwid,
				  SLONG numdwords, SLONG numlines,
				  UBYTE *texture, UBYTE *dest,
				  UBYTE *fadetab,SLONG fadeinc, SLONG sizeoffadetab);
extern void setblurwid(int w);


extern unsigned char destpal[256][3];
extern float palpos,paldest,palspd;
extern int palrev,palupdate;

extern void faderfproc();
extern void setpalcol(int r,int g, int b, int flash=0);
extern void setpalwhite(int flash=0);
extern void setpalblack(int flash=0);
extern void setpalburn(int r,int g, int b, int flash=0);
extern void setpalgrey(int flash=0);
extern void setpalrev(int flash=0);

//////////////////////////////////////////////////////////////////

extern void calcynoise(unsigned char *o, int base=30, int blobp=6, int blobm=-4);
extern void ynoisefproc();
extern void ghosto(void *dest, void *src);

typedef int BOND[2];

struct _ATOM
{
	FVector p;
	float s;
	unsigned char a,idx,pad[2];
	// end of file stored stuff
	FVector rp;
	int px,py;
	float pf;
};

struct MOL
{
	int numa,numb;
	FVector min;
	FVector max;
	BOND *b;
	_ATOM *a;
	FMatrix axes;
	FVector posn;
	MOL() {};
	~MOL() {delete []a;delete []b;};
};

extern MOL *readmol(unsigned char *name);
extern void rotatemol(MOL *m, CAM *c, float sc=1);
extern void drawmol(MOL *m);
extern void drawmol2(MOL *m, int cc1,int cc2,float sf1, float sf2,int x1=0,int y1=0);


////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
// demo 2 and 3

extern int strwid(unsigned char *str);
extern void fontwrite(unsigned char *dest, unsigned char *str, int pitch);

typedef struct
{
	SBYTE nedge;
	SBYTE edge[12];
	SBYTE ntri;
	SBYTE tri[8][3];
} SUBCUBE;
extern SUBCUBE cubeinfo[256];

extern void calcmap();
extern void tracemap();
extern void makefpath();
extern void runfpath();
extern void calcfpath();

extern float getwibble(int i,float t );

extern void xfade(void*dest,void *src,int di, int si);
extern void compose(void*dest,void *src,void *tab);
extern void composesil(void*dest,void *src,void *tab);
extern void composelight(void*dest,void *src,void *tab);
extern void composedark(void*dest,void *src,void *tab);
extern void composelightdark(void*dest,void *src,void *tab);

extern void molpart();

extern CAM fpath[256];
extern int fpl;
extern int curfp;
extern unsigned char *fpname;
extern void processkey(unsigned char c, CAM *mycam);

extern void interpolate(float t,CAM *mycam);
extern void lazyinterpolate(float t,CAM *mycam);
extern void loadfp(unsigned char *fpname);

extern void calcsphere();

extern void makecubespartfp();

extern void nynaeve();
extern void pinblobpart();

extern void blurcum(void *dest, int *src, int xn, int yn, int xp, int yp, int f, int maxy=200, int sgned=0);
extern void makecum(int *dest, void *src,int maxy=200);

extern void saturatefproc();
extern void setupsaturatefproc();

extern void draworb(float ttm);
extern void loadorb(unsigned char *fn);

extern float frand(float f);

extern void babypart();

extern void title();

extern void calcwibblepins(float t,PIN *out=(PIN*)pin, int ymax=26);

extern void copy320to256(void *dest, void *src);

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
// new stuff?

extern void brainpart(int end);

extern void dnapart();

extern void ronipart();
extern void ronipart2();
extern void tunnelpart();

extern void clippins(int x1=0, int y1=0, int x2=256, int y2=256, PIN *out=(PIN*)pin);

extern void makerle(void *dest, void *src);
// src2 is reverse palette
extern void drawrle(void *dest, void *src, void *src2);

extern void makebjorkpath();


////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

struct BLOBV
{
	float u,v,s;
	FVector p,rp,n;
	int px,py;
	BLOBV *next;	// for hash table
	int used;

};

struct BLOBF
{
	BLOBV *a,*b,*c;
	BLOBF *next;
	BLOBF *next2;
	int used;
};


#define MAXBV 50000
#define MAXBF 100000
#define MAXHASH 1024
#define MAXBUK 2048

extern BLOBV *bv;
extern BLOBF *bf;
extern BLOBV *bvhash[MAXHASH];
extern BLOBF **buk;
extern int numbv,numbf;

extern int checkpolys();

extern int clip(int i);
//extern int light(float dot, float z);

extern void CALLBACK SyncCallback(unsigned syncNum, unsigned position, unsigned row);

extern float CFEEDBACK;
extern float DATAMIX;
extern float COMBMIX;
extern float DELAYMIX;

extern void loadraw(unsigned char *fname, void *dest, int w=320,int h=200, int nc=256, int fc=0, int sh=0);
extern void pinblob(CAM *cam, FMatrix *lcam, float ar, float br, float cr, float tt, float FOC, float shd);

extern void stoned();
extern void drawsphere2(CAM *cam, float vh);

extern void secretpart();

extern void writecam(CAM *c);

extern void killdct();
extern UBYTE *unpackimage(UBYTE *dest, LFILE *infi);

extern void fixpal(unsigned char *fname, int nc=256, int fc=0);

extern void testvideo();

extern void makestarpos(MOL *m,float t);
extern MOL *makestarmol();

extern void shit_init(void);
extern void shit(void);
extern void RadialBlur(unsigned char *dest, float fx, float fy, float f, float zoom);

extern void tub();

extern void cubespart2();
extern void softenpins(float a, int x1=0, int y1=0, int x2=256, int y2=256, PIN *out=(PIN*)pin, int ymax=26);



#ifdef __cplusplus
}
#endif
#endif
